/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.ftp;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FTPPlugin extends AbstractUIPlugin {
	public static final String ID = "org.eclipse.team.ftp"; //$NON-NLS-1$
	private static FTPPlugin instance;
	
	// boolean indicating
	private boolean fetchRemoteTimestampImmediately = false;
	
	/**
	 * Constructor for FTPProviderPlugin.
	 * @param descriptor
	 */
	public FTPPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		instance = this;
	}
	
	/**
	 * Returns the singleton plug-in instance.
	 * 
	 * @return the plugin instance
	 */
	public static FTPPlugin getPlugin() {
		return instance;
	}
	
	/**
	 * @see Plugin#startup()
	 */
	public void startup() throws CoreException {
		super.startup();
		Policy.localize("org.eclipse.team.internal.ftp.messages"); //$NON-NLS-1$
	}
	
	/**
	 * @see Plugin#shutdown()
	 */
	public void shutdown() throws CoreException {
		super.shutdown();
	}

	/**
	 * Returns the time (in seconds) to wait for establishing a PORT connection.
	 */
	public int getPortConnectionTimeout() {
		return 30;
	}
	
	public int getTimeout() {
		return 30;
	}
	
	public int getReceiveBufferSize() {
		return 32768;
	}
	
	public int getSendBufferSize() {
		return 32768;
	}
	
	/**
	 * Convenience method for logging TeamExceptions to the plugin log
	 */
	public static void log(TeamException e) {
		log(e.getStatus());
	}
	/**
	 * Convenience method for logging a status to the plugin log
	 */
	public static void log(IStatus status) {
		instance.getLog().log(status);
	}
	/**
	 * Convenience method for logging an internal error
	 */
	public static void logError(String message, Throwable e) {
		log(new Status(IStatus.ERROR, ID, 0, message, e));
	}

	public static FTPException wrapException(CoreException e) {
		return new FTPException(e.getStatus());
	}

	public static FTPException wrapException(Exception e) {
		return new FTPException(new Status(IStatus.ERROR, FTPPlugin.ID, 0, e.getMessage(), e));
	}
	
	/**
	 * Returns the fetchRemoteTimestampImmediately.
	 * @return boolean
	 */
	public boolean isFetchRemoteTimestampImmediately() {
		return fetchRemoteTimestampImmediately;
	}

	/**
	 * Sets the fetchRemoteTimestampImmediately.
	 * @param fetchRemoteTimestampImmediately The fetchRemoteTimestampImmediately to set
	 */
	public void setFetchRemoteTimestampImmediately(boolean fetchRemoteTimestampImmediately) {
		this.fetchRemoteTimestampImmediately = fetchRemoteTimestampImmediately;
	}

}
