/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.ui.target;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SiteExplorerViewLabelProvider extends WorkbenchLabelProvider implements ITableLabelProvider {

	public Image getColumnImage(Object element, int columnIndex) {
		if (columnIndex == 0) {
			return super.getImage(element);
		}
		return null;
	}
	public String getColumnText(Object element, int columnIndex) {		
		switch (columnIndex) {
			case 0 :
				return super.getText(element);
			case 1 :
				if(element instanceof RemoteResourceElement) {
					RemoteResourceElement remote = ((RemoteResourceElement)element);
					if(remote.getRemoteResource().isContainer()) {
						return ""; //$NON-NLS-1$
					}
					int size = remote.getSize();
					int sizeKb = size / 1000;
					if(sizeKb == 0 && size % 1000 > 0) {
						sizeKb = 1;
					}
     				return Policy.bind("SiteExplorerViewLabelProvider.fileSize", new Integer(sizeKb).toString());						 //$NON-NLS-1$
				}
			case 2 :
				if(element instanceof RemoteResourceElement) {
					return ((RemoteResourceElement)element).getLastModified();
				}
			case 3 :
				if(element instanceof RemoteResourceElement) {
					return ((RemoteResourceElement)element).getRemoteResource().getURL().toExternalForm();
				}
		}
		return ""; //$NON-NLS-1$
	}
}
