/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tomcat.internal;
import java.io.*;
import java.net.*;
/**
 * Tests connection to local server.
 */
public class LocalConnectionTest extends Thread {
	private static final int CLIENT_TIMEOUT = 1000;
	private String host;
	private int port;
	private boolean success;
	/**
	 * Constructor for LocalConnectionTest.
	 */
	private LocalConnectionTest(String host, int port) {
		super();
		this.host = host;
		this.port = port;
		success = false;
		setDaemon(true);
		setName("ServerInterfaceTest");
	}
	public void run() {
		Socket socket = null;
		try {
			socket = new Socket(host, port);
			success = true;

		} catch (IOException e) {
			try {
				if (socket != null)
					socket.close();
			} catch (IOException ioe) {
			}
		}
	}
	/**
	 * Tests connection to a local server
	 * by connecting to a given port using localy
	 * available interfaces.
	 * @return name of the first interface that connection
	 * to succeeded.
	 */
	public static String getLocalInterface(int port) {
		try {
			if (testInterface("127.0.0.1", port))
				return "127.0.0.1";
			String hostname = InetAddress.getLocalHost().getHostName();
			InetAddress[] addr = InetAddress.getAllByName(hostname);
			for (int i = 0; i < addr.length; i++) {
				// test all addresses retrieved from your system
				if (testInterface(addr[i].getHostAddress(), port))
					return addr[i].getHostAddress();
			}
		} catch (IOException ioe) {
			TomcatPlugin.logError(
				TomcatResources.getString(
					"LocalConnectionTest.cannotGetLocalhostName"),
				ioe);
		}
		return "localhost";
	}
	private static boolean testInterface(String host, int port) {
		LocalConnectionTest test = new LocalConnectionTest(host, port);
		test.start();
		try {
			test.join(CLIENT_TIMEOUT);
			return test.success;
		} catch (InterruptedException ie) {
		}
		test.interrupt();
		return test.success;
	}
}
