#!/usr/bin/python

from distutils.core import setup

import subprocess, glob, os.path

mo_files = []
# HACK: make sure that the mo files are generated and up-to-date
subprocess.call(["make", "-C", "po", "build-mo"])
for filepath in glob.glob("po/mo/*/LC_MESSAGES/*.mo"):
    lang = filepath[len("po/mo/"):]
    targetpath = os.path.dirname(os.path.join("share/locale",lang))
    mo_files.append((targetpath, [filepath]))

setup(
    name="envyng",
    author="Alberto Milone",
    author_email="albertomilone@alice.it",
    maintainer="Alberto Milone",
    maintainer_email="albertomilone@alice.it",
    url="http://www.albertomilone.com/nvidia_scripts1.html",
    license="gpl",
    description="install/uninstall the ATI or the NVIDIA driver",
    packages=["Envy"],
    data_files=[("share/man/man1", glob.glob("man/envyng.1")),
                ("share/lintian/overrides", glob.glob("overrides/envyng")),
                ("share/envy", glob.glob("*.run")),
                ("share/envy", glob.glob("interface.py")),
                ("share/envy", glob.glob("__init__.py")),
                ("share/envy", glob.glob("pulse.py")),
                ("share/envy", glob.glob("launcher")),
                ("share/icons/hicolor/16x16/apps/envyng.png", glob.glob("pixmaps/envyng16.*")),
                ("share/icons/hicolor/22x22/apps/envyng.png", glob.glob("pixmaps/envyng22.*")),
                ("share/icons/hicolor/32x32/apps/envyng.png", glob.glob("pixmaps/envyng32.*")),
                ("share/icons/hicolor/64x64/apps/envyng.png", glob.glob("pixmaps/envyng64.*")),
                ("share/icons/hicolor/128x128/apps/envyng.png", glob.glob("pixmaps/envyng128.*")),
                ("share/envy/pixmaps", glob.glob("pixmaps/*")),
                ("share/envy/applications", glob.glob("applications/*.desktop")),
               ] + mo_files,
    scripts=["envyng"],
)





