import warnings
warnings.simplefilter('ignore', FutureWarning)
import os
import apt
import apt_pkg
import aptsources
import aptsources.distro
from aptsources.sourceslist import SourcesList
from apt import SizeToStr
import subprocess
from subprocess import PIPE, Popen

import time
import sys
from sys import stderr, stdout

class HeadersException(Exception):
    '''
    Raise if no headers can be found and installed
    '''
    pass


class UiFetchProgress(apt.FetchProgress):
    '''
    The only purpose of this class is update the "percent"
    attribute of the object passed to the constructor
    '''
    def __init__(self, myobject=None, text=None):
        '''
        myobject is the UI class:
            * the class of the textual progress bar
            * the entire widget class for the GUIs which should have 2 methods:
                1) updateLabel(currentItems, totalItems)
                2) updateUi(percent)
        '''
        apt.FetchProgress.__init__(self)
        self.newObject = myobject
        self.isText = text
        self.percent = 0.0
    
    def start(self):
        if self.isText:
            print >> stderr, '\nDowloading the packages...'
        #print >> stderr, 'Starting Fetch process'
    
    def stop(self):
        pass
    
    def done(self, *args):
        pass
    
    def update(self, percent):
        self.percent = percent
        
    
    def updateStatus(self, uri, descr, shortDescr, status):
        if not self.isText:
            self.newObject.updateLabel(self.currentItems, self.totalItems)
        
        
    def pulse(self):
#        if self.isText:
#            print "\rCPS: %s/s; Bytes: %s/%s; Item: %s/%s\r" % (SizeToStr(self.currentCPS), SizeToStr(self.currentBytes), SizeToStr(self.totalBytes), self.currentItems, self.totalItems)
#            print type(self.currentBytes)
#            print type(self.totalBytes)
#        #self.newObject.percent = self.percent
##            print '\r %f' % (self.percent)
#        else:
        self.percent = ((self.currentBytes + self.currentItems)*100.0)/float(self.totalBytes+self.totalItems)
        percent = float("%.01f"% (self.percent))
#        if self.currentCPS > 0:
#            self.eta = (self.totalBytes-self.currentBytes)/float(self.currentCPS)
        
        self.newObject.updateUi(percent)
        
        return True

#    def mediaChange(self, medium, drive):
#        print "Please insert medium %s in drive %s" % (medium, drive)
#        sys.stdin.readline()
#        #return False


class UiInstallProgress(apt.InstallProgress):
    def __init__(self, myobject=None, text=None):
        apt.InstallProgress.__init__(self)
        self.newObject = myobject
        self.isText = text
        
    def startUpdate(self):
        pass
        #print "StartUpdate"
    def finishUpdate(self):
#        self.newObject.status = 1
#        print "FinishUpdate"
        pass
    def statusChange(self, pkg, percent, status):
        if self.isText:
            print "\r%s: %s" % (pkg, status)
            print '\r'
#        self.newObject.percent = percent
        else:
            self.newObject.updateUi(percent)
        
    def updateInterface(self):
        apt.InstallProgress.updateInterface(self)
        # usefull to e.g. redraw a GUI
        time.sleep(0.1)



class SilentProgress(apt.FetchProgress):
    '''
    The only purpose of this class is make apt silent
    '''
    def __init__(self):
        apt.FetchProgress.__init__(self)
        
        pass
    
    def start(self):
        pass
    
    def stop(self):
        pass
    
    def done(self, *args):
        pass
    
    def update(self, *args):
        pass
    
    def updateStatus(self, uri, descr, shortDescr, status):
        pass
    
    def pulse(self):
        pass


class PkgManager:
    def __init__(self, widget, text):
        self.widget = widget
        self.initialise(widget)
        self.isText = text
    
    def initialise(self, widget):
        os.environ['DEBIAN_FRONTEND'] = 'noninteractive' 
        os.environ['PATH'] = '/sbin:/usr/sbin:/bin:/usr/bin' 
        # init
        apt_pkg.init()

        progress = SilentProgress()
        self.cache = apt_pkg.GetCache(progress)
        self.cacheUi = apt.Cache(UiFetchProgress(widget))   

        # get depcache
        self.depcache = apt_pkg.GetDepCache(self.cache)
        self.depcache.ReadPinFile()
        # init is needed after the creation/pin file reading
        self.depcache.Init(progress)
        
        
        self.records = apt_pkg.GetPkgRecords(self.cache)
        self.sourcelist = apt_pkg.GetPkgSourceList()
    
    def getPkgInfo(self, packageName):
        '''
        it can return either the version or None
        '''
        try:
            pkgiter = self.cache[packageName]
            pkg = apt.package.Package(self.cache, self.depcache, self.records, self.sourcelist, None, pkgiter)
            installedVersion, candidateVersion = (pkg.installedVersion, pkg.candidateVersion)#, pkg.section, pkg.architecture) , section, architecture
        except KeyError:#the package doesn't exist
            installedVersion, candidateVersion = (None, None)#, None, None) , section, architecture 
        
        return [installedVersion, candidateVersion]#, section, architecture]
    
    def getPkgDeps(self, packageName):
        try:
            pkgiter = self.cache[packageName]
            pkg = apt.package.Package(self.cache, self.depcache, self.records, self.sourcelist, None, pkgiter)
#            installedVersion, candidateVersion, section = (pkg.installedVersion, pkg.candidateVersion, pkg.section)
            deps = [pkg.candidateDependencies, pkg.installedDependencies]
        except KeyError:#the package doesn't exist
            deps = None
        
        return deps
    
    def install(self, packages, widget):
#        self.initialise(widget)
        
        install = False
        
        for package in packages:
            try:
                pkg = self.cacheUi[package]
                pkg.markInstall()
                install = True
            except KeyError:
                pass
        
        if install:
            try:
                self.cacheUi.commit(UiFetchProgress(widget, self.isText), UiInstallProgress(widget, self.isText)) 
            except apt.cache.FetchCancelledException: 
                return False 
        #return True
    
    def reinstall(self, packages, widget):
#        self.initialise(widget)
        install = False
        
        for package in packages:
            try:
                pkg = self.cacheUi[package]
                self.cacheUi._depcache.SetReInstall(pkg._pkg, True)
                
                install = True
            except (KeyError, SystemError):
                '''
                NOTE: SystemError = the specific package version can't be found
                in the archive
                '''
                pass
        
        if install:
            try:
                self.cacheUi.commit(UiFetchProgress(widget, self.isText), UiInstallProgress(widget, self.isText))
            except apt.cache.FetchCancelledException: 
                return False 
        #return True
    
    def uninstall(self, packages, widget):
        self.initialise(widget)
        uninstall = False
        
        for package in packages:
            try:
                pkg = self.cacheUi[package]
                if pkg.isInstalled:
                    pkg.markDelete()
                    uninstall = True
            except KeyError:
                pass
        if uninstall:
            try:
                self.cacheUi.commit(None, UiInstallProgress(widget, self.isText))
            except apt.cache.FetchCancelledException: 
                return False 
        #return True
    
    def getDependencies(self, package):
        depObjects = self.getPkgDeps(package)
        if not depObjects:
            return False
        deps = depObjects[0]
        #print deps
        dependencies = []
        for dep in deps:
            #print ",".join(["%s (%s) (%s) (%s)" % (o.name,o.version,o.relation, o.preDepend) for o in dep.or_dependencies])
            dependencies.append([o.name for o in dep.or_dependencies][0])
        
        return dependencies
    
    def isDownloadable(self, package):
        try:
            pkgiter = self.cache[package]
            pkg = apt.package.Package(self.cache, self.depcache, self.records, self.sourcelist, None, pkgiter)
        except KeyError:#the package doesn't exist
            return False
        return pkg.candidateDownloadable#installedDownloadable#candidateDownloadable
    
    def isInstalled(self, package):
        try:
            pkgiter = self.cache[package]
            pkg = apt.package.Package(self.cache, self.depcache, self.records, self.sourcelist, None, pkgiter)
        except KeyError:#the package doesn't exist
            return False
        return pkg.isInstalled
    
    def packageSize(self, package):
        try:
            pkgiter = self.cache[package]
            pkg = apt.package.Package(self.cache, self.depcache, self.records, self.sourcelist, None, pkgiter)
        except KeyError:#the package doesn't exist
            return False
        
        return pkg.packageSize
        
    
    def checkDependencies(self, package, blacklist=[]):
        '''
        See if the dependencies were installed.
        
        NOTE: make sure virtual packages are ignored
        '''
        deps = self.getPkgDeps(package)
        
        
        #'nvidia-glx-173')
        deps = b[0]
        #print deps
        dependencies = []
        for dep in deps:
            #print ",".join(["%s (%s) (%s) (%s)" % (o.name,o.version,o.relation, o.preDepend) for o in dep.or_dependencies])
            dependencies.append([o.name for o in dep.or_dependencies][0])
        
        
        for pkg in dependencies:
            if pkg not in blacklist:
                if not self.isInstalled(pkg):
                    print pkg, 'is not installed'
                    print pkg, 'is downloadable?', self.isDownloadable(pkg)
                    return False
        return True
    
    def enableRepositories(self, repositories):
        '''
        repositories = a list of repositories to enable
        '''
        sourceslist = SourcesList()
        distro = aptsources.distro.get_distro()
        distro.get_sources(sourceslist)
        for repository in repositories:
            distro.enable_component(repository)
        sourceslist.save()
        
        #refresh the list of packages
        self.initialise()
    
    def checkRepositories(self, repositories):
        '''
        See if the desired repository is available, otherwise
        enable it
        '''
        pkgs = {'main': 'linux-generic',
                'restricted': 'nvidia-kernel-common',
                'universe': 'geany',
                'multiverse': 'flashplugin-nonfree'}
        
        toEnable = []
        
        for repository in repositories:
            toCheck = pkgs[repository]
            try:
                if self.cache[toCheck].candidateDownloadable:
                    pass
            except KeyError:
                toEnable.append(repository)
        
        if len(toEnable) > 0:
            self.enableRepositories(toEnable)
    
    def getUrl(self, package):
        try:
            pkgiter = self.cache[package]
            pkg = apt.package.Package(self.cache, self.depcache, self.records, self.sourcelist, None, pkgiter)
        except KeyError:#the package doesn't exist
            return False
        
        pkg._lookupRecord(True)
        path = apt_pkg.ParseSection(pkg._records.Record)["Filename"]
        pkgurl = 'http://archive.ubuntu.com/ubuntu/' + path
        
        return pkgurl
    
    def getHeadersName(self):
        kernel = os.uname()[2]
        defaultHeaders = 'linux-headers-' + kernel
        return defaultHeaders
    
    def getHeadersMetaName(self):
        flavour = os.uname()[2][os.uname()[2].rfind('-')+1:]
        defaultHeaders = 'linux-headers-' + flavour
        return defaultHeaders
    
    def checkHeaders(self):
        '''
        Make sure that the kernel headers are installed.
        
        * return False if they are not installed but can be
                 installed
        * return True if they are already installed
        * raise HeadersException if they are not installed
                 and cannot be installed
        '''
        kernel = os.uname()[2]
        compiledKernel = 'kernel-image-' + kernel
        defaultKernel = 'linux-image-' + kernel
        
        compiledHeaders = 'kernel-headers-' + kernel
        defaultHeaders = 'linux-headers-' + kernel
        
        if self.isInstalled(defaultKernel):
            if self.isInstalled(defaultHeaders):
                return True
            #print self.isDownloadable(defaultHeaders)
            elif self.isDownloadable(defaultHeaders):
                return False
            else:
                print str(self.isDownloadable(defaultHeaders))
                raise HeadersException
        
        print 'Compiled Kernel'
        if self.isInstalled(compiledKernel) and self.isInstalled(compiledHeaders):
            return True
        else:
            raise HeadersException
    
    def fixNvidiaInstaller(self, widget):
        packages = ['xserver-xorg-core', 'libgl1-mesa-glx']
        self.reinstall(packages, widget)
    
    def isLockAvailable(self):
        '''
        Return True if no instance of APT/DPKG is using the lock
        otherwise return False
        
        NOTE: this returns False if the lock is available but the program
        is launched without root privileges.
        '''
        # get lock
        lockfile = apt_pkg.Config.FindDir("Dir::Cache::Archives") + "lock"
        lock = apt_pkg.GetLock(lockfile)
        if lock < 0:
            return False
        return True
    
if __name__ == '__main__':
    a = PkgManager()
    b = a.getPkgDeps('nvidia-glx-173')#'nvidia-glx-173')
    deps = b[0]
    #print deps
    dependencies = []
    for dep in deps:
        #print ",".join(["%s (%s) (%s) (%s)" % (o.name,o.version,o.relation, o.preDepend) for o in dep.or_dependencies])
        dependencies.append([o.name for o in dep.or_dependencies][0])
    
    try:
        mesa = dependencies.index('libgl1-mesa')
        dependencies[mesa] = 'libgl1-mesa-glx'
    except IndexError:
        pass
    
    print dependencies
    for x in dependencies:
        if x == 'libgl1-mesa': x = 'libgl1-mesa-glx'
        print x, ':\n', a.getPkgInfo(x)
        print a.getUrl(x)
    
#    print 'Are the dependecies installed?', a.checkDependencies(dependencies)
    
    print 'Dependencies', a.getDependencies('xorg-driver-fglrx')#'nvidia-glx-173'
    
    print 'DKMS', a.isInstalled('dkms'), a.isDownloadable('dkms')
    
    print '\nHeaders check:', a.checkHeaders()
    
    print 'Is lock available?', a.isLockAvailable()
    
    print 'nvidia-glx-173 size:', a.packageSize('nvidia-glx-173')
    
    '''
    ['nvidia-173-kernel-source', 'x11-common', 'libc6', 'libgcc1', 'libgl1-mesa', 'libx11-6', 'libxext6', 'zlib1g']
    
    ['make', 'sed', 'dkms', 'linux-libc-dev', 'libc6-dev', 'linux-headers-generic']
    
    ##
    fglrx-kernel-source:
    ['make', 'dkms', 'linux-libc-dev', 'linux-headers']
    
    xorg-driver-fglrx:
    ['libc6', 'libfontconfig1', 'libfreetype6', 'libgcc1', 'libice6', 'libsm6', 'libx11-6', 'libxcursor1', 'libxext6', 'libxi6', 'libxrandr2',
     'libxrender1', 'xserver-xorg-core', 'fglrx-kernel-source']

    
    ##
    
    nvidia-173-kernel-source :
    ['173.14.12-0ubuntu3', '173.14.12-0ubuntu3', 'restricted/misc', 'i386']
    x11-common :
    ['1:7.4~1ubuntu1', '1:7.4~1ubuntu1', 'x11', 'all']
    
    x/xorg/
    
    libc6 :
    ['2.8~20080505-0ubuntu6', '2.8~20080505-0ubuntu6', 'base', 'i386']
    
    
    libgcc1 :
    ['1:4.3.1-9ubuntu1', '1:4.3.1-9ubuntu1', 'libs', 'i386']
    g/gcc-4.3
    
    libgl1-mesa-glx :
    ['7.1~rc3-1ubuntu4', '7.1~rc3-1ubuntu4', 'libs', 'i386']
    
    libx11-6 :
    ['2:1.1.4-2', '2:1.1.4-2', 'libs', 'i386']
    
    libxext6 :
    ['2:1.0.4-1', '2:1.0.4-1', 'libs', 'i386']
    
    zlib1g :
    ['1:1.2.3.3.dfsg-12ubuntu1', '1:1.2.3.3.dfsg-12ubuntu1', 'libs', 'i386']
    z/zlib
    '''
#    print "Dependencies: %s" % pkg.installedDependencies
#    for dep in pkg.candidateDependencies:
#    print ",".join(["%s (%s) (%s) (%s)" % (o.name,o.version,o.relation, o.preDepend) for o in dep.or_dependencies])
