import XKit
from XKit import xutils
import time
import os
import shutil

class XorgSetup:
    def __init__(self):
    
        self.modules = {
                        'nvidia': {
                                   'remove': ['dri', 'GLcore'],
                                   'load': ['glx'],
                                   'disable' : ['dri2']
                                   },
                        'fglrx': {
                                   'remove': ['dri', 'GLcore'],
                                   'load': ['glx'],
                                   'disable' : ['dri2']
                                  },
                        'other': { 
                                   'remove': ['dri', 'GLcore'],
                                   'load': ['glx'],
                                   'disable' : ['dri2']
                                  }
                        }
        self.options = {
                        'nvidia': {
                                    'add': { 'other': [],
                                             '-96': [#Section, option, value, optiontype, prefix
                                                     ['Screen', 'AddARGBGLXVisuals', 'True', 'Option', '"'],
                                                    ],
                                             '-71': [
                                                     ['Device', 'AllowGLXWithComposite', 'True', 'Option', '"'],
                                                     ['Device', 'UseEdidFreqs', 'True', 'Option', '"'],
                                                    ],
                                            },
                                    #options which are specific to certain models
                                    'adhoc': {
                                               0: {#geforcego
                                                    'ids': ['10de:0112', '10de:0172',
                                                            '10de:0174', '10de:0175',
                                                            '10de:0176', '10de:0177',
                                                            '10de:0179', '10de:0286',
                                                            '10de:017d' ],
                                                    'options': [
                                                                ['Screen', 'UseDisplayDevice', 'DFP', 'Option', '"']
                                                               ]
                                                   }
                                             },
                                    'driver': 'nvidia',
                                    'fallback': 'nv'
                                   },
                        'fglrx': {
                                   'add': {
                                           'other': [],
                                           },
                                   #options which are specific to certain models
                                   'adhoc': {
                                               0: {
                                                    'ids': [],
                                                    'options': []
                                                   }
                                             },
                                   'driver': 'fglrx',
                                   'fallback': 'vesa'
                                  },
                        'other': {
                                   'add': {
                                           'other': [],
                                           },
                                   #options which are specific to certain models
                                   'adhoc': {
                                               0: {
                                                    'ids': [],
                                                    'options': []
                                                   }
                                             },
                                   'driver': 'vesa',
                                   'fallback': 'vesa'
                                  },
                        #these options prevent X from crashing or are useful to both drivers
                        'shared': {
                                   'remove': [
                                              ['Files', 'RgbPath', None],
                                              ['Extensions', 'Composite', 'Option'],
                                             ],
                                   'add': [#Section, option, value, optiontype, prefix
                                           ['Screen', 'DefaultDepth', '24', None, ''],
                                          ],
                                   
                                  },
                                 
                        }
        
        self.toRemove = [
                         ['Screen', 'AddARGBGLXVisuals', 'Option'],
                         ['Device', 'AllowGLXWithComposite', 'Option'],
                         ['Device', 'UseEdidFreqs', 'Option'],
                         ['Extensions', 'Composite', 'Option'],
                         ['Screen', 'UseDisplayDevice', 'Option'],
                         ['Device', 'VideoOverlay', 'Option'],
                         ['Device', 'OpenGLOverlay', 'Option']
        
                        ]
        
    
        self.xpath = os.path.join('/etc','X11', 'xorg.conf')
        configFile = self.xpath
        if not os.path.isfile(self.xpath):
            configFile = None
        
        try:
            self.xorgConfig = xutils.XUtils(configFile)
        except XKit.xorgparser.ParseException:
            self.xorgConfig = xutils.XUtils(None)
        
    def xorgBackup(self):
        curtime = time.localtime()[:5]
        xpath = os.path.join('/etc','X11')
        name = 'xorg.conf_backup_'
        for item in curtime:
            name += str(item)
        original = os.path.join(xpath, 'xorg.conf')
        backup = os.path.join(xpath, name)
        shutil.copyfile(original, backup)
    
    def loadModules(self, modules):
        for module in modules:
            self.xorgConfig.addOption('Module', 'Load', module, position=0, reference=True)
    
    def removeModules(self, modules):
        for module in modules:
            self.xorgConfig.removeOption('Module', 'Load', value=module, position=0)
            self.xorgConfig.removeOption('Module', 'Disable', value=module, position=0)
    
    def disableModules(self, modules):
        for module in modules:
            self.xorgConfig.addOption('Module', 'Disable', module, position=0, reference=True)
    
    def setModules(self, modules):
        hasModules = len(self.xorgConfig.globaldict['Module']) > 0
        
        if hasModules:
            self.removeModules(modules['remove'])
        else:
            self.xorgConfig.makeSection('Module')
        self.loadModules(modules['load'])
        self.disableModules(modules['disable'])
                
    def restoreModules(self, modules):
        hasModules = len(self.xorgConfig.globaldict['Module']) > 0
        
        if hasModules:
            self.removeModules(modules['load'] + modules['disable'])
        else:
            self.xorgConfig.makeSection('Module')
            
        self.loadModules(modules['remove'])
        
    def processModules(self, package, operation):
        if 'nvidia' in package:
            modules = self.modules['nvidia']
        elif 'fglrx' in package:
            modules = self.modules['fglrx']
        else:
            modules = self.modules['other']
        
        if operation == 'install':
            self.setModules(modules)
        elif operation == 'remove':
            self.restoreModules(modules)
                
    def setDriver(self, package, operation):
        if operation == 'install':
            driverKey = 'driver'
        else:
            driverKey = 'fallback'
        
        for driver in self.options:
            if driver in package:
                drv = self.options[driver][driverKey]
                if len(self.xorgConfig.globaldict['Device']) == 0:
                    self.xorgConfig.makeSection('Device', identifier='Default Device')
                self.xorgConfig.setDriver('Device', drv, None)
                break
    
    
    def setOptions(self, operation, package=None, ids=None):
        #remove
        for option in self.toRemove:
            section = option[0]
            opt = option[1]
            if len(self.xorgConfig.globaldict[section]) > 0:
                self.xorgConfig.removeOption(section, opt, position=0)
        
        if operation == 'remove':
            return
        
        #shared
        for option in self.options['shared']['remove']:
            section = option[0]
            opt = option[1]
            if len(self.xorgConfig.globaldict[section]) > 0:
                self.xorgConfig.removeOption(section, opt, position=0)
        
        for option in self.options['shared']['add']:
            #Section, option, value, optiontype, prefix
            section, opt, value, optiontype, prefix = option
            if len(self.xorgConfig.globaldict[section]) == 0:
                name = 'Default ' + section
                self.xorgConfig.makeSection(section, identifier=name)
            self.xorgConfig.addOption(section, opt, value, optiontype=optiontype, position=0, prefix=prefix)
            
            
        #package specific options
        flavour = False
        driver = None
        if 'nvidia' in package:
            driver = 'nvidia'
            for drv in self.options['nvidia']['add']:
                if drv in package:
                    flavour = drv
        elif 'fglrx' in package:
            driver = 'fglrx'
            for drv in self.options['fglrx']['add']:
                if drv in package:
                    flavour = drv
        if not flavour:
            flavour = 'other'
            
        for option in self.options[driver]['add'][flavour]:
            #Section, option, value, optiontype, prefix
            section, opt, value, optiontype, prefix = option
            if len(self.xorgConfig.globaldict[section]) == 0:
                name = 'Default ' + section
                self.xorgConfig.makeSection(section, identifier=name)
            self.xorgConfig.addOption(section, opt, value, optiontype=optiontype, position=0, prefix=prefix)
        
        #adhoc
        if ids:
            for item in self.options[driver]['adhoc']:
                for cardId in ids:
                    if cardId in self.options[driver]['adhoc'][item]['ids']:
                        for option in self.options[driver]['adhoc'][item]['options']:
                            section, opt, value, optiontype, prefix = option
                            if len(self.xorgConfig.globaldict[section]) == 0:
                                name = 'Default ' + section
                                self.xorgConfig.makeSection(section, identifier=name)
                            self.xorgConfig.addOption(section, opt, value, optiontype=optiontype, position=0, prefix=prefix)

    

    
    def isEnabled(self, driver):
        #if self.xorgConfig has NoneType, AttributeError will be raised
        try:
            devices = self.xorgConfig.globaldict['Device']
            try:
                driver = self.xorgConfig.getDriver('Device', 0)
            except XKit.xorgparser.OptionException:
                driver = None
            if len(devices) == 0 or driver != 'nvidia':
                return False
        except AttributeError:
            return False
    
    def writeSettings(self):
        if os.path.isfile(self.xpath):
            self.xorgBackup()
        
        self.xorgConfig.writeFile(self.xpath)
    
        
    def configureX(self, operation, package=None, ids=None):
        if package == None:
            '''
            Get the driver from the xorg.conf and assume that package is
            either nvidia or fglrx so as to set the fallback.
            
            this should be done only for --uninstall-all
            '''
            
            drivers = {'nv': 'nvidia', 'ati': 'fglrx'}
            
            if len(self.xorgConfig.globaldict['Device']) > 0:
                it = 0
                for section in self.xorgConfig.globaldict['Device']:
                    try:
                        driver = self.xorgConfig.getDriver('Device', it).lower().strip()
                        for item in self.options.keys():
                            if driver == item:
                                package = driver
                                break
                            elif driver in drivers.keys():
                                package = drivers[driver]
                                break
                    except XKit.xorgparser.OptionException:
                        pass
                    it += 1
        
        if package == None:
            package = 'other'
            
        self.processModules(package, operation)
        
        self.setOptions(operation, package, ids=ids)
        
        self.setDriver(package, operation)
        
        self.writeSettings()

