/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.mpool;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.commons.collections.BoundedFifoBuffer;
import org.apache.commons.collections.Buffer;
import org.apache.excalibur.mpool.ObjectFactory;
import org.apache.excalibur.mpool.Pool;
import org.apache.excalibur.mpool.PoolUtil;

public final class FixedSizePool
implements Pool,
Disposable {
    private boolean m_disposed = false;
    private final Buffer m_buffer;
    private final ObjectFactory m_factory;

    public FixedSizePool(ObjectFactory factory, int size) throws Exception {
        this.m_buffer = new BoundedFifoBuffer(size);
        this.m_factory = factory;
        int i = 0;
        while (i < size) {
            this.m_buffer.add(this.newInstance());
            ++i;
        }
    }

    public Object acquire() {
        if (this.m_disposed) {
            throw new IllegalStateException("Cannot get an object from a disposed pool");
        }
        Object object = null;
        Buffer buffer = this.m_buffer;
        synchronized (buffer) {
            object = this.m_buffer.remove();
        }
        return object;
    }

    public void release(Object object) {
        if (this.m_disposed) {
            try {
                this.m_factory.dispose(object);
            }
            catch (Exception exception) {}
        } else {
            Buffer buffer = this.m_buffer;
            synchronized (buffer) {
                this.m_buffer.add(PoolUtil.recycle(object));
                this.m_buffer.notifyAll();
            }
        }
    }

    public Object newInstance() throws Exception {
        return this.m_factory.newInstance();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        this.m_disposed = true;
        Buffer buffer = this.m_buffer;
        synchronized (buffer) {
            while (!this.m_buffer.isEmpty()) {
                try {
                    this.m_factory.dispose(this.m_buffer.remove());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
    }
}

