/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractConfigurableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;

public class SessionStateAction
extends AbstractConfigurableAction
implements ThreadSafe {
    protected String statekey = "org.apache.cocoon.SessionState";
    protected String newstate = null;
    protected int sublevels = 0;
    protected int mylevel = 0;

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
        if (this.settings.containsKey("state-key-prefix")) {
            this.statekey = (String)this.settings.get("state-key-prefix");
        }
        if (this.settings.containsKey("new-state")) {
            this.newstate = (String)this.settings.get("new-state");
        }
        if (this.settings.containsKey("sub-levels")) {
            this.sublevels = Integer.parseInt((String)this.settings.get("sub-levels"));
        }
        if (this.settings.containsKey("state-level")) {
            this.mylevel = Integer.parseInt((String)this.settings.get("state-level"));
        }
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String src, Parameters par) throws Exception {
        Request request = ObjectModelHelper.getRequest(objectModel);
        String newstate = par.getParameter("new-state", this.newstate);
        String statekey = par.getParameter("state-key", this.statekey);
        int sublevels = par.getParameterAsInteger("sublevels", this.sublevels);
        int mylevel = par.getParameterAsInteger("state-level", this.mylevel);
        if (newstate == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().error("new-state is null");
            }
            return null;
        }
        if (request != null) {
            Session session = request.getSession(false);
            if (session != null && request.isRequestedSessionIdValid()) {
                String oldstate = null;
                if (sublevels == 0) {
                    oldstate = (String)session.getAttribute(statekey);
                    session.setAttribute(statekey, newstate);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(statekey + "=" + newstate);
                    }
                } else {
                    oldstate = (String)session.getAttribute(statekey + mylevel);
                    int i = mylevel + 1;
                    while (i <= sublevels) {
                        session.removeAttribute(statekey + i);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Remove " + statekey + i);
                        }
                        ++i;
                    }
                    session.setAttribute(statekey + mylevel, newstate);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(statekey + mylevel + "=" + newstate);
                    }
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Transition " + oldstate + " -> " + newstate);
                }
                HashMap<String, String> map = new HashMap<String, String>(1);
                map.put("newstate", newstate);
                return map;
            }
            this.getLogger().warn("A session object was not present or no longer valid");
            return null;
        }
        this.getLogger().warn("No request object");
        return null;
    }
}

