/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.javascript;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.Action;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.flow.ContinuationsManager;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.components.flow.javascript.JSWebContinuation;
import org.apache.cocoon.components.flow.javascript.JavaScriptInterpreter;
import org.apache.cocoon.components.flow.javascript.ScriptableMap;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.components.modules.output.OutputModule;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.sitemap.SitemapRedirector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class JSCocoon
extends ScriptableObject {
    protected static String OBJECT_SOURCE_RESOLVER = "source-resolver";
    protected JavaScriptInterpreter interpreter;
    protected NativeArray parameters;
    protected Environment environment;
    protected ComponentManager manager;

    public String getClassName() {
        return "Cocoon";
    }

    public void setParameters(NativeArray parameters) {
        this.parameters = parameters;
    }

    public void setInterpreter(JavaScriptInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public void setContext(ComponentManager manager, Environment environment) {
        this.manager = manager;
        this.environment = environment;
    }

    public void invalidateContext() {
        this.manager = null;
        this.environment = null;
    }

    public NativeArray jsGet_parameters() {
        return this.parameters;
    }

    public JavaScriptInterpreter jsGet_interpreter() {
        return this.interpreter;
    }

    public Environment jsGet_environment() {
        return this.environment;
    }

    public Request jsGet_request() {
        if (this.environment == null) {
            return null;
        }
        Map objectModel = this.environment.getObjectModel();
        return ObjectModelHelper.getRequest(objectModel);
    }

    public Response jsGet_response() {
        if (this.environment == null) {
            return null;
        }
        Map objectModel = this.environment.getObjectModel();
        return ObjectModelHelper.getResponse(objectModel);
    }

    public Session jsGet_session() {
        if (this.environment == null) {
            return null;
        }
        return this.jsGet_request().getSession();
    }

    public org.apache.cocoon.environment.Context jsGet_context() {
        if (this.environment == null) {
            return null;
        }
        Map objectModel = this.environment.getObjectModel();
        return ObjectModelHelper.getContext(objectModel);
    }

    public ComponentManager jsGet_componentManager() {
        return this.manager;
    }

    public Object jsFunction_load(String filename) throws JavaScriptException {
        Context cx = Context.getCurrentContext();
        try {
            Scriptable scope = this.getParentScope();
            Script script = this.interpreter.compileScript(cx, this.environment, filename);
            return script.exec(cx, scope);
        }
        catch (JavaScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JavaScriptException((Object)e);
        }
    }

    public String jsFunction_toString() {
        return "[object " + ((Object)((Object)this)).toString() + "]";
    }

    public void jsFunction_forwardTo(String uri, Object bizData, Object cont) throws JavaScriptException {
        try {
            bizData = JSCocoon.jsobjectToObject(bizData);
            WebContinuation kont = null;
            if (cont != null) {
                kont = ((JSWebContinuation)((Object)cont)).getWebContinuation();
            }
            this.interpreter.forwardTo(uri, bizData, kont, this.environment);
        }
        catch (JavaScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JavaScriptException((Object)e);
        }
    }

    public boolean jsFunction_process(String uri, Object biz, Object out) throws JavaScriptException {
        try {
            out = JSCocoon.jsobjectToObject(out);
            biz = JSCocoon.jsobjectToObject(biz);
            return this.interpreter.process(uri, biz, (OutputStream)out, this.environment);
        }
        catch (JavaScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JavaScriptException((Object)e);
        }
    }

    public void jsFunction_redirect(String uri) throws JavaScriptException {
        try {
            this.environment.redirect(false, uri);
        }
        catch (Exception e) {
            throw new JavaScriptException((Object)e);
        }
    }

    public void jsFunction_createSession() {
        this.interpreter.setSessionScope(this.environment, this.getParentScope());
    }

    public void jsFunction_removeSession() {
        this.interpreter.removeSessionScope(this.environment);
    }

    public void jsFunction_diplayAllContinuations() throws ComponentException {
        ContinuationsManager continuationsMgr = (ContinuationsManager)this.manager.lookup(ContinuationsManager.ROLE);
        try {
            continuationsMgr.displayAllContinuations();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.manager.release((Component)continuationsMgr);
            throw throwable;
        }
        this.manager.release((Component)continuationsMgr);
    }

    ComponentManager getComponentManager() {
        return this.manager;
    }

    public static Map jsobjectToMap(Scriptable jsobject) {
        HashMap<String, Object> hash = new HashMap<String, Object>();
        Object[] ids = jsobject.getIds();
        int i = 0;
        while (i < ids.length) {
            String key = ScriptRuntime.toString((Object)ids[i]);
            Object value = jsobject.get(key, jsobject);
            value = value == Undefined.instance ? null : JSCocoon.jsobjectToObject(value);
            hash.put(key, value);
            ++i;
        }
        return hash;
    }

    public static Object jsobjectToObject(Object obj) {
        if (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        } else if (obj == Undefined.instance) {
            obj = null;
        }
        return obj;
    }

    public Scriptable jsFunction_callAction(String type, String source, Scriptable parameters) throws Exception {
        SitemapRedirector redirector = new SitemapRedirector(this.environment);
        SourceResolver resolver = (SourceResolver)this.environment.getObjectModel().get(OBJECT_SOURCE_RESOLVER);
        ComponentManager sitemapManager = CocoonComponentManager.getSitemapComponentManager();
        ComponentSelector actionSelector = (ComponentSelector)sitemapManager.lookup(Action.ROLE + "Selector");
        Action action = (Action)actionSelector.select((Object)type);
        Map result = null;
        try {
            result = action.act(redirector, resolver, this.environment.getObjectModel(), source, JSCocoon.jsobjectToParameters(parameters));
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            actionSelector.release((Component)action);
            throw throwable;
        }
        actionSelector.release((Component)action);
        return result != null ? new ScriptableMap(result) : null;
    }

    public static Parameters jsobjectToParameters(Scriptable jsobject) {
        Parameters params = new Parameters();
        Object[] ids = jsobject.getIds();
        int i = 0;
        while (i < ids.length) {
            String key = ScriptRuntime.toString((Object)ids[i]);
            Object value = jsobject.get(key, jsobject);
            value = value == Undefined.instance ? null : ScriptRuntime.toString((Object)value);
            params.setParameter(key, (String)value);
            ++i;
        }
        return params;
    }

    public Object jsFunction_inputModuleGetAttribute(String type, String attribute) throws Exception {
        ComponentManager sitemapManager = CocoonComponentManager.getSitemapComponentManager();
        ComponentSelector inputSelector = (ComponentSelector)sitemapManager.lookup(InputModule.ROLE + "Selector");
        InputModule input = (InputModule)inputSelector.select((Object)type);
        Object result = null;
        try {
            result = input.getAttribute(attribute, null, this.environment.getObjectModel());
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            inputSelector.release((Component)input);
            throw throwable;
        }
        inputSelector.release((Component)input);
        return result;
    }

    public void jsFunction_outputModuleSetAttribute(String type, String attribute, Object value) throws Exception {
        ComponentManager sitemapManager = CocoonComponentManager.getSitemapComponentManager();
        ComponentSelector outputSelector = (ComponentSelector)sitemapManager.lookup(OutputModule.ROLE + "Selector");
        OutputModule output = (OutputModule)outputSelector.select((Object)type);
        try {
            output.setAttribute(null, this.environment.getObjectModel(), attribute, JSCocoon.jsobjectToObject(value));
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            outputSelector.release((Component)output);
            throw throwable;
        }
        outputSelector.release((Component)output);
    }

    public void jsFunction_outputModuleCommit(String type) throws Exception {
        ComponentManager sitemapManager = CocoonComponentManager.getSitemapComponentManager();
        ComponentSelector outputSelector = (ComponentSelector)sitemapManager.lookup(OutputModule.ROLE + "Selector");
        OutputModule output = (OutputModule)outputSelector.select((Object)type);
        try {
            output.commit(null, this.environment.getObjectModel());
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            outputSelector.release((Component)output);
            throw throwable;
        }
        outputSelector.release((Component)output);
    }

    public void jsFunction_outputModuleRollback(String type) throws Exception {
        ComponentManager sitemapManager = CocoonComponentManager.getSitemapComponentManager();
        ComponentSelector outputSelector = (ComponentSelector)sitemapManager.lookup(OutputModule.ROLE + "Selector");
        OutputModule output = (OutputModule)outputSelector.select((Object)type);
        try {
            output.rollback(null, this.environment.getObjectModel(), null);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            outputSelector.release((Component)output);
            throw throwable;
        }
        outputSelector.release((Component)output);
    }
}

