/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.javascript;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.flow.AbstractInterpreter;
import org.apache.cocoon.components.flow.Interpreter;
import org.apache.cocoon.components.flow.InvalidContinuationException;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.components.flow.javascript.JSCocoon;
import org.apache.cocoon.components.flow.javascript.JSErrorReporter;
import org.apache.cocoon.components.flow.javascript.JSGlobal;
import org.apache.cocoon.components.flow.javascript.JSLog;
import org.apache.cocoon.components.flow.javascript.JSWebContinuation;
import org.apache.cocoon.components.flow.javascript.JavaScriptFlow;
import org.apache.cocoon.components.flow.javascript.ScriptablePointerFactory;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.excalibur.source.Source;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.debugger.Main;

public class JavaScriptInterpreter
extends AbstractInterpreter
implements Configurable,
Initializable {
    private static final String LAST_EXEC_TIME = "__PRIVATE_LAST_EXEC_TIME__";
    public static final String USER_GLOBAL_SCOPE = "JavaScript GLOBAL SCOPE";
    static int OPTIMIZATION_LEVEL = -2;
    protected long lastTimeCheck = 0L;
    JSGlobal scope;
    List topLevelScripts = new ArrayList();
    Map compiledScripts = new HashMap();
    JSErrorReporter errorReporter;
    boolean enableDebugger = false;
    static Main debugger;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;
    static /* synthetic */ Class class$org$apache$cocoon$components$flow$javascript$ScriptablePropertyHandler;
    static /* synthetic */ Class class$org$apache$cocoon$components$flow$javascript$JSLog;
    static /* synthetic */ Class class$org$apache$cocoon$components$flow$javascript$JSCocoon;
    static /* synthetic */ Class class$org$apache$cocoon$components$flow$javascript$JSWebContinuation;
    static /* synthetic */ Class class$org$apache$cocoon$components$flow$javascript$JSGlobal;

    static synchronized Main getDebugger() {
        if (debugger == null) {
            final Main db = new Main("Cocoon Flow Debugger");
            db.pack();
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            size.width = (int)((double)size.width * 0.75);
            size.height = (int)((double)size.height * 0.75);
            db.setSize(size);
            db.setExitAction(new Runnable(){

                public void run() {
                    db.setVisible(false);
                }
            });
            db.setOptimizationLevel(OPTIMIZATION_LEVEL);
            db.setVisible(true);
            debugger = db;
            Context.addContextListener((ContextListener)debugger);
        }
        return debugger;
    }

    public void configure(Configuration config) throws ConfigurationException {
        String debugger;
        super.configure(config);
        String loadOnStartup = config.getChild("load-on-startup", true).getValue(null);
        if (loadOnStartup != null) {
            this.register(loadOnStartup);
        }
        if ("enabled".equalsIgnoreCase(debugger = config.getChild("debugger").getValue(null))) {
            this.enableDebugger = true;
        }
    }

    public void initialize() throws Exception {
        if (this.enableDebugger) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Flow debugger enabled, creating");
            }
            JavaScriptInterpreter.getDebugger().doBreak();
        }
        Context context = Context.enter();
        context.setOptimizationLevel(OPTIMIZATION_LEVEL);
        context.setCompileFunctionsWithDynamicScope(true);
        context.setGeneratingDebug(true);
        JXPathIntrospector.registerDynamicClass((Class)(class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = JavaScriptInterpreter.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable), (Class)(class$org$apache$cocoon$components$flow$javascript$ScriptablePropertyHandler == null ? (class$org$apache$cocoon$components$flow$javascript$ScriptablePropertyHandler = JavaScriptInterpreter.class$("org.apache.cocoon.components.flow.javascript.ScriptablePropertyHandler")) : class$org$apache$cocoon$components$flow$javascript$ScriptablePropertyHandler));
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new ScriptablePointerFactory());
        try {
            this.scope = new JSGlobal(context);
            ScriptableObject.defineClass((Scriptable)this.scope, (Class)(class$org$apache$cocoon$components$flow$javascript$JSLog == null ? (class$org$apache$cocoon$components$flow$javascript$JSLog = JavaScriptInterpreter.class$("org.apache.cocoon.components.flow.javascript.JSLog")) : class$org$apache$cocoon$components$flow$javascript$JSLog));
            ScriptableObject.defineClass((Scriptable)this.scope, (Class)(class$org$apache$cocoon$components$flow$javascript$JSCocoon == null ? (class$org$apache$cocoon$components$flow$javascript$JSCocoon = JavaScriptInterpreter.class$("org.apache.cocoon.components.flow.javascript.JSCocoon")) : class$org$apache$cocoon$components$flow$javascript$JSCocoon));
            ScriptableObject.defineClass((Scriptable)this.scope, (Class)(class$org$apache$cocoon$components$flow$javascript$JSWebContinuation == null ? (class$org$apache$cocoon$components$flow$javascript$JSWebContinuation = JavaScriptInterpreter.class$("org.apache.cocoon.components.flow.javascript.JSWebContinuation")) : class$org$apache$cocoon$components$flow$javascript$JSWebContinuation));
            String[] names = new String[]{"print"};
            try {
                this.scope.defineFunctionProperties(names, class$org$apache$cocoon$components$flow$javascript$JSGlobal == null ? (class$org$apache$cocoon$components$flow$javascript$JSGlobal = JavaScriptInterpreter.class$("org.apache.cocoon.components.flow.javascript.JSGlobal")) : class$org$apache$cocoon$components$flow$javascript$JSGlobal, 2);
            }
            catch (PropertyException e) {
                throw new Error(e.getMessage());
            }
            Object[] args = new Object[]{};
            Scriptable log = context.newObject((Scriptable)this.scope, "Log", args);
            ((JSLog)log).enableLogging(this.getLogger());
            this.scope.put("log", (Scriptable)this.scope, log);
            this.errorReporter = new JSErrorReporter(this.getLogger());
        }
        catch (Exception e) {
            Context.exit();
            e.printStackTrace();
            throw e;
        }
    }

    public Scriptable getSessionScope(Environment environment) {
        Map objectModel = environment.getObjectModel();
        Request request = ObjectModelHelper.getRequest(objectModel);
        Session session = request.getSession(false);
        if (session == null) {
            return null;
        }
        HashMap userScopes = (HashMap)session.getAttribute(USER_GLOBAL_SCOPE);
        if (userScopes == null) {
            return null;
        }
        String uriPrefix = environment.getURIPrefix();
        Scriptable scope = (Scriptable)userScopes.get(uriPrefix);
        return scope;
    }

    public void setSessionScope(Environment environment, Scriptable scope) {
        Map objectModel = environment.getObjectModel();
        Request request = ObjectModelHelper.getRequest(objectModel);
        Session session = request.getSession(true);
        HashMap<String, Scriptable> userScopes = (HashMap<String, Scriptable>)session.getAttribute(USER_GLOBAL_SCOPE);
        if (userScopes == null) {
            userScopes = new HashMap<String, Scriptable>();
            session.setAttribute(USER_GLOBAL_SCOPE, userScopes);
        }
        String uriPrefix = environment.getURIPrefix();
        userScopes.put(uriPrefix, scope);
    }

    public void removeSessionScope(Environment environment) {
        HashMap userScopes;
        Map objectModel = environment.getObjectModel();
        Request request = ObjectModelHelper.getRequest(objectModel);
        Session session = request.getSession(false);
        if (session != null && (userScopes = (HashMap)session.getAttribute(USER_GLOBAL_SCOPE)) != null) {
            userScopes.remove(environment.getURIPrefix());
        }
    }

    protected Scriptable enterContext(Environment environment) throws Exception {
        JSCocoon cocoon;
        Context context = Context.enter();
        context.setOptimizationLevel(OPTIMIZATION_LEVEL);
        context.setGeneratingDebug(true);
        context.setCompileFunctionsWithDynamicScope(true);
        context.setErrorReporter((ErrorReporter)this.errorReporter);
        Scriptable thrScope = null;
        thrScope = this.getSessionScope(environment);
        boolean newScope = false;
        long lastExecTime = 0L;
        if (thrScope == null) {
            newScope = true;
            thrScope = context.newObject((Scriptable)this.scope);
            thrScope.setPrototype((Scriptable)this.scope);
            thrScope.setParentScope(null);
            Object[] args = new Object[]{};
            cocoon = (JSCocoon)context.newObject(thrScope, "Cocoon", args);
            cocoon.setInterpreter(this);
            cocoon.setParentScope(thrScope);
            thrScope.put("cocoon", thrScope, (Object)cocoon);
            ((ScriptableObject)thrScope).defineProperty(LAST_EXEC_TIME, (Object)new Long(0L), 6);
        } else {
            cocoon = (JSCocoon)((Object)thrScope.get("cocoon", thrScope));
            lastExecTime = (Long)thrScope.get(LAST_EXEC_TIME, thrScope);
        }
        cocoon.setContext(this.manager, environment);
        Map map = this.compiledScripts;
        synchronized (map) {
            ArrayList execList = new ArrayList();
            boolean needsRefresh = false;
            if (this.reloadScripts) {
                long now = System.currentTimeMillis();
                if (now >= this.lastTimeCheck + this.checkTime) {
                    needsRefresh = true;
                }
                this.lastTimeCheck = now;
            }
            if (lastExecTime == 0L || needsRefresh || this.needResolve.size() > 0) {
                this.topLevelScripts.addAll(this.needResolve);
                if (!newScope && !needsRefresh) {
                    execList.addAll(this.needResolve);
                } else {
                    execList.addAll(this.topLevelScripts);
                }
                this.needResolve.clear();
            }
            thrScope.put(LAST_EXEC_TIME, thrScope, (Object)new Long(System.currentTimeMillis()));
            int i = 0;
            int size = execList.size();
            while (i < size) {
                String sourceURI = (String)execList.get(i);
                ScriptSourceEntry entry = (ScriptSourceEntry)this.compiledScripts.get(sourceURI);
                if (entry == null) {
                    Source src = environment.resolveURI(sourceURI);
                    entry = new ScriptSourceEntry(src);
                    this.compiledScripts.put(sourceURI, entry);
                }
                entry.getScript(context, (Scriptable)this.scope, needsRefresh);
                ++i;
            }
            int i2 = 0;
            int size2 = execList.size();
            while (i2 < size2) {
                String sourceURI = (String)execList.get(i2);
                ScriptSourceEntry entry = (ScriptSourceEntry)this.compiledScripts.get(sourceURI);
                long lastMod = entry.getSource().getLastModified();
                Script script = entry.getScript(context, (Scriptable)this.scope, false);
                if (lastExecTime == 0L || lastMod > lastExecTime) {
                    script.exec(context, thrScope);
                }
                ++i2;
            }
        }
        return thrScope;
    }

    protected void exitContext(Scriptable thrScope) {
        if (thrScope != null) {
            JSCocoon cocoon = (JSCocoon)((Object)thrScope.get("cocoon", thrScope));
            cocoon.invalidateContext();
        }
        Context.exit();
    }

    public Script compileScript(Context cx, Environment environment, String fileName) throws Exception {
        Source src = environment.resolveURI(fileName);
        if (src == null) {
            throw new ResourceNotFoundException(fileName + ": not found");
        }
        Map map = this.compiledScripts;
        synchronized (map) {
            ScriptSourceEntry entry = (ScriptSourceEntry)this.compiledScripts.get(src.getURI());
            Script compiledScript = null;
            if (entry == null) {
                entry = new ScriptSourceEntry(src);
                this.compiledScripts.put(src.getURI(), entry);
            }
            Script script = compiledScript = entry.getScript(cx, (Scriptable)this.scope, false);
            return script;
        }
    }

    private Script compileScript(Context cx, Scriptable scope, Source src) throws Exception {
        Script script;
        InputStream is = src.getInputStream();
        if (is == null) {
            throw new ResourceNotFoundException(src.getURI() + ": not found");
        }
        try {
            Script compiledScript;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            script = compiledScript = cx.compileReader(scope, (Reader)reader, src.getURI(), 1, null);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            is.close();
            throw throwable;
        }
        is.close();
        return script;
    }

    public void callFunction(String funName, List params, Environment environment) throws Exception {
        Scriptable thrScope = null;
        try {
            try {
                thrScope = this.enterContext(environment);
                Context context = Context.getCurrentContext();
                JSCocoon cocoon = (JSCocoon)((Object)thrScope.get("cocoon", thrScope));
                if (this.enableDebugger && !JavaScriptInterpreter.getDebugger().isVisible()) {
                    JavaScriptInterpreter.getDebugger().setVisible(true);
                }
                int size = params != null ? params.size() : 0;
                Object[] funArgs = new Object[size];
                NativeArray parameters = new NativeArray((long)size);
                if (size != 0) {
                    int i = 0;
                    while (i < size) {
                        Interpreter.Argument arg = (Interpreter.Argument)params.get(i);
                        funArgs[i] = arg.value;
                        if (arg.name == null) {
                            arg.name = "";
                        }
                        parameters.put(arg.name, (Scriptable)parameters, (Object)arg.value);
                        ++i;
                    }
                }
                cocoon.setParameters(parameters);
                NativeArray funArgsArray = new NativeArray(funArgs);
                Object fun = ScriptableObject.getProperty((Scriptable)thrScope, (String)funName);
                if (fun == Scriptable.NOT_FOUND) {
                    fun = funName;
                }
                Object[] callFunArgs = new Object[]{fun, funArgsArray};
                Object callFun = ScriptableObject.getProperty((Scriptable)thrScope, (String)"callFunction");
                if (callFun == Scriptable.NOT_FOUND) {
                    callFun = "callFunction";
                }
                ScriptRuntime.call((Context)context, (Object)callFun, (Object)thrScope, (Object[])callFunArgs, (Scriptable)thrScope);
            }
            catch (JavaScriptException ex) {
                EvaluatorException ee = Context.reportRuntimeError((String)ToolErrorReporter.getMessage((String)"msg.uncaughtJSException", (String)ex.getMessage()));
                Throwable unwrapped = this.unwrap(ex);
                if (unwrapped instanceof ProcessingException) {
                    throw (ProcessingException)((Object)unwrapped);
                }
                throw new CascadingRuntimeException(ee.getMessage(), unwrapped);
            }
            catch (EcmaError ee) {
                String msg = ToolErrorReporter.getMessage((String)"msg.uncaughtJSException", (String)ee.toString());
                if (ee.getSourceName() != null) {
                    Context.reportRuntimeError((String)msg, (String)ee.getSourceName(), (int)ee.getLineNumber(), (String)ee.getLineSource(), (int)ee.getColumnNumber());
                } else {
                    Context.reportRuntimeError((String)msg);
                }
                throw new CascadingRuntimeException(ee.getMessage(), (Throwable)ee);
            }
            Object var15_20 = null;
            this.exitContext(thrScope);
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            this.exitContext(thrScope);
            throw throwable;
        }
    }

    public void handleContinuation(String id, List params, Environment environment) throws Exception {
        Object handleContFunction;
        WebContinuation wk = this.continuationsMgr.lookupWebContinuation(id);
        if (wk == null) {
            throw new InvalidContinuationException("The continuation ID " + id + " is invalid.");
        }
        Context context = Context.enter();
        context.setOptimizationLevel(OPTIMIZATION_LEVEL);
        context.setGeneratingDebug(true);
        context.setCompileFunctionsWithDynamicScope(true);
        JSWebContinuation jswk = (JSWebContinuation)((Object)wk.getUserObject());
        JSCocoon cocoon = jswk.getJSCocoon();
        cocoon.setContext(this.manager, environment);
        Scriptable kScope = cocoon.getParentScope();
        if (this.enableDebugger) {
            JavaScriptInterpreter.getDebugger().setVisible(true);
        }
        if ((handleContFunction = kScope.get("handleContinuation", kScope)) == Scriptable.NOT_FOUND) {
            throw new RuntimeException("Cannot find 'handleContinuation' (system.js not loaded?)");
        }
        Object[] args = new Object[]{jswk};
        int size = params != null ? params.size() : 0;
        NativeArray parameters = new NativeArray((long)size);
        if (size != 0) {
            int i = 0;
            while (i < size) {
                Interpreter.Argument arg = (Interpreter.Argument)params.get(i);
                parameters.put(arg.name, (Scriptable)parameters, (Object)arg.value);
                ++i;
            }
        }
        cocoon.setParameters(parameters);
        try {
            try {
                ((Function)handleContFunction).call(context, kScope, kScope, args);
            }
            catch (JavaScriptException ex) {
                EvaluatorException ee = Context.reportRuntimeError((String)ToolErrorReporter.getMessage((String)"msg.uncaughtJSException", (String)ex.getMessage()));
                Throwable unwrapped = this.unwrap(ex);
                if (unwrapped instanceof ProcessingException) {
                    throw (ProcessingException)((Object)unwrapped);
                }
                throw new CascadingRuntimeException(ee.getMessage(), unwrapped);
            }
            catch (EcmaError ee) {
                String msg = ToolErrorReporter.getMessage((String)"msg.uncaughtJSException", (String)ee.toString());
                if (ee.getSourceName() != null) {
                    Context.reportRuntimeError((String)msg, (String)ee.getSourceName(), (int)ee.getLineNumber(), (String)ee.getLineSource(), (int)ee.getColumnNumber());
                } else {
                    Context.reportRuntimeError((String)msg);
                }
                throw new CascadingRuntimeException(ee.getMessage(), (Throwable)ee);
            }
            Object var17_17 = null;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    private Throwable unwrap(JavaScriptException e) {
        Object value = e.getValue();
        while (value instanceof Wrapper) {
            value = ((Wrapper)value).unwrap();
        }
        if (value instanceof Throwable) {
            return (Throwable)value;
        }
        return e;
    }

    public void forwardTo(String uri, Object bizData, WebContinuation continuation, Environment environment) throws Exception {
        Map objectModel = environment.getObjectModel();
        JavaScriptFlow.setPackages(objectModel, (Scriptable)ScriptableObject.getProperty((Scriptable)this.scope, (String)"Packages"));
        JavaScriptFlow.setJavaPackage(objectModel, (Scriptable)ScriptableObject.getProperty((Scriptable)this.scope, (String)"java"));
        super.forwardTo(uri, bizData, continuation, environment);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ScriptSourceEntry {
        private final Source source;
        private Script script;
        private long compileTime;

        public ScriptSourceEntry(Source source) {
            this.source = source;
        }

        public ScriptSourceEntry(Source source, Script script, long t) {
            this.source = source;
            this.script = script;
            this.compileTime = t;
        }

        public Source getSource() {
            return this.source;
        }

        public Script getScript(Context context, Scriptable scope, boolean refresh) throws Exception {
            if (refresh) {
                this.source.refresh();
            }
            if (this.script == null || this.compileTime < this.source.getLastModified()) {
                this.script = JavaScriptInterpreter.this.compileScript(context, scope, this.source);
                this.compileTime = this.source.getLastModified();
            }
            return this.script;
        }
    }
}

