/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.acting.ConfigurationHelper;
import org.apache.cocoon.acting.ValidatorActionResult;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.excalibur.source.Source;
import org.xml.sax.ContentHandler;

public class XSPFormValidatorHelper {
    private static Map configurations = new HashMap();
    String current_descriptor = null;
    boolean current_reloadable = true;
    Logger current_logger = null;
    String current_constraint_set = null;
    String current_parameter = null;
    SourceResolver current_resolver = null;

    public XSPFormValidatorHelper(String descriptor, boolean reloadable, Logger logger, SourceResolver resolver) {
        this.current_descriptor = descriptor;
        this.current_reloadable = reloadable;
        this.current_logger = logger;
        this.current_resolver = resolver;
    }

    public XSPFormValidatorHelper(String descriptor, boolean reloadable, Logger logger, SourceResolver resolver, String constraintset) {
        this.current_descriptor = descriptor;
        this.current_reloadable = reloadable;
        this.current_logger = logger;
        this.current_resolver = resolver;
        this.current_constraint_set = constraintset;
    }

    public void setParameter(String parameter) {
        this.current_parameter = parameter;
    }

    public void setConstraintSet(String constraintset) {
        this.current_constraint_set = constraintset;
    }

    public static Object getAttribute(Map objectModel, String name) {
        Request request = ObjectModelHelper.getRequest(objectModel);
        return request.getAttribute(name);
    }

    public static Map getResults(Map objectModel) {
        Request request = ObjectModelHelper.getRequest(objectModel);
        return (Map)request.getAttribute("org.apache.cocoon.acting.FormValidatorAction.results");
    }

    public static ValidatorActionResult getParamResult(Map objectModel, String name) {
        ValidatorActionResult result = ValidatorActionResult.NOTPRESENT;
        Map param_result = XSPFormValidatorHelper.getResults(objectModel);
        if (param_result != null) {
            result = (ValidatorActionResult)param_result.get(name);
        }
        return result != null ? result : ValidatorActionResult.NOTPRESENT;
    }

    public ValidatorActionResult getParamResult(Map objectModel) {
        ValidatorActionResult result = ValidatorActionResult.NOTPRESENT;
        Map param_result = XSPFormValidatorHelper.getResults(objectModel);
        if (param_result != null) {
            result = (ValidatorActionResult)param_result.get(this.current_parameter);
        }
        return result != null ? result : ValidatorActionResult.NOTPRESENT;
    }

    public static boolean isOK(Map objectModel, String name) {
        return XSPFormValidatorHelper.getParamResult(objectModel, name).equals(ValidatorActionResult.OK);
    }

    public boolean isOK(Map objectModel) {
        return XSPFormValidatorHelper.isOK(objectModel, this.current_parameter);
    }

    public static boolean isError(Map objectModel, String name) {
        return XSPFormValidatorHelper.getParamResult(objectModel, name).ge(ValidatorActionResult.ERROR);
    }

    public boolean isError(Map objectModel) {
        return XSPFormValidatorHelper.isError(objectModel, this.current_parameter);
    }

    public static boolean isNull(Map objectModel, String name) {
        return XSPFormValidatorHelper.getParamResult(objectModel, name).equals(ValidatorActionResult.ISNULL);
    }

    public boolean isNull(Map objectModel) {
        return XSPFormValidatorHelper.isNull(objectModel, this.current_parameter);
    }

    public static boolean isTooSmall(Map objectModel, String name) {
        boolean ok = XSPFormValidatorHelper.getParamResult(objectModel, name).equals(ValidatorActionResult.TOOSMALL);
        if (!ok) {
            ok = XSPFormValidatorHelper.isNull(objectModel, name);
        }
        return ok;
    }

    public boolean isTooSmall(Map objectModel) {
        return XSPFormValidatorHelper.isTooSmall(objectModel, this.current_parameter);
    }

    public static boolean isTooLarge(Map objectModel, String name) {
        return XSPFormValidatorHelper.getParamResult(objectModel, name) == ValidatorActionResult.TOOLARGE;
    }

    public boolean isTooLarge(Map objectModel) {
        return XSPFormValidatorHelper.isTooLarge(objectModel, this.current_parameter);
    }

    public static boolean isNoMatch(Map objectModel, String name) {
        return XSPFormValidatorHelper.getParamResult(objectModel, name).equals(ValidatorActionResult.NOMATCH);
    }

    public boolean isNoMatch(Map objectModel) {
        return XSPFormValidatorHelper.isNoMatch(objectModel, this.current_parameter);
    }

    public static boolean isNotPresent(Map objectModel, String name) {
        return XSPFormValidatorHelper.getParamResult(objectModel, name).equals(ValidatorActionResult.NOTPRESENT);
    }

    public boolean isNotPresent(Map objectModel) {
        return XSPFormValidatorHelper.isNotPresent(objectModel, this.current_parameter);
    }

    protected static Configuration getConfiguration(String descriptor, SourceResolver resolver, boolean reloadable, Logger logger) throws ConfigurationException {
        if (descriptor == null) {
            throw new ConfigurationException("The form descriptor is not set!");
        }
        ConfigurationHelper conf = null;
        Map map = configurations;
        synchronized (map) {
            Source source = null;
            try {
                block10: {
                    try {
                        source = resolver.resolveURI(descriptor);
                        conf = (ConfigurationHelper)configurations.get(source.getURI());
                        if (conf == null || reloadable && conf.lastModified != source.getLastModified()) {
                            logger.debug("(Re)Loading " + descriptor);
                            if (conf == null) {
                                conf = new ConfigurationHelper();
                            }
                            SAXConfigurationHandler builder = new SAXConfigurationHandler();
                            SourceUtil.toSAX(source, (ContentHandler)builder);
                            conf.lastModified = source.getLastModified();
                            conf.configuration = builder.getConfiguration();
                            XSPFormValidatorHelper.cacheConfiguration(source.getURI(), conf);
                            break block10;
                        }
                        logger.debug("Using cached configuration for " + descriptor);
                    }
                    catch (Exception e) {
                        logger.error("Could not configure Database mapping environment", (Throwable)e);
                        throw new ConfigurationException("Error trying to load configurations for resource: " + source.getURI());
                    }
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                resolver.release(source);
                throw throwable;
            }
            resolver.release(source);
        }
        return conf.configuration;
    }

    private static void cacheConfiguration(String descriptor, ConfigurationHelper conf) {
        Map map = configurations;
        synchronized (map) {
            configurations.put(descriptor, conf);
        }
    }

    protected static Configuration getConfigurationByName(Configuration[] conf, String name, Logger logger) {
        int j = 0;
        boolean found = false;
        String setname = null;
        j = 0;
        while (j < conf.length) {
            setname = conf[j].getAttribute("name", "");
            if (name.trim().equals(setname.trim())) {
                found = true;
                break;
            }
            ++j;
        }
        if (!found) {
            logger.debug("XSPFormValidatorHelper.getConfigurationByName: configuration " + name + " not found.");
            return null;
        }
        return conf[j];
    }

    public static String getParameterAttributes(String descriptor, SourceResolver resolver, boolean reloadable, String constraintset, String parameter, String attribute, Logger logger) {
        try {
            Configuration conf = XSPFormValidatorHelper.getConfiguration(descriptor, resolver, reloadable, logger);
            Configuration[] desc = conf.getChildren("parameter");
            Configuration[] csets = conf.getChildren("constraint-set");
            Configuration cset = XSPFormValidatorHelper.getConfigurationByName(csets, constraintset, logger);
            Configuration[] set = cset.getChildren("validate");
            Configuration constraints = XSPFormValidatorHelper.getConfigurationByName(set, parameter, logger);
            Configuration descr = XSPFormValidatorHelper.getConfigurationByName(desc, parameter, logger);
            return constraints.getAttribute(attribute, descr.getAttribute(attribute, ""));
        }
        catch (Exception e) {
            logger.debug("XSPFormValidatorHelper.getParameterAttributes Exception " + e);
            return "";
        }
    }

    public String getParameterAttribute(String attribute) {
        return XSPFormValidatorHelper.getParameterAttributes(this.current_descriptor, this.current_resolver, this.current_reloadable, this.current_constraint_set, this.current_parameter, attribute, this.current_logger);
    }

    public String getParameterAttribute(String parameter, String attribute) {
        return XSPFormValidatorHelper.getParameterAttributes(this.current_descriptor, this.current_resolver, this.current_reloadable, this.current_constraint_set, parameter, attribute, this.current_logger);
    }
}

