/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.modules.input;

import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.AbstractInputModule;
import org.apache.cocoon.components.modules.input.InputModule;

public abstract class AbstractMetaModule
extends AbstractInputModule
implements Composable,
Disposable {
    protected ComponentManager manager;
    protected ComponentSelector inputSelector = null;
    protected InputModule input = null;
    protected String defaultInput = "request-param";
    protected Configuration inputConf = null;
    protected boolean initialized = false;
    protected static final String INPUT_MODULE_SELECTOR = InputModule.ROLE + "Selector";
    private static final int OP_GET = 0;
    private static final int OP_VALUES = 1;
    private static final int OP_NAMES = 2;
    private static final String[] OPNAME = new String[]{"GET_VALUE", "GET_VALUES", "GET_NAMES"};

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public synchronized void lazy_initialize() {
        block7: {
            try {
                if (!this.initialized) {
                    this.inputSelector = (ComponentSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                    if (this.inputSelector != null && this.inputSelector instanceof ThreadSafe) {
                        if (this.defaultInput != null) {
                            this.input = this.obtainModule(this.defaultInput);
                        }
                    } else if (!(this.inputSelector instanceof ThreadSafe)) {
                        this.manager.release((Component)this.inputSelector);
                        this.inputSelector = null;
                    }
                    this.initialized = true;
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isWarnEnabled()) break block7;
                this.getLogger().error("A problem occurred setting up input modules :'" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void dispose() {
        if (this.inputSelector != null) {
            if (this.input != null) {
                this.inputSelector.release((Component)this.input);
            }
            this.manager.release((Component)this.inputSelector);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputModule obtainModule(String type) {
        ComponentSelector inputSelector = this.inputSelector;
        InputModule module = null;
        try {
            block9: {
                try {
                    if (inputSelector == null) {
                        inputSelector = (ComponentSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                    }
                    if (inputSelector.hasComponent((Object)type)) {
                        if (type != null && inputSelector.hasComponent((Object)type)) {
                            module = (InputModule)inputSelector.select((Object)type);
                        }
                        if (!(module instanceof ThreadSafe)) {
                            inputSelector.release(module);
                            module = null;
                        }
                    }
                    if (type == null || module != null || !this.getLogger().isWarnEnabled()) break block9;
                    this.getLogger().warn("A problem occurred setting up '" + type + "': Selector is " + (inputSelector != null ? "not " : "") + "null, Component is " + (inputSelector != null && inputSelector.hasComponent((Object)type) ? "known" : "unknown"));
                }
                catch (ComponentException ce) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("Could not obtain selector for InputModules: " + ce.getMessage());
                    }
                    Object var6_5 = null;
                    if (this.inputSelector != null) return module;
                    this.manager.release((Component)inputSelector);
                    return module;
                }
            }
            Object var6_4 = null;
            if (this.inputSelector != null) return module;
            this.manager.release((Component)inputSelector);
            return module;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.inputSelector != null) throw throwable;
            this.manager.release((Component)inputSelector);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void releaseModule(InputModule module) {
        ComponentSelector inputSelector = this.inputSelector;
        if (module == null) return;
        try {
            try {
                if (inputSelector == null) {
                    inputSelector = (ComponentSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                }
                inputSelector.release((Component)module);
                module = null;
            }
            catch (ComponentException ce) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Could not obtain selector for InputModules: " + ce.getMessage());
                }
                Object var5_4 = null;
                if (this.inputSelector != null) return;
                this.manager.release((Component)inputSelector);
                return;
            }
            Object var5_3 = null;
            if (this.inputSelector != null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.inputSelector != null) throw throwable;
            this.manager.release((Component)inputSelector);
            throw throwable;
        }
        this.manager.release((Component)inputSelector);
    }

    protected Iterator getNames(Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf) throws ConfigurationException {
        return (Iterator)this.get(2, null, objectModel, staticMod, staticModName, staticModConf, null, null, null);
    }

    protected Iterator getNames(Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf, InputModule dynamicMod, String dynamicModName, Configuration dynamicModConf) throws ConfigurationException {
        return (Iterator)this.get(2, null, objectModel, staticMod, staticModName, staticModConf, dynamicMod, dynamicModName, dynamicModConf);
    }

    protected Object getValue(String attr, Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf) throws ConfigurationException {
        return this.get(0, attr, objectModel, staticMod, staticModName, staticModConf, null, null, null);
    }

    protected Object getValue(String attr, Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf, InputModule dynamicMod, String dynamicModName, Configuration dynamicModConf) throws ConfigurationException {
        return this.get(0, attr, objectModel, staticMod, staticModName, staticModConf, dynamicMod, dynamicModName, dynamicModConf);
    }

    protected Object[] getValues(String attr, Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf) throws ConfigurationException {
        return (Object[])this.get(1, attr, objectModel, staticMod, staticModName, staticModConf, null, null, null);
    }

    protected Object[] getValues(String attr, Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf, InputModule dynamicMod, String dynamicModName, Configuration dynamicModConf) throws ConfigurationException {
        return (Object[])this.get(1, attr, objectModel, staticMod, staticModName, staticModConf, dynamicMod, dynamicModName, dynamicModConf);
    }

    private Object get(int op, String attr, Map objectModel, InputModule staticMod, String staticModName, Configuration staticModConf, InputModule dynamicMod, String dynamicModName, Configuration dynamicModConf) throws ConfigurationException {
        Object[] value;
        ComponentSelector cs;
        block23: {
            cs = this.inputSelector;
            value = null;
            String name = null;
            InputModule input = null;
            Configuration conf = null;
            boolean release = false;
            try {
                boolean useDynamic;
                if (cs == null) {
                    try {
                        cs = (ComponentSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                    }
                    catch (ComponentException e) {
                        throw new ConfigurationException("Could not find MetaModule's module selector", (Throwable)e);
                    }
                }
                if (dynamicMod == null && dynamicModName == null) {
                    useDynamic = false;
                    input = staticMod;
                    name = staticModName;
                    conf = staticModConf;
                } else {
                    useDynamic = true;
                    input = dynamicMod;
                    name = dynamicModName;
                    conf = dynamicModConf;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("MetaModule performing op " + OPNAME[op] + " on " + (useDynamic ? "dynamically" : "statically") + " " + (input == null ? "created" : "assigned") + " module '" + name + "', using config " + dynamicModConf);
                }
                if (input == null) {
                    if (cs.hasComponent((Object)name)) {
                        release = true;
                        try {
                            input = (InputModule)cs.select((Object)name);
                        }
                        catch (ComponentException e) {
                            throw new ConfigurationException("MetaModule unable to create " + (useDynamic ? "dynamically" : "statically") + " specified internal module '" + name + "'", (Throwable)e);
                        }
                    } else if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn("No such InputModule: " + name);
                    }
                }
                switch (op) {
                    case 0: {
                        value = input.getAttribute(attr, conf, objectModel);
                        break;
                    }
                    case 1: {
                        value = input.getAttributeValues(attr, conf, objectModel);
                        break;
                    }
                    case 2: {
                        value = input.getAttributeNames(conf, objectModel);
                    }
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("using " + name + " as " + input + " for " + op + " (" + attr + ") and " + conf + " gives " + value);
                }
                Object var19_19 = null;
                if (!release) break block23;
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                if (release) {
                    cs.release((Component)input);
                }
                if (this.inputSelector == null) {
                    this.manager.release((Component)cs);
                }
                throw throwable;
            }
            cs.release((Component)input);
        }
        if (this.inputSelector == null) {
            this.manager.release((Component)cs);
        }
        return value;
    }
}

