/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public final class URLRewriter
implements XMLConsumer {
    public static final String PARAMETER_MODE = "rewriteURLMode";
    public static final String MODE_NONE = "none";
    public static final String MODE_COCOON = "cocoon";
    public static final String PARAMETER_PARAMETER_NAME = "urlParameterName";
    public static final String PARAMETER_URL = "baseURL";
    public static final String PARAMETER_COCOON_URL = "cocoonURL";
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private int mode;
    private String baseUrl;
    private String cocoonUrl;

    public URLRewriter(Parameters configuration, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws ProcessingException {
        try {
            this.contentHandler = contentHandler;
            this.lexicalHandler = lexicalHandler;
            this.mode = 0;
            if (configuration != null && configuration.getParameter(PARAMETER_MODE, null) != null && configuration.getParameter(PARAMETER_MODE, null).equalsIgnoreCase(MODE_COCOON)) {
                this.mode = 1;
                this.baseUrl = configuration.getParameter(PARAMETER_URL);
                this.cocoonUrl = configuration.getParameter(PARAMETER_COCOON_URL) + '?' + configuration.getParameter(PARAMETER_PARAMETER_NAME) + '=';
            }
        }
        catch (ParameterException local) {
            throw new ProcessingException("URLRewriter: configuration exception.", local);
        }
    }

    public URLRewriter(Parameters configuration, ContentHandler contentHandler) throws ProcessingException {
        this(configuration, contentHandler, contentHandler instanceof LexicalHandler ? (LexicalHandler)((Object)contentHandler) : null);
    }

    public void setDocumentLocator(Locator locator) {
        this.contentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.contentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.contentHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.contentHandler.endPrefixMapping(prefix);
    }

    public void startElement(String namespace, String name, String raw, Attributes attr) throws SAXException {
        if (this.mode == 1) {
            AttributesImpl newattr = null;
            int i = 0;
            while (i < attr.getLength()) {
                URL baseURL;
                String value;
                String attrname = attr.getLocalName(i);
                if (attrname.equals("href") || attrname.equals("action")) {
                    if (newattr == null) {
                        newattr = new AttributesImpl(attr);
                    }
                    if ((value = attr.getValue(i)).indexOf(58) == -1) {
                        try {
                            baseURL = new URL(new URL(this.baseUrl), value);
                            value = baseURL.toExternalForm();
                        }
                        catch (MalformedURLException local) {
                            value = attr.getValue(i);
                        }
                    }
                    newattr.setValue(i, this.cocoonUrl + value);
                } else if (attrname.equals("src") || attrname.equals("background")) {
                    if (newattr == null) {
                        newattr = new AttributesImpl(attr);
                    }
                    if ((value = attr.getValue(i)).indexOf(58) == -1) {
                        try {
                            baseURL = new URL(new URL(this.baseUrl), value);
                            value = baseURL.toExternalForm();
                        }
                        catch (MalformedURLException local) {
                            value = attr.getValue(i);
                        }
                    }
                    newattr.setValue(i, value);
                }
                ++i;
            }
            if (newattr != null) {
                this.contentHandler.startElement(namespace, name, raw, newattr);
                return;
            }
        }
        this.contentHandler.startElement(namespace, name, raw, attr);
    }

    public void endElement(String namespace, String name, String raw) throws SAXException {
        this.contentHandler.endElement(namespace, name, raw);
    }

    public void characters(char[] ary, int start, int length) throws SAXException {
        this.contentHandler.characters(ary, start, length);
    }

    public void ignorableWhitespace(char[] ary, int start, int length) throws SAXException {
        this.contentHandler.ignorableWhitespace(ary, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }

    public void startDTD(String name, String public_id, String system_id) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, public_id, system_id);
        }
    }

    public void endDTD() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void comment(char[] ary, int start, int length) throws SAXException {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ary, start, length);
        }
    }
}

