/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.SimpleSelectorProcessingNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.matching.Matcher;
import org.apache.cocoon.sitemap.PatternException;

public class MatchNode
extends SimpleSelectorProcessingNode
implements ParameterizableProcessingNode,
Composable,
Disposable {
    private VariableResolver pattern;
    private String name;
    private Matcher threadSafeMatcher;
    private Map parameters;
    private ComponentManager manager;

    public MatchNode(String type, VariableResolver pattern, String name) throws PatternException {
        super(type);
        this.pattern = pattern;
        this.name = name;
    }

    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.setSelector((ComponentSelector)manager.lookup(Matcher.ROLE + "Selector"));
        this.threadSafeMatcher = (Matcher)this.getThreadSafeComponent();
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        super.invoke(env, context);
        Map objectModel = env.getObjectModel();
        String resolvedPattern = this.pattern.resolve(context, objectModel);
        Parameters resolvedParams = VariableResolver.buildParameters(this.parameters, context, objectModel);
        Map result = null;
        if (this.threadSafeMatcher != null) {
            result = this.threadSafeMatcher.match(resolvedPattern, objectModel, resolvedParams);
        } else {
            Matcher matcher = (Matcher)this.selector.select((Object)this.componentName);
            try {
                result = matcher.match(resolvedPattern, objectModel, resolvedParams);
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.selector.release((Component)matcher);
                throw throwable;
            }
            this.selector.release((Component)matcher);
            {
            }
        }
        if (result != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Matcher '" + this.componentName + "' matched pattern '" + this.pattern + "' at " + this.getLocation());
            }
            return this.invokeNodes(this.children, env, context, this.name, result);
        }
        return false;
    }

    public void dispose() {
        this.manager.release((Component)this.selector);
    }
}

