/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.TreeProcessor;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;

public class MountNode
extends AbstractProcessingNode
implements Composable {
    private VariableResolver prefix;
    private VariableResolver source;
    private Map processors = new HashMap();
    private TreeProcessor parentProcessor;
    private String language;
    private ComponentManager manager;

    public MountNode(VariableResolver prefix, VariableResolver source, String language, TreeProcessor parentProcessor) {
        this.prefix = prefix;
        this.source = source;
        this.language = language;
        this.parentProcessor = parentProcessor;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        boolean bl;
        String oldContext;
        String oldURI;
        String oldPrefix;
        block6: {
            boolean bl2;
            block5: {
                boolean bl3;
                block4: {
                    Map objectModel = env.getObjectModel();
                    String resolvedSource = this.source.resolve(context, objectModel);
                    TreeProcessor processor = this.getProcessor(env, resolvedSource);
                    String resolvedPrefix = this.prefix.resolve(context, objectModel);
                    oldPrefix = env.getURIPrefix();
                    oldURI = env.getURI();
                    oldContext = env.getContext();
                    try {
                        env.changeContext(resolvedPrefix, resolvedSource);
                        if (context.isBuildingPipelineOnly()) {
                            ProcessingPipeline pp = processor.buildPipeline(env);
                            if (pp != null) {
                                context.setProcessingPipeline(pp);
                                bl3 = true;
                                Object var13_14 = null;
                                env.setContext(oldPrefix, oldURI, oldContext);
                                break block4;
                            }
                            bl2 = false;
                            break block5;
                        }
                        bl = processor.process(env);
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var13_17 = null;
                        env.setContext(oldPrefix, oldURI, oldContext);
                        context.recompose(this.manager);
                        throw throwable;
                    }
                }
                context.recompose(this.manager);
                return bl3;
            }
            Object var13_15 = null;
            env.setContext(oldPrefix, oldURI, oldContext);
            context.recompose(this.manager);
            return bl2;
        }
        Object var13_16 = null;
        env.setContext(oldPrefix, oldURI, oldContext);
        context.recompose(this.manager);
        return bl;
    }

    private synchronized TreeProcessor getProcessor(Environment env, String source) throws Exception {
        TreeProcessor processor = (TreeProcessor)this.processors.get(source);
        if (processor == null) {
            String actualSource = source.charAt(source.length() - 1) == '/' ? source + "sitemap.xmap" : source;
            processor = this.parentProcessor.createChildProcessor(this.manager, this.language, env.resolveURI(actualSource));
            this.processors.put(source, processor);
        }
        return processor;
    }

    public void dispose() {
        Iterator iter = this.processors.values().iterator();
        while (iter.hasNext()) {
            ((TreeProcessor)iter.next()).dispose();
        }
    }
}

