/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.treeprocessor.AbstractParentProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.sitemap.HandleErrorsNode;
import org.apache.cocoon.components.treeprocessor.sitemap.HandleErrorsNodeBuilder;
import org.apache.cocoon.components.treeprocessor.sitemap.PipelineNode;

public class PipelineNodeBuilder
extends AbstractParentProcessingNodeBuilder
implements ThreadSafe {
    protected boolean hasParameters() {
        return true;
    }

    public ProcessingNode buildNode(Configuration config) throws Exception {
        PipelineNode node = new PipelineNode(config);
        this.treeBuilder.setupNode(node, config);
        node.setInternalOnly(config.getAttributeAsBoolean("internal-only", false));
        HandleErrorsNode mainHandler = null;
        HandleErrorsNode error404Handler = null;
        HandleErrorsNode error500Handler = null;
        Configuration[] childConfigs = config.getChildren();
        ArrayList<ProcessingNode> children = new ArrayList<ProcessingNode>();
        int i = 0;
        while (i < childConfigs.length) {
            Configuration childConfig = childConfigs[i];
            if (this.isChild(childConfig)) {
                ProcessingNodeBuilder builder = this.treeBuilder.createNodeBuilder(childConfig);
                if (builder instanceof HandleErrorsNodeBuilder) {
                    HandleErrorsNode handler = (HandleErrorsNode)builder.buildNode(childConfig);
                    int type = handler.getStatusCode();
                    switch (type) {
                        case -1: {
                            if (mainHandler != null) {
                                throw new ConfigurationException("Duplicate <handle-errors> at " + handler.getLocation());
                            }
                            if (error500Handler != null || error404Handler != null) {
                                throw new ConfigurationException("Cannot mix <handle-errors> with and without 'type' attribute at " + handler.getLocation());
                            }
                            mainHandler = handler;
                            break;
                        }
                        case 404: {
                            if (error404Handler != null) {
                                throw new ConfigurationException("Duplicate <handle-errors type='404' at " + handler.getLocation());
                            }
                            if (mainHandler != null) {
                                throw new ConfigurationException("Cannot mix <handle-errors> with and without 'type' attribute at " + handler.getLocation());
                            }
                            error404Handler = handler;
                            break;
                        }
                        case 500: {
                            if (error500Handler != null) {
                                throw new ConfigurationException("Duplicate <handle-errors type='500' at " + handler.getLocation());
                            }
                            if (mainHandler != null) {
                                throw new ConfigurationException("Cannot mix <handle-errors> with and without 'type' attribute at " + handler.getLocation());
                            }
                            error500Handler = handler;
                            break;
                        }
                        default: {
                            throw new ConfigurationException("Unknown handle-errors type (" + type + ") at " + handler.getLocation());
                        }
                    }
                } else {
                    children.add(builder.buildNode(childConfig));
                }
            }
            ++i;
        }
        node.setChildren(AbstractParentProcessingNodeBuilder.toNodeArray(children));
        node.set404Handler(error404Handler);
        node.set500Handler(error500Handler == null ? mainHandler : error500Handler);
        return node;
    }
}

