/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment;

import java.io.IOException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.PermanentRedirector;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.wrapper.EnvironmentWrapper;

public class ForwardRedirector
extends AbstractLogEnabled
implements Redirector,
PermanentRedirector {
    private boolean hasRedirected = false;
    private Environment env;
    private Processor processor;
    private ComponentManager manager;
    private boolean internal;

    public ForwardRedirector(Environment env, Processor processor, ComponentManager manager, boolean internal) {
        this.env = env;
        this.processor = processor;
        this.manager = manager;
        this.internal = internal;
    }

    public void redirect(boolean sessionMode, String url) throws IOException, ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Redirecting to '" + url + "'");
        }
        if (url.startsWith("cocoon:")) {
            this.cocoonRedirect(sessionMode, url);
        } else {
            this.env.redirect(sessionMode, url);
        }
        this.hasRedirected = true;
    }

    public void permanentRedirect(boolean sessionMode, String url) throws IOException, ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Redirecting to '" + url + "'");
        }
        if (url.startsWith("cocoon:")) {
            this.cocoonRedirect(sessionMode, url);
        } else if (this.env instanceof PermanentRedirector) {
            ((PermanentRedirector)((Object)this.env)).permanentRedirect(sessionMode, url);
        } else {
            this.env.redirect(sessionMode, url);
        }
        this.hasRedirected = true;
    }

    public void globalRedirect(boolean sessionMode, String url) throws IOException, ProcessingException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Redirecting to '" + url + "'");
        }
        if (url.startsWith("cocoon:")) {
            this.cocoonRedirect(sessionMode, url);
        } else if (this.env instanceof EnvironmentWrapper) {
            ((EnvironmentWrapper)this.env).globalRedirect(sessionMode, url);
        } else {
            this.env.redirect(sessionMode, url);
        }
        this.hasRedirected = true;
    }

    private void cocoonRedirect(boolean sessionMode, String uri) throws IOException, ProcessingException {
        this.env.setAttribute("cocoon: redirect url", uri);
    }

    public boolean hasRedirected() {
        return this.hasRedirected;
    }
}

