/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.commandline;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.environment.Context;
import org.apache.commons.collections.iterators.IteratorEnumeration;

public class CommandLineContext
extends AbstractLogEnabled
implements Context {
    private String contextDir;
    private Map attributes;

    public CommandLineContext(String contextDir) {
        String contextDirPath;
        this.contextDir = contextDirPath = new File(contextDir).getAbsolutePath();
        this.attributes = new HashMap();
    }

    public Object getAttribute(String name) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("CommandlineContext: getAttribute=" + name);
        }
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("CommandlineContext: setAttribute=" + name);
        }
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("CommandlineContext: removeAttribute=" + name);
        }
        this.attributes.remove(name);
    }

    public Enumeration getAttributeNames() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("CommandlineContext: getAttributeNames");
        }
        return new IteratorEnumeration(this.attributes.keySet().iterator());
    }

    public URL getResource(String path) throws MalformedURLException {
        File f;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("CommandlineContext: getResource=" + path);
        }
        if (!(f = new File(this.contextDir, path)).exists()) {
            return null;
        }
        return f.toURL();
    }

    public String getRealPath(String path) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("CommandlineContext: getRealPath=" + path);
        }
        File f = new File(this.contextDir, path);
        return f.getAbsolutePath();
    }

    public String getMimeType(String file) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("CommandlineContext: getMimeType=" + file);
        }
        return null;
    }

    public String getInitParameter(String name) {
        this.getLogger().debug("CommandlineContext: getInitParameter=" + name);
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        this.getLogger().debug("CommandlineContext: getResourceAsStream " + path);
        return null;
    }
}

