/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.i18n;

import java.util.Locale;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.i18n.BundleFactory;

public abstract class AbstractBundleFactory
extends AbstractLogEnabled
implements BundleFactory,
Composable,
Configurable,
Disposable,
LogEnabled,
ThreadSafe {
    protected boolean cacheAtStartup = false;
    protected String directory;
    protected ComponentManager manager = null;

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.cacheAtStartup = configuration.getChild("cache-at-startup").getValueAsBoolean(false);
        try {
            this.directory = configuration.getChild("catalogue-location", true).getValue();
        }
        catch (ConfigurationException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Root directory not provided in configuration, using default (root)");
            }
            this.directory = "";
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Bundle Factory implementation configured with: cacheAtStartup = " + this.cacheAtStartup + ", directory = '" + this.directory + "'");
        }
    }

    public abstract Component select(String var1, Locale var2) throws ComponentException;

    public abstract void release(Component var1);

    public abstract boolean hasComponent(Object var1);

    public abstract Component select(Object var1) throws ComponentException;

    public abstract void dispose();
}

