/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.serialization;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.cocoon.serialization.Serializer;
import org.apache.cocoon.xml.xlink.ExtendedXLinkPipe;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LinkSerializer
extends ExtendedXLinkPipe
implements Serializer {
    private PrintStream out;

    public void setOutputStream(OutputStream out) throws IOException {
        this.out = new PrintStream(out);
    }

    public String getMimeType() {
        return "application/x-cocoon-links";
    }

    public void simpleLink(String href, String role, String arcrole, String title, String show, String actuate, String uri, String name, String raw, Attributes attr) throws SAXException {
        if (this.traversable(href)) {
            this.print(href);
        }
    }

    public void startLocator(String href, String role, String title, String label, String uri, String name, String raw, Attributes attr) throws SAXException {
        if (this.traversable(href)) {
            this.print(href);
        }
    }

    private boolean traversable(String href) {
        if (href.length() == 0) {
            return false;
        }
        if (href.charAt(0) == '#') {
            return false;
        }
        if (href.indexOf("://") != -1) {
            return false;
        }
        if (href.startsWith("mailto:")) {
            return false;
        }
        if (href.startsWith("news:")) {
            return false;
        }
        return !href.startsWith("javascript:");
    }

    private void print(String href) {
        int ankerPos = href.indexOf(35);
        if (ankerPos == -1) {
            this.out.println(href);
        } else {
            this.out.println(href.substring(0, ankerPos));
        }
    }

    public boolean shouldSetContentLength() {
        return false;
    }

    public void recycle() {
        super.recycle();
        this.out = null;
    }
}

