/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import org.apache.cocoon.servlet.ParanoidClassLoader;

public class ParanoidCocoonServlet
extends HttpServlet {
    public static final String DEFAULT_SERVLET_CLASS = "org.apache.cocoon.servlet.CocoonServlet";
    protected Servlet servlet;
    protected ClassLoader classloader;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String externalClasspath = config.getInitParameter("paranoid-classpath");
        this.classloader = externalClasspath == null ? this.getClassLoader(this.getContextDir()) : this.getClassLoader(externalClasspath);
        String servletName = config.getInitParameter("servlet-class");
        if (servletName == null) {
            servletName = DEFAULT_SERVLET_CLASS;
        }
        try {
            Class<?> servletClass = this.classloader.loadClass(servletName);
            this.servlet = (Servlet)servletClass.newInstance();
        }
        catch (Exception e) {
            throw new ServletException("Cannot load servlet " + servletName, (Throwable)e);
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            this.initServlet();
            Object var6_6 = null;
            Thread.currentThread().setContextClassLoader(old);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Thread.currentThread().setContextClassLoader(old);
            throw throwable;
        }
    }

    protected void initServlet() throws ServletException {
        this.servlet.init(this.getServletConfig());
    }

    protected File getContextDir() throws ServletException {
        String result = this.getServletContext().getRealPath("/");
        if (result == null) {
            throw new ServletException(((Object)((Object)this)).getClass().getName() + " cannot run in an undeployed WAR file");
        }
        return new File(result);
    }

    protected ClassLoader getClassLoader(File contextDir) throws ServletException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        try {
            File classDir = new File(contextDir + "/WEB-INF/classes");
            if (classDir.exists()) {
                if (!classDir.isDirectory()) {
                    throw new ServletException(classDir + " exists but is not a directory");
                }
                URL classURL = classDir.toURL();
                this.log("Adding class directory " + classURL);
                urlList.add(classURL);
            }
            File libDir = new File(contextDir + "/WEB-INF/lib");
            File[] libraries = libDir.listFiles(new JarFileFilter());
            int i = 0;
            while (i < libraries.length) {
                URL lib = libraries[i].toURL();
                this.log("Adding class library " + lib);
                urlList.add(lib);
                ++i;
            }
        }
        catch (MalformedURLException mue) {
            throw new ServletException((Throwable)mue);
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        return ParanoidClassLoader.newInstance(urls, ((Object)((Object)this)).getClass().getClassLoader());
    }

    protected ClassLoader getClassLoader(String externalClasspath) throws ServletException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        this.log("Adding classpath from " + externalClasspath);
        try {
            String line;
            FileReader fileReader = new FileReader(externalClasspath);
            LineNumberReader lineReader = new LineNumberReader(fileReader);
            do {
                if ((line = lineReader.readLine()) == null) continue;
                if (line.startsWith("class-dir:")) {
                    line = line.substring("class-dir:".length()).trim();
                    URL url = new File(line).toURL();
                    this.log("Adding class directory " + url);
                    urlList.add(url);
                    continue;
                }
                if (line.startsWith("lib-dir:")) {
                    line = line.substring("lib-dir:".length()).trim();
                    File dir = new File(line);
                    File[] libraries = dir.listFiles(new JarFileFilter());
                    this.log("Adding " + libraries.length + " libraries from " + dir.toURL());
                    int i = 0;
                    while (i < libraries.length) {
                        URL url = libraries[i].toURL();
                        urlList.add(url);
                        ++i;
                    }
                } else {
                    URL lib;
                    if (line.indexOf(58) == -1) {
                        File entry = new File(line);
                        lib = entry.toURL();
                    } else {
                        lib = new URL(line);
                    }
                    this.log("Adding class URL " + lib);
                    urlList.add(lib);
                }
            } while (line != null);
            lineReader.close();
        }
        catch (IOException io) {
            throw new ServletException((Throwable)io);
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        return ParanoidClassLoader.newInstance(urls, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            this.servlet.service(request, response);
            Object var5_4 = null;
            Thread.currentThread().setContextClassLoader(old);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Thread.currentThread().setContextClassLoader(old);
            throw throwable;
        }
    }

    public void destroy() {
        if (this.servlet != null) {
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classloader);
                this.servlet.destroy();
                Object var3_2 = null;
                Thread.currentThread().setContextClassLoader(old);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                Thread.currentThread().setContextClassLoader(old);
                throw throwable;
            }
        }
        super.destroy();
    }

    private class JarFileFilter
    implements FilenameFilter {
        private JarFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".zip") || name.endsWith(".jar");
        }
    }
}

