/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.ValidatorActionResult;
import org.apache.cocoon.components.language.markup.xsp.XSPFormValidatorHelper;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleFormTransformer
extends AbstractTransformer
implements Composable,
Configurable,
Recyclable {
    private static final int ELEMENT_DEFAULT = 0;
    private static final int ELEMENT_INPUT = 1;
    private static final int ELEMENT_SELECT = 2;
    private static final int ELEMENT_OPTION = 3;
    private static final int ELEMENT_TXTAREA = 4;
    private static final int ELEMENT_ERROR = 5;
    private static final int ELEMENT_FORM = 6;
    private static final Integer defaultElement = new Integer(0);
    private static final int TYPE_DEFAULT = 0;
    private static final int TYPE_CHECKBOX = 1;
    private static final int TYPE_RADIO = 2;
    private static final Integer defaultType = new Integer(0);
    protected static final String INPUT_MODULE_ROLE = InputModule.ROLE;
    protected static final String INPUT_MODULE_SELECTOR = INPUT_MODULE_ROLE + "Selector";
    private static final HashMap elementNames;
    private static final HashMap inputTypes;
    private static final HashMap validatorResults;
    private static final HashMap validatorResultLabel;
    protected int ignoreCount;
    protected boolean ignoreThis = false;
    protected Stack stack = new Stack();
    protected Object[] values = null;
    protected Map validationResults = null;
    protected Request request;
    protected Map objectModel;
    protected Parameters parameters;
    protected ComponentManager manager;
    private boolean fixed = false;
    private boolean documentFixed = false;
    private String fixedName = "fixed";
    private String prefix = null;
    private String suffix = null;
    private String defaultPrefix = null;
    private String defaultSuffix = null;
    private String separator = null;
    private String formName = null;
    private boolean useFormName = false;
    private boolean useFormNameTwice = false;
    private boolean ignoreValidation = false;
    private String defaultInput = "request-param";
    private Configuration defaultInputConf = null;
    private Configuration inputConf = null;
    private InputModule input = null;
    private ComponentSelector inputSelector = null;
    private String inputName = null;
    protected AttributesImpl emptyAttributes = new AttributesImpl();

    private void reset() {
        this.objectModel = null;
        this.request = null;
        this.parameters = null;
        this.stack.clear();
        this.ignoreCount = 0;
        this.values = null;
        this.validationResults = null;
        this.documentFixed = false;
        this.fixed = false;
        this.formName = null;
        if (this.inputSelector != null) {
            if (this.input != null) {
                this.inputSelector.release((Component)this.input);
            }
            this.manager.release((Component)this.inputSelector);
        }
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.defaultInputConf = config.getChild("input-module");
        this.defaultInput = this.defaultInputConf.getAttribute("name", this.defaultInput);
        this.separator = config.getChild("separator").getValue(this.separator);
        this.defaultPrefix = config.getChild("prefix").getValue(this.defaultPrefix);
        this.defaultSuffix = config.getChild("suffix").getValue(this.defaultSuffix);
        this.fixedName = config.getChild("fixed-attribute").getValue(this.fixedName);
        this.useFormName = config.getChild("use-form-name").getValueAsBoolean(this.useFormName);
        this.useFormNameTwice = config.getChild("use-form-name-twice").getValueAsBoolean(this.useFormNameTwice);
        boolean bl = this.useFormName = this.useFormName || this.useFormNameTwice;
        if (this.useFormName) {
            this.defaultPrefix = this.separator = this.separator == null || this.separator.equals("") ? "/" : this.separator;
        }
        this.ignoreValidation = config.getChild("ignore-validation").getValueAsBoolean(this.ignoreValidation);
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        block8: {
            this.reset();
            this.objectModel = objectModel;
            this.request = ObjectModelHelper.getRequest(objectModel);
            if (this.request == null) {
                this.getLogger().debug("no request object");
                throw new ProcessingException("no request object");
            }
            this.parameters = par;
            this.fixed = this.documentFixed = par.getParameterAsBoolean("fixed", false);
            this.prefix = par.getParameter("prefix", this.defaultPrefix);
            this.suffix = par.getParameter("suffix", this.defaultSuffix);
            this.inputName = par.getParameter("input", null);
            this.inputConf = null;
            this.validationResults = this.ignoreValidation ? null : XSPFormValidatorHelper.getResults(objectModel);
            if (this.inputName == null) {
                this.inputName = this.defaultInput;
                this.inputConf = this.defaultInputConf;
            }
            try {
                this.inputSelector = (ComponentSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                if (this.inputName != null && this.inputSelector != null && this.inputSelector.hasComponent((Object)this.inputName)) {
                    this.input = (InputModule)this.inputSelector.select((Object)this.inputName);
                    if (!(this.input instanceof ThreadSafe) || !(this.inputSelector instanceof ThreadSafe)) {
                        this.inputSelector.release((Component)this.input);
                        this.manager.release((Component)this.inputSelector);
                        this.input = null;
                        this.inputSelector = null;
                    }
                } else if (this.inputName != null && this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("A problem occurred setting up '" + this.inputName + "': Selector is " + (this.inputSelector != null ? "not " : "") + "null, Component is " + (this.inputSelector != null && this.inputSelector.hasComponent((Object)this.inputName) ? "known" : "unknown"));
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isWarnEnabled()) break block8;
                this.getLogger().warn("A problem occurred setting up '" + this.inputName + "': " + e.getMessage());
            }
        }
    }

    public void recycle() {
        super.recycle();
        this.reset();
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    protected String printAttributes(Attributes attr) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        int i = 0;
        while (i < attr.getLength()) {
            sb.append('@').append(attr.getLocalName(i)).append("='").append(attr.getValue(i)).append("' ");
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    protected void startCheckableElement(String uri, String name, String raw, AttributesImpl attributes) throws SAXException {
        String checked = attributes.getValue("checked");
        String value = attributes.getValue("value");
        boolean found = false;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startCheckableElement " + name + " attributes " + this.printAttributes(attributes));
        }
        if (this.values != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("replacing");
            }
            int i = 0;
            while (i < this.values.length) {
                if (this.values[i].equals(value)) {
                    found = true;
                    if (checked != null) break;
                    attributes.addAttribute("", "checked", "checked", "CDATA", "");
                    break;
                }
                ++i;
            }
            if (!found && checked != null) {
                attributes.removeAttribute(attributes.getIndex("checked"));
            }
        }
        super.startElement(uri, name, raw, attributes);
    }

    protected void startNonCheckableElement(String uri, String name, String raw, AttributesImpl attributes) throws SAXException {
        String value = attributes.getValue("value");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startNonCheckableElement " + name + " attributes " + this.printAttributes(attributes));
        }
        if (this.values != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("replacing");
            }
            if (value != null) {
                attributes.setValue(attributes.getIndex("value"), String.valueOf(this.values[0]));
            } else {
                attributes.addAttribute("", "value", "value", "CDATA", String.valueOf(this.values[0]));
            }
        }
        super.startElement(uri, name, raw, attributes);
    }

    protected void startInputElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        String aName = this.getName(attr.getValue("name"));
        String fixed = attr.getValue(this.fixedName);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startInputElement " + name + " attributes " + this.printAttributes(attr));
        }
        if (aName == null || this.fixed || fixed != null && SimpleFormTransformer.parseBoolean(fixed)) {
            super.startElement(uri, name, raw, attr);
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("replacing");
            }
            this.values = this.getValues(aName);
            AttributesImpl attributes = null;
            attributes = attr instanceof AttributesImpl ? (AttributesImpl)attr : new AttributesImpl(attr);
            String type = attributes.getValue("type");
            switch ((Integer)inputTypes.get(type, defaultType)) {
                case 1: 
                case 2: {
                    this.startCheckableElement(uri, name, raw, attributes);
                    break;
                }
                case 0: {
                    this.startNonCheckableElement(uri, name, raw, attributes);
                }
            }
            this.values = null;
        }
    }

    protected void startSelectElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        String aName = this.getName(attr.getValue("name"));
        String fixed = attr.getValue(this.fixedName);
        this.values = null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startSelectElement " + name + " attributes " + this.printAttributes(attr));
        }
        if (!(aName == null || this.fixed || fixed != null && SimpleFormTransformer.parseBoolean(fixed))) {
            this.values = this.getValues(aName);
        }
        super.startElement(uri, name, raw, attr);
    }

    protected void startOptionElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startOptionElement " + name + " attributes " + this.printAttributes(attr));
        }
        if (this.values == null || this.fixed) {
            super.startElement(uri, name, raw, attr);
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("replacing");
            }
            AttributesImpl attributes = null;
            attributes = attr instanceof AttributesImpl ? (AttributesImpl)attr : new AttributesImpl(attr);
            String selected = attributes.getValue("selected");
            String value = attributes.getValue("value");
            boolean found = false;
            int i = 0;
            while (i < this.values.length) {
                if (this.values[i].equals(value)) {
                    found = true;
                    if (selected != null) break;
                    attributes.addAttribute("", "selected", "selected", "CDATA", "");
                    break;
                }
                ++i;
            }
            if (!found && selected != null) {
                attributes.removeAttribute(attributes.getIndex("selected"));
            }
            super.startElement(uri, name, raw, attributes);
        }
    }

    protected void startTextareaElement(String uri, String name, String raw, Attributes attributes) throws SAXException {
        String aName = this.getName(attributes.getValue("name"));
        String fixed = attributes.getValue(this.fixedName);
        Object[] value = null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startTextareaElement " + name + " attributes " + this.printAttributes(attributes));
        }
        if (aName != null) {
            value = this.getValues(aName);
        }
        if (value == null || this.fixed || fixed != null && SimpleFormTransformer.parseBoolean(fixed)) {
            super.startElement(uri, name, raw, attributes);
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("replacing");
            }
            ++this.ignoreCount;
            this.stack.push(name);
            this.ignoreThis = false;
            super.startElement(uri, name, raw, attributes);
            String valString = String.valueOf(value[0]);
            super.characters(valString.toCharArray(), 0, valString.length());
        }
    }

    protected void startErrorElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("startErrorElement " + name + " attributes " + this.printAttributes(attr));
        }
        if (this.ignoreValidation) {
            super.startElement(uri, name, raw, attr);
        } else if (this.validationResults == null || this.fixed) {
            ++this.ignoreCount;
            this.stack.push(name);
            this.ignoreThis = true;
        } else {
            String aName = attr.getValue("name");
            if (aName == null) {
                super.startElement(uri, name, raw, attr);
            } else {
                ValidatorActionResult validation = XSPFormValidatorHelper.getParamResult(this.objectModel, aName);
                String when = attr.getValue("when");
                String when_ge = attr.getValue("when-ge");
                if (when != null && when.equals(validatorResults.get(validation)) || when_ge != null && validation.ge((ValidatorActionResult)validatorResultLabel.get(when_ge, ValidatorActionResult.MAXERROR))) {
                    AttributesImpl attributes = null;
                    attributes = attr instanceof AttributesImpl ? (AttributesImpl)attr : new AttributesImpl(attr);
                    attributes.removeAttribute(attributes.getIndex("name"));
                    if (when != null) {
                        attributes.removeAttribute(attributes.getIndex("when"));
                    }
                    if (when_ge != null) {
                        attributes.removeAttribute(attributes.getIndex("when-ge"));
                    }
                    super.startElement(uri, name, raw, attributes);
                } else {
                    ++this.ignoreCount;
                    this.stack.push(name);
                    this.ignoreThis = true;
                }
            }
        }
    }

    protected void startFormElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        String fixed = attr.getValue(this.fixedName);
        if (this.useFormName) {
            this.formName = attr.getValue("name");
        }
        if (fixed == null) {
            super.startElement(uri, name, raw, attr);
        } else {
            if (!this.fixed && ("true".equals(fixed) || "yes".equals(fixed))) {
                this.fixed = true;
            }
            AttributesImpl attributes = null;
            attributes = attr instanceof AttributesImpl ? (AttributesImpl)attr : new AttributesImpl(attr);
            attributes.removeAttribute(attributes.getIndex(this.fixedName));
            super.startElement(uri, name, raw, attributes);
        }
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (this.ignoreCount == 0) {
            if (uri != "") {
                super.startElement(uri, name, raw, attr);
            } else {
                switch ((Integer)elementNames.get(name, defaultElement)) {
                    case 1: {
                        this.startInputElement(uri, name, raw, attr);
                        break;
                    }
                    case 2: {
                        this.startSelectElement(uri, name, raw, attr);
                        break;
                    }
                    case 3: {
                        this.startOptionElement(uri, name, raw, attr);
                        break;
                    }
                    case 4: {
                        this.startTextareaElement(uri, name, raw, attr);
                        break;
                    }
                    case 5: {
                        this.startErrorElement(uri, name, raw, attr);
                        break;
                    }
                    case 6: {
                        this.startFormElement(uri, name, raw, attr);
                        break;
                    }
                    default: {
                        super.startElement(uri, name, raw, attr);
                        break;
                    }
                }
            }
        } else {
            ++this.ignoreCount;
            this.stack.push(name);
            if ((Integer)elementNames.get(name, defaultElement) == 5) {
                // empty if block
            }
        }
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (uri != "") {
            if (this.ignoreCount == 0) {
                super.endElement(uri, name, raw);
            }
        } else {
            if (this.ignoreCount > 0 && ((String)this.stack.peek()).equals(name)) {
                this.stack.pop();
                --this.ignoreCount;
            }
            if (this.ignoreCount == 0 && this.ignoreThis) {
                this.ignoreThis = false;
            } else if (this.ignoreCount <= 0) {
                switch ((Integer)elementNames.get(name, defaultElement)) {
                    case 1: {
                        super.endElement(uri, name, raw);
                        break;
                    }
                    case 2: {
                        this.values = null;
                        super.endElement(uri, name, raw);
                        break;
                    }
                    case 3: {
                        super.endElement(uri, name, raw);
                        break;
                    }
                    case 4: {
                        super.endElement(uri, name, raw);
                        break;
                    }
                    case 5: {
                        super.endElement(uri, name, raw);
                        break;
                    }
                    case 6: {
                        this.fixed = this.documentFixed;
                        this.formName = null;
                        super.endElement(uri, name, raw);
                        break;
                    }
                    default: {
                        super.endElement(uri, name, raw);
                    }
                }
            }
        }
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        if (this.ignoreCount == 0) {
            super.characters(c, start, len);
        }
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        if (this.ignoreCount == 0) {
            super.ignorableWhitespace(c, start, len);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.ignoreCount == 0) {
            super.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.ignoreCount == 0) {
            super.skippedEntity(name);
        }
    }

    private static boolean parseBoolean(String aBoolean) {
        return "true".equalsIgnoreCase(aBoolean) || "yes".equalsIgnoreCase(aBoolean);
    }

    private String getName(String name) {
        String result = name;
        if (this.useFormName && this.formName != null) {
            result = this.separator != null ? (this.useFormNameTwice ? this.formName + this.separator + this.formName + this.separator + result : this.formName + this.separator + result) : (this.useFormNameTwice ? this.formName + result : this.formName + this.formName + result);
        }
        if (this.prefix != null) {
            result = this.prefix + result;
        }
        if (this.suffix != null) {
            result = result + this.prefix;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] getValues(String name) {
        ComponentSelector iputSelector;
        Object[] values;
        block14: {
            values = null;
            iputSelector = null;
            InputModule iput = null;
            try {
                block13: {
                    try {
                        if (this.input != null) {
                            values = this.input.getAttributeValues(name, this.inputConf, this.objectModel);
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("cached module " + this.input + " attribute " + name + " returns " + values);
                            }
                            break block13;
                        }
                        iputSelector = (ComponentSelector)this.manager.lookup(INPUT_MODULE_SELECTOR);
                        if (this.inputName != null && iputSelector != null && iputSelector.hasComponent((Object)this.inputName)) {
                            iput = (InputModule)iputSelector.select((Object)this.inputName);
                        }
                        if (iput != null) {
                            values = iput.getAttributeValues(name, this.inputConf, this.objectModel);
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("fresh module " + iput + " attribute " + name + " returns " + values);
                        }
                    }
                    catch (Exception e) {
                        if (this.getLogger().isWarnEnabled()) {
                            this.getLogger().warn("A problem occurred acquiring a value from '" + this.inputName + "' for '" + name + "': " + e.getMessage());
                        }
                        Object var7_6 = null;
                        if (iputSelector == null) return values;
                        if (iput != null) {
                            iputSelector.release(iput);
                        }
                        this.manager.release((Component)iputSelector);
                        return values;
                    }
                }
                Object var7_5 = null;
                if (iputSelector == null) return values;
                if (iput == null) break block14;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (iputSelector == null) throw throwable;
                if (iput != null) {
                    iputSelector.release(iput);
                }
                this.manager.release((Component)iputSelector);
                throw throwable;
            }
            iputSelector.release((Component)iput);
        }
        this.manager.release((Component)iputSelector);
        return values;
    }

    static {
        HashMap names = new HashMap();
        names.put("input", new Integer(1));
        names.put("select", new Integer(2));
        names.put("option", new Integer(3));
        names.put("textarea", new Integer(4));
        names.put("error", new Integer(5));
        names.put("form", new Integer(6));
        elementNames = names;
        names = null;
        names = new HashMap();
        names.put("checkbox", new Integer(1));
        names.put("radio", new Integer(2));
        inputTypes = names;
        names = null;
        names = new HashMap();
        names.put("ok", ValidatorActionResult.OK);
        names.put("not-present", ValidatorActionResult.NOTPRESENT);
        names.put("error", ValidatorActionResult.ERROR);
        names.put("is-null", ValidatorActionResult.ISNULL);
        names.put("too-small", ValidatorActionResult.TOOSMALL);
        names.put("too-large", ValidatorActionResult.TOOLARGE);
        names.put("no-match", ValidatorActionResult.NOMATCH);
        validatorResultLabel = names;
        names = new HashMap();
        names.put(ValidatorActionResult.OK, "ok");
        names.put(ValidatorActionResult.NOTPRESENT, "not-present");
        names.put(ValidatorActionResult.ERROR, "error");
        names.put(ValidatorActionResult.ISNULL, "is-null");
        names.put(ValidatorActionResult.TOOSMALL, "too-small");
        names.put(ValidatorActionResult.TOOLARGE, "too-large");
        names.put(ValidatorActionResult.NOMATCH, "no-match");
        validatorResults = names;
        Object var0 = null;
    }
}

