/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.Cookie;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.xml.xslt.XSLTProcessor;
import org.apache.excalibur.xml.xslt.XSLTProcessorException;
import org.xml.sax.SAXException;

public class TraxTransformer
extends AbstractTransformer
implements Transformer,
Composable,
Configurable,
CacheableProcessingComponent,
Disposable {
    protected ComponentManager manager;
    protected Map objectModel;
    protected Map logicSheetParameters;
    private boolean useParameters = false;
    private boolean _useParameters = false;
    private boolean useCookies = false;
    private boolean _useCookies = false;
    private boolean useSessionInfo = false;
    private boolean _useSessionInfo = false;
    protected TransformerHandler transformerHandler;
    SourceValidity transformerValidity;
    private Source inputSource;
    private Parameters par;
    private SourceResolver resolver;
    private XSLTProcessor xsltProcessor;
    private boolean finishedDocument = false;
    private Method xalanDtmManagerGetIncrementalMethod;

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration child = conf.getChild("use-request-parameters");
        this._useParameters = this.useParameters = child.getValueAsBoolean(false);
        child = conf.getChild("use-cookies");
        this._useCookies = this.useCookies = child.getValueAsBoolean(false);
        child = conf.getChild("use-session-info");
        this._useSessionInfo = this.useSessionInfo = child.getValueAsBoolean(false);
        child = conf.getChild("transformer-factory");
        String traxFactory = child.getValue(null);
        child = conf.getChild("xslt-processor-role");
        String xsltProcessorRole = child.getValue(XSLTProcessor.ROLE);
        if (!xsltProcessorRole.startsWith(XSLTProcessor.ROLE)) {
            xsltProcessorRole = XSLTProcessor.ROLE + '/' + xsltProcessorRole;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Use parameters is " + this.useParameters);
            this.getLogger().debug("Use cookies is " + this.useCookies);
            this.getLogger().debug("Use session info is " + this.useSessionInfo);
            this.getLogger().debug("Use TrAX Processor " + xsltProcessorRole);
            if (traxFactory != null) {
                this.getLogger().debug("Use TrAX Transformer Factory " + traxFactory);
            } else {
                this.getLogger().debug("Use default TrAX Transformer Factory.");
            }
        }
        try {
            this.xsltProcessor = (XSLTProcessor)this.manager.lookup(xsltProcessorRole);
            if (traxFactory != null) {
                this.xsltProcessor.setTransformerFactory(traxFactory);
            }
        }
        catch (ComponentException e) {
            throw new ConfigurationException("Cannot load XSLT processor", (Throwable)e);
        }
        try {
            Class<?> dtmManagerClass = Class.forName("org.apache.xml.dtm.DTMManager");
            this.xalanDtmManagerGetIncrementalMethod = dtmManagerClass.getMethod("getIncremental", null);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Was not able to get getIncremental method from Xalan's DTMManager.", (Throwable)e);
        }
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws SAXException, ProcessingException, IOException {
        if (src == null) {
            throw new ProcessingException("Stylesheet URI can't be null");
        }
        this.par = par;
        this.objectModel = objectModel;
        this.resolver = resolver;
        try {
            this.inputSource = resolver.resolveURI(src);
        }
        catch (SourceException se) {
            throw SourceUtil.handle("Unable to resolve " + src, se);
        }
        this._useParameters = par.getParameterAsBoolean("use-request-parameters", this.useParameters);
        this._useCookies = par.getParameterAsBoolean("use-cookies", this.useCookies);
        this._useSessionInfo = par.getParameterAsBoolean("use-session-info", this.useSessionInfo);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Using stylesheet: '" + this.inputSource.getURI() + "' in " + this);
        }
        try {
            XSLTProcessor.TransformerHandlerAndValidity handlerAndValidity = this.xsltProcessor.getTransformerHandlerAndValidity(this.inputSource, null);
            this.transformerHandler = handlerAndValidity.getTransfomerHandler();
            this.transformerValidity = handlerAndValidity.getTransfomerValidity();
        }
        catch (XSLTProcessorException se) {
            throw new ProcessingException("Unable to get transformer handler for " + src, se);
        }
    }

    public Serializable getKey() {
        Map map = this.getLogicSheetParameters();
        if (map == null) {
            return this.inputSource.getURI();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.inputSource.getURI());
        Set entries = map.entrySet();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            sb.append(';');
            Map.Entry entry = i.next();
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    public SourceValidity getValidity() {
        return this.transformerValidity;
    }

    public void setConsumer(XMLConsumer consumer) {
        Map map = this.getLogicSheetParameters();
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                this.transformerHandler.getTransformer().setParameter(name, map.get(name));
            }
        }
        super.setContentHandler(this.transformerHandler);
        super.setLexicalHandler(this.transformerHandler);
        if (this.transformerHandler instanceof LogEnabled) {
            ((LogEnabled)this.transformerHandler).enableLogging(this.getLogger());
        }
        SAXResult result = new SAXResult(consumer);
        result.setLexicalHandler(consumer);
        this.transformerHandler.setResult(result);
    }

    protected Map getLogicSheetParameters() {
        Cookie[] cookies;
        Request request;
        Enumeration parameters;
        String value;
        String name;
        String[] params;
        if (this.logicSheetParameters != null) {
            return this.logicSheetParameters;
        }
        HashMap<String, String> map = null;
        if (this.par != null && (params = this.par.getNames()) != null) {
            int i = 0;
            while (i < params.length) {
                name = params[i];
                if (TraxTransformer.isValidXSLTParameterName(name) && (value = this.par.getParameter(name, null)) != null) {
                    if (map == null) {
                        map = new HashMap();
                    }
                    map.put(name, value);
                }
                ++i;
            }
        }
        if (this._useParameters && (parameters = (request = ObjectModelHelper.getRequest(this.objectModel)).getParameterNames()) != null) {
            while (parameters.hasMoreElements()) {
                name = (String)parameters.nextElement();
                if (!TraxTransformer.isValidXSLTParameterName(name)) continue;
                value = request.getParameter(name);
                if (map == null) {
                    map = new HashMap();
                }
                map.put(name, value);
            }
        }
        if (this._useSessionInfo) {
            Session session;
            request = ObjectModelHelper.getRequest(this.objectModel);
            if (map == null) {
                map = new HashMap<String, String>(5);
            }
            if ((session = request.getSession(false)) != null) {
                map.put("session-available", "true");
                map.put("session-is-new", session.isNew() ? "true" : "false");
                map.put("session-id-from-cookie", request.isRequestedSessionIdFromCookie() ? "true" : "false");
                map.put("session-id-from-url", request.isRequestedSessionIdFromURL() ? "true" : "false");
                map.put("session-valid", request.isRequestedSessionIdValid() ? "true" : "false");
                map.put("session-id", session.getId());
            } else {
                map.put("session-available", "false");
            }
        }
        if (this._useCookies && (cookies = (request = ObjectModelHelper.getRequest(this.objectModel)).getCookies()) != null) {
            int i = 0;
            while (i < cookies.length) {
                String name2 = cookies[i].getName();
                if (TraxTransformer.isValidXSLTParameterName(name2)) {
                    String value2 = cookies[i].getValue();
                    if (map == null) {
                        map = new HashMap();
                    }
                    map.put(name2, value2);
                }
                ++i;
            }
        }
        this.logicSheetParameters = map;
        return map;
    }

    static boolean isValidXSLTParameterName(String name) {
        if (name.length() == 0) {
            return false;
        }
        char c = name.charAt(0);
        if (!Character.isLetter(c) && c != '_') {
            return false;
        }
        int i = name.length() - 1;
        while (i > 1) {
            c = name.charAt(i);
            if (!Character.isLetterOrDigit(c) && c != '-' && c != '_' && c != '.') {
                return false;
            }
            --i;
        }
        return true;
    }

    public void dispose() {
        this.manager.release((Component)this.xsltProcessor);
        this.xsltProcessor = null;
        this.manager = null;
    }

    public void recycle() {
        this.objectModel = null;
        if (this.inputSource != null) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        this.resolver = null;
        this.par = null;
        if (!this.finishedDocument && this.transformerHandler != null && this.xalanDtmManagerGetIncrementalMethod != null && this.transformerHandler.getClass().getName().equals("org.apache.xalan.transformer.TransformerHandlerImpl")) {
            try {
                boolean incremental = (Boolean)this.xalanDtmManagerGetIncrementalMethod.invoke(null, null);
                if (incremental) {
                    super.endDocument();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.finishedDocument = false;
        this.logicSheetParameters = null;
        this.transformerHandler = null;
        this.transformerValidity = null;
        super.recycle();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.finishedDocument = true;
    }
}

