/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.cocoon.util.FileFormatException;
import org.apache.cocoon.util.ImageProperties;
import org.apache.cocoon.util.MIMEUtils;

public final class ImageUtils {
    public static final ImageProperties getImageProperties(File file) throws FileNotFoundException, IOException, FileFormatException {
        String type = MIMEUtils.getMIMEType(file);
        if ("image/gif".equals(type)) {
            return ImageUtils.getGifProperties(file);
        }
        if ("image/jpeg".equals(type)) {
            return ImageUtils.getJpegProperties(file);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static final ImageProperties getJpegProperties(File file) throws FileNotFoundException, IOException, FileFormatException {
        in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            buf = new byte[2];
            count = in.read(buf, 0, 2);
            if (count < 2) {
                throw new FileFormatException("Not a valid Jpeg file!");
            }
            if (buf[0] != -1 || buf[1] != -40) {
                throw new FileFormatException("Not a valid Jpeg file!");
            }
            width = 0;
            height = 0;
            comment = null;
            hasDims = false;
            hasComment = false;
            ch = 0;
            ** GOTO lbl56
            {
                ch = in.read();
                do {
                    if (ch != 255) continue block5;
                    while (ch == 255) {
                        ch = in.read();
                    }
                    length = 256 * in.read();
                    if ((length += in.read()) < 2) {
                        throw new FileFormatException("Not a valid Jpeg file!");
                    }
                    if (ch >= 192 && ch <= 195) {
                        in.read();
                        height = 256 * in.read();
                        height += in.read();
                        width = 256 * in.read();
                        width += in.read();
                        foo = 0;
                        while (foo < length - 2 - 5) {
                            in.read();
                            ++foo;
                        }
                        hasDims = true;
                        continue;
                    }
                    if (ch == 254) {
                        comment = new char[length - 2];
                        foo = 0;
                        while (foo < length - 2) {
                            comment[foo] = (char)in.read();
                            ++foo;
                        }
                        hasComment = true;
                        continue;
                    }
                    foo = 0;
                    while (foo < length - 2) {
                        in.read();
                        ++foo;
                    }
lbl56:
                    // 4 sources

                } while (ch != 218 && (!hasDims || !hasComment));
            }
            var10_11 = new ImageProperties(width, height, comment, "jpeg");
            var13_13 = null;
            ** if (in == null) goto lbl66
        }
        catch (Throwable var12_17) {
            block17: {
                var13_14 = null;
                if (in == null) break block17;
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            throw var12_17;
        }
lbl-1000:
        // 1 sources

        {
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
lbl66:
        // 3 sources

        return var10_11;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ImageProperties getGifProperties(File file) throws FileNotFoundException, IOException, FileFormatException {
        ImageProperties imageProperties;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[10];
            int count = in.read(buf, 0, 10);
            if (count < 10) {
                throw new FileFormatException("Not a valid Gif file!");
            }
            if (buf[0] != 71 || buf[1] != 73 || buf[2] != 70) {
                throw new FileFormatException("Not a valid Gif file!");
            }
            int w1 = buf[6] & 0xFF | buf[6] & 0x80;
            int w2 = buf[7] & 0xFF | buf[7] & 0x80;
            int h1 = buf[8] & 0xFF | buf[8] & 0x80;
            int h2 = buf[9] & 0xFF | buf[9] & 0x80;
            int width = w1 + (w2 << 8);
            int height = h1 + (h2 << 8);
            imageProperties = new ImageProperties(width, height, null, "gif");
            Object var12_11 = null;
            if (in == null) return imageProperties;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {}
            throw throwable;
        }
        try {
            in.close();
            return imageProperties;
        }
        catch (IOException e) {
            // empty catch block
        }
        return imageProperties;
    }
}

