/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.io.IOException;
import java.io.InputStream;

public class PostInputStream
extends InputStream {
    public static final String CLASS = (class$org$apache$cocoon$util$PostInputStream == null ? (class$org$apache$cocoon$util$PostInputStream = PostInputStream.class$("org.apache.cocoon.util.PostInputStream")) : class$org$apache$cocoon$util$PostInputStream).getName();
    private InputStream m_inputStream = null;
    private int m_contentLen = 0;
    protected int m_bytesRead = 0;
    static /* synthetic */ Class class$org$apache$cocoon$util$PostInputStream;

    public PostInputStream() {
    }

    public PostInputStream(InputStream input, int len) throws IllegalArgumentException {
        this.init(input, len);
    }

    protected void init(InputStream input, int len) throws IllegalArgumentException {
        if (len <= 0) {
            throw new IllegalArgumentException("contentLen <= 0 ");
        }
        this.m_inputStream = input;
        this.m_contentLen = len;
    }

    public synchronized void setInputStream(InputStream input, int len) throws IOException {
        if (this.m_inputStream != null) {
            this.close();
        }
        this.init(input, len);
    }

    public InputStream getInputStream() {
        return this.m_inputStream;
    }

    public int getContentLen() {
        return this.m_contentLen;
    }

    public synchronized int read() throws IOException {
        this.checkOpen();
        if (this.m_bytesRead == this.m_contentLen) {
            return -1;
        }
        int byt = this.m_inputStream.read();
        if (byt != -1) {
            ++this.m_bytesRead;
        }
        return byt;
    }

    public synchronized int read(byte[] buffer, int offset, int len) throws IOException {
        this.checkOpen();
        if (this.m_bytesRead == this.m_contentLen) {
            return -1;
        }
        int available = Math.min(this.available(), len);
        int num = this.m_inputStream.read(buffer, offset, available);
        if (num > 0) {
            this.m_bytesRead += num;
        }
        return num;
    }

    public synchronized int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    protected void checkOpen() throws IOException {
        if (this.m_inputStream == null) {
            throw new IOException("InputStream closed");
        }
    }

    public synchronized long skip(long n) throws IOException {
        this.checkOpen();
        if (this.m_bytesRead == this.m_contentLen) {
            return 0L;
        }
        return this.m_inputStream.skip(n);
    }

    public synchronized int available() throws IOException {
        this.checkOpen();
        int avail = this.m_inputStream.available();
        return avail == 0 ? this.m_contentLen - this.m_bytesRead : avail;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void close() throws IOException {
        if (this.m_inputStream == null) {
            return;
        }
        this.m_inputStream.close();
        this.m_inputStream = null;
        this.m_contentLen = 0;
        this.m_bytesRead = 0;
    }

    public String toString() {
        return this.getClass().getName() + "[inputStream=" + this.m_inputStream + ",  contentLen=" + this.m_contentLen + "bytesRead=" + this.m_bytesRead + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

