/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.util.Vector;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.TransformStateSetter;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public abstract class ToSAXHandler
extends SerializerBase {
    protected ContentHandler m_saxHandler;
    protected LexicalHandler m_lexHandler;
    protected TransformStateSetter m_state = null;

    public ToSAXHandler() {
    }

    public ToSAXHandler(ContentHandler hdlr, LexicalHandler lex, String encoding) {
        this.setContentHandler(hdlr);
        this.setLexHandler(lex);
        this.setEncoding(encoding);
    }

    public ToSAXHandler(ContentHandler handler, String encoding) {
        this.setContentHandler(handler);
        this.setEncoding(encoding);
    }

    protected void startDocumentInternal() throws SAXException {
        if (this.m_needToCallStartDocument) {
            super.startDocumentInternal();
            this.m_saxHandler.startDocument();
            this.m_needToCallStartDocument = false;
        }
    }

    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    public void characters(String characters) throws SAXException {
        this.characters(characters.toCharArray(), 0, characters.length());
    }

    public void comment(String comment) throws SAXException {
        if (this.m_startTagOpen) {
            this.closeStartTag();
        } else if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (this.m_lexHandler != null) {
            this.m_lexHandler.comment(comment.toCharArray(), 0, comment.length());
            if (this.m_tracer != null) {
                super.fireCommentEvent(comment.toCharArray(), 0, comment.length());
            }
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    protected void closeStartTag() throws SAXException {
    }

    protected void closeCDATA() throws SAXException {
    }

    public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
        if (this.m_state != null) {
            this.m_state.resetState(this.getTransformer());
        }
        if (this.m_tracer != null) {
            super.fireStartElem(arg2);
        }
    }

    public void setLexHandler(LexicalHandler _lexHandler) {
        this.m_lexHandler = _lexHandler;
    }

    public void setContentHandler(ContentHandler _saxHandler) {
        this.m_saxHandler = _saxHandler;
        if (this.m_lexHandler == null && _saxHandler instanceof LexicalHandler) {
            this.m_lexHandler = (LexicalHandler)((Object)_saxHandler);
        }
    }

    public void setCdataSectionElements(Vector URI_and_localNames) {
    }

    public void flushPending() {
        try {
            if (this.m_needToCallStartDocument) {
                this.startDocumentInternal();
                this.m_needToCallStartDocument = false;
            }
            if (this.m_startTagOpen) {
                this.closeStartTag();
                this.m_startTagOpen = false;
            }
            if (this.m_cdataTagOpen) {
                this.closeCDATA();
                this.m_cdataTagOpen = false;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void setTransformState(TransformStateSetter ts) {
        this.m_state = ts;
    }

    public void startElement(String uri, String localName, String qName) throws SAXException {
        if (this.m_state != null) {
            this.m_state.resetState(this.getTransformer());
        }
        if (this.m_tracer != null) {
            super.fireStartElem(qName);
        }
    }

    public void startElement(String qName) throws SAXException {
        if (this.m_state != null) {
            this.m_state.resetState(this.getTransformer());
        }
        if (this.m_tracer != null) {
            super.fireStartElem(qName);
        }
    }

    public void characters(Node node) throws SAXException {
        if (this.m_state != null) {
            this.m_state.setCurrentNode(node);
        }
        super.characters(node);
    }

    public void fatalError(SAXParseException exc) throws SAXException {
        super.fatalError(exc);
        this.m_needToCallStartDocument = false;
        if (this.m_saxHandler instanceof ErrorHandler) {
            ((ErrorHandler)((Object)this.m_saxHandler)).fatalError(exc);
        }
    }

    public void error(SAXParseException exc) throws SAXException {
        super.error(exc);
        if (this.m_saxHandler instanceof ErrorHandler) {
            ((ErrorHandler)((Object)this.m_saxHandler)).error(exc);
        }
    }

    public void warning(SAXParseException exc) throws SAXException {
        super.warning(exc);
        if (this.m_saxHandler instanceof ErrorHandler) {
            ((ErrorHandler)((Object)this.m_saxHandler)).warning(exc);
        }
    }

    public boolean reset() {
        boolean wasReset = false;
        if (super.reset()) {
            this.resetToSAXHandler();
            wasReset = true;
        }
        return wasReset;
    }

    private void resetToSAXHandler() {
        this.m_lexHandler = null;
        this.m_saxHandler = null;
        this.m_state = null;
    }
}

