/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.SerializerConstants;
import org.apache.xml.serializer.ToSAXHandler;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ToXMLSAXHandler
extends ToSAXHandler {
    protected boolean m_escapeSetting = false;

    public ToXMLSAXHandler() {
        this.m_prefixMap = new NamespaceMappings();
        this.initCDATA();
    }

    public Properties getOutputFormat() {
        return null;
    }

    public OutputStream getOutputStream() {
        return null;
    }

    public Writer getWriter() {
        return null;
    }

    public void indent(int n) throws SAXException {
    }

    public void serialize(Node node) throws IOException {
    }

    public boolean setEscaping(boolean escape) throws SAXException {
        boolean oldEscapeSetting = this.m_escapeSetting;
        this.m_escapeSetting = escape;
        if (escape) {
            this.processingInstruction("javax.xml.transform.enable-output-escaping", "");
        } else {
            this.processingInstruction("javax.xml.transform.disable-output-escaping", "");
        }
        return oldEscapeSetting;
    }

    public void setOutputFormat(Properties format) {
    }

    public void setOutputStream(OutputStream output) {
    }

    public void setWriter(Writer writer) {
    }

    public void attributeDecl(String arg0, String arg1, String arg2, String arg3, String arg4) throws SAXException {
    }

    public void elementDecl(String arg0, String arg1) throws SAXException {
    }

    public void externalEntityDecl(String arg0, String arg1, String arg2) throws SAXException {
    }

    public void internalEntityDecl(String arg0, String arg1) throws SAXException {
    }

    public void endDocument() throws SAXException {
        this.flushPending();
        this.m_saxHandler.endDocument();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    protected void closeStartTag() throws SAXException {
        this.m_startTagOpen = false;
        String localName = SerializerBase.getLocalName(this.m_elementName);
        String uri = this.getNamespaceURI(this.m_elementName, true);
        if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
        }
        this.m_saxHandler.startElement(uri, localName, this.m_elementName, this.m_attributes);
        this.m_attributes.clear();
        if (this.m_state != null) {
            this.m_state.setCurrentNode(null);
        }
        this.pushCdataSectionState();
    }

    public void closeCDATA() throws SAXException {
        this.m_saxHandler.characters(SerializerConstants.ENDCDATA, 0, SerializerConstants.ENDCDATA.length);
        this.m_cdataTagOpen = false;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.flushPending();
        if (namespaceURI == null) {
            namespaceURI = this.m_elementURI != null ? this.m_elementURI : this.getNamespaceURI(qName, true);
        }
        if (localName == null) {
            localName = this.m_elementLocalName != null ? this.m_elementLocalName : SerializerBase.getLocalName(qName);
        }
        this.m_saxHandler.endElement(namespaceURI, localName, qName);
        if (this.m_tracer != null) {
            super.fireEndElem(qName);
        }
        this.m_prefixMap.popNamespaces(this.m_currentElemDepth);
        --this.m_currentElemDepth;
        this.m_startTagOpen = false;
        if (this.m_cdataSectionElements != null) {
            this.m_cdataSectionStates.pop();
        }
        this.m_elementURI = null;
        this.m_elementLocalName = null;
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        this.m_saxHandler.ignorableWhitespace(arg0, arg1, arg2);
    }

    public void setDocumentLocator(Locator arg0) {
        this.m_saxHandler.setDocumentLocator(arg0);
    }

    public void skippedEntity(String arg0) throws SAXException {
        this.m_saxHandler.skippedEntity(arg0);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.startPrefixMapping(prefix, uri, true);
    }

    public boolean startPrefixMapping(String prefix, String uri, boolean shouldFlush) throws SAXException {
        int pushDepth;
        if (shouldFlush) {
            this.flushPending();
            pushDepth = this.m_currentElemDepth + 1;
        } else {
            pushDepth = this.m_currentElemDepth;
        }
        boolean pushed = this.m_prefixMap.pushNamespace(prefix, uri, pushDepth);
        if (pushed) {
            this.m_saxHandler.startPrefixMapping(prefix, uri);
            if ("".equals(prefix)) {
                String name = "xmlns";
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", prefix, name, "CDATA", uri);
            } else if (!"".equals(uri)) {
                String name = "xmlns:" + prefix;
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", prefix, name, "CDATA", uri);
            }
        }
        return pushed;
    }

    public void comment(char[] arg0, int arg1, int arg2) throws SAXException {
        this.flushPending();
        if (this.m_lexHandler != null) {
            this.m_lexHandler.comment(arg0, arg1, arg2);
        }
        if (this.m_tracer != null) {
            super.fireCommentEvent(arg0, arg1, arg2);
        }
    }

    public void endCDATA() throws SAXException {
        if (this.m_lexHandler != null) {
            this.m_lexHandler.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        if (this.m_lexHandler != null) {
            this.m_lexHandler.endDTD();
        }
    }

    public void startEntity(String arg0) throws SAXException {
        if (this.m_lexHandler != null) {
            this.m_lexHandler.startEntity(arg0);
        }
    }

    public void characters(String chars) throws SAXException {
        char[] arr = chars.toCharArray();
        this.characters(arr, 0, arr.length);
    }

    public ToXMLSAXHandler(ContentHandler handler, String encoding) {
        super(handler, encoding);
        this.initCDATA();
        this.m_prefixMap = new NamespaceMappings();
    }

    public ToXMLSAXHandler(ContentHandler handler, LexicalHandler lex, String encoding) {
        super(handler, lex, encoding);
        this.initCDATA();
        this.m_prefixMap = new NamespaceMappings();
    }

    public void startElement(String elementNamespaceURI, String elementLocalName, String elementName) throws SAXException {
        this.startElement(elementNamespaceURI, elementLocalName, elementName, null);
    }

    public void startElement(String elementName) throws SAXException {
        this.startElement(null, null, elementName, null);
    }

    public void characters(char[] ch, int off, int len) throws SAXException {
        this.flushPending();
        if (this.m_cdataSectionStates.peekOrFalse()) {
            this.startCDATA(ch, off, len);
        } else {
            this.m_saxHandler.characters(ch, off, len);
        }
        if (this.m_tracer != null) {
            this.fireCharEvent(ch, off, len);
        }
    }

    public void endElement(String elemName) throws SAXException {
        this.endElement(null, null, elemName);
    }

    public void namespaceAfterStartElement(String prefix, String uri) throws SAXException {
        this.startPrefixMapping(prefix, uri, false);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.flushPending();
        this.m_saxHandler.processingInstruction(target, data);
        if (this.m_tracer != null) {
            super.fireEscapingEvent(target, data);
        }
    }

    protected boolean popNamespace(String prefix) {
        try {
            if (this.m_prefixMap.popNamespace(prefix)) {
                this.m_saxHandler.endPrefixMapping(prefix);
                return true;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return false;
    }

    public void startCDATA() throws SAXException {
        this.m_saxHandler.characters(SerializerConstants.BEGCDATA, 0, SerializerConstants.BEGCDATA.length);
        this.m_cdataTagOpen = true;
    }

    private void startCDATA(char[] ch, int off, int len) throws SAXException {
        int limit = off + len;
        int offset = off;
        this.m_saxHandler.characters(SerializerConstants.BEGCDATA, 0, SerializerConstants.BEGCDATA.length);
        int i = offset;
        while (i < limit - 2) {
            if (ch[i] == ']' && ch[i + 1] == ']' && ch[i + 2] == '>') {
                this.m_saxHandler.characters(ch, offset, i - offset);
                this.m_saxHandler.characters(SerializerConstants.CNTCDATA, 0, SerializerConstants.CNTCDATA.length);
                offset = i + 3;
                i += 2;
            }
            ++i;
        }
        if (offset < limit) {
            this.m_saxHandler.characters(ch, offset, limit - offset);
        }
        this.m_cdataTagOpen = true;
    }

    public void startElement(String namespaceURI, String localName, String name, Attributes atts) throws SAXException {
        this.flushPending();
        super.startElement(namespaceURI, localName, name, atts);
        if (this.m_needToOutputDocTypeDecl) {
            String doctypeSystem = this.getDoctypeSystem();
            if (doctypeSystem != null && this.m_lexHandler != null) {
                String doctypePublic = this.getDoctypePublic();
                if (doctypeSystem != null) {
                    this.m_lexHandler.startDTD(name, doctypePublic, doctypeSystem);
                }
            }
            this.m_needToOutputDocTypeDecl = false;
        }
        ++this.m_currentElemDepth;
        if (namespaceURI != null) {
            this.ensurePrefixIsDeclared(namespaceURI, name);
        }
        this.m_elementLocalName = localName;
        this.m_elementURI = namespaceURI;
        this.m_elementName = name;
        if (atts != null) {
            this.addAttributes(atts);
        }
        this.m_startTagOpen = true;
        this.pushCdataSectionState();
    }

    private void ensurePrefixIsDeclared(String ns, String rawName) throws SAXException {
        if (ns != null && ns.length() > 0) {
            String foundURI;
            String prefix;
            int index = rawName.indexOf(":");
            String string = prefix = index < 0 ? "" : rawName.substring(0, index);
            if (!(null == prefix || null != (foundURI = this.m_prefixMap.lookupNamespace(prefix)) && foundURI.equals(ns))) {
                this.startPrefixMapping(prefix, ns, false);
                this.addAttributeAlways("http://www.w3.org/2000/xmlns/", prefix, "xmlns" + (prefix.length() == 0 ? "" : ":") + prefix, "CDATA", ns);
            }
        }
    }

    public void addAttribute(String uri, String localName, String rawName, String type, String value) throws SAXException {
        if (this.m_startTagOpen) {
            this.ensurePrefixIsDeclared(uri, rawName);
            this.addAttributeAlways(uri, localName, rawName, type, value);
        }
    }

    public boolean reset() {
        boolean wasReset = false;
        if (super.reset()) {
            this.resetToXMLSAXHandler();
            wasReset = true;
        }
        return wasReset;
    }

    private void resetToXMLSAXHandler() {
        this.m_escapeSetting = false;
    }
}

