/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation.asciiart;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.CascadingIOException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.generation.asciiart.AsciiArtPad;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AsciiArtSVGGenerator
extends AbstractGenerator
implements CacheableProcessingComponent {
    protected Source inputSource;
    private AttributesImpl attributes = null;
    private AsciiArtPad asciiArtPad;
    private String PREFIX = "";
    private String URI = "http://www.w3.org/2000/svg";
    private final String DEFAULT_LINE_ATTRIBUTE = "stroke:black; stroke-width:1.5";
    private final String DEFAULT_TEXT_ATTRIBUTE = "font-size: 12; font-family:Times Roman; fill:blue;";
    private String lineAttribute = "stroke:black; stroke-width:1.5";
    private String textAttribute = "font-size: 12; font-family:Times Roman; fill:blue;";
    final int DEFAULT_X_GRID = 10;
    final int DEFAULT_Y_GRID = 12;
    private int xGrid = 10;
    private int yGrid = 12;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        try {
            this.inputSource = resolver.resolveURI(src);
        }
        catch (SourceException se) {
            throw SourceUtil.handle((String)("Error during resolving of '" + src + "'."), (SourceException)se);
        }
        this.lineAttribute = par.getParameter("line-attribute", "stroke:black; stroke-width:1.5");
        this.textAttribute = par.getParameter("text-attribute", "font-size: 12; font-family:Times Roman; fill:blue;");
        this.xGrid = par.getParameterAsInteger("x-grid", 10);
        this.yGrid = par.getParameterAsInteger("y-grid", 12);
    }

    public void recycle() {
        if (null != this.inputSource) {
            this.resolver.release(this.inputSource);
            this.inputSource = null;
        }
        super.recycle();
    }

    public Serializable getKey() {
        return this.inputSource.getURI();
    }

    public SourceValidity getValidity() {
        return this.inputSource.getValidity();
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("processing asciiart file " + this.source);
                this.getLogger().debug("asciiart file resolved to " + this.inputSource.getURI());
            }
            String[] asciiArt = this.readAsciiArt();
            this.asciiArtPad = new AsciiArtPad();
            this.asciiArtPad.setXGrid(this.xGrid);
            this.asciiArtPad.setYGrid(this.yGrid);
            AsciiArtPad.AsciiArtPadBuilder builder = new AsciiArtPad.AsciiArtPadBuilder(this.asciiArtPad);
            builder.build(asciiArt);
            this.attributes = new AttributesImpl();
            this.contentHandler.startDocument();
            this.contentHandler.startPrefixMapping(this.PREFIX, this.URI);
            this.attributes.clear();
            this.addAttribute("width", String.valueOf(this.asciiArtPad.getXGrid() * (double)this.asciiArtPad.getWidth()));
            this.addAttribute("height", String.valueOf(this.asciiArtPad.getYGrid() * (double)this.asciiArtPad.getHeight()));
            this.startElement("svg", this.attributes);
            this.attributes.clear();
            this.addAttribute("style", this.lineAttribute);
            this.startElement("g", this.attributes);
            this.generateSVGLineElements();
            this.endElement("g");
            this.attributes.clear();
            this.addAttribute("style", this.textAttribute);
            this.startElement("g", this.attributes);
            this.generateSVGTextElements();
            this.endElement("g");
            this.endElement("svg");
            this.contentHandler.endPrefixMapping(this.PREFIX);
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            Exception cause = e.getException();
            if (cause != null) {
                if (cause instanceof ProcessingException) {
                    throw (ProcessingException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof SAXException) {
                    throw (SAXException)cause;
                }
                throw new ProcessingException("Could not read resource " + this.inputSource.getURI(), (Throwable)cause);
            }
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String[] readAsciiArt() throws IOException {
        String[] stringArray;
        BufferedReader br;
        block7: {
            InputStream is = null;
            br = null;
            try {
                try {
                    is = this.inputSource.getInputStream();
                    br = new BufferedReader(new InputStreamReader(is));
                    ArrayList<void> lines = new ArrayList<void>();
                    while (true) {
                        void var3_4;
                        String line;
                        if ((line = br.readLine()) == null) {
                            String[] asciiArt;
                            stringArray = asciiArt = lines.toArray(new String[0]);
                            Object var8_8 = null;
                            if (is == null) break block7;
                            break;
                        }
                        lines.add(var3_4);
                    }
                }
                catch (SourceException se) {
                    throw new CascadingIOException("Cannot get input stream", (Throwable)se);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (is != null) {
                    is.close();
                }
                if (br == null) throw throwable;
                br.close();
                throw throwable;
            }
            is.close();
        }
        if (br == null) return stringArray;
        br.close();
        return stringArray;
    }

    protected void generateSVGLineElements() throws SAXException {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
        DecimalFormat df = new DecimalFormat("##0.0##", dfs);
        Iterator i = this.asciiArtPad.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof AsciiArtPad.AsciiArtLine)) continue;
            AsciiArtPad.AsciiArtLine aal = (AsciiArtPad.AsciiArtLine)o;
            double mx = aal.getXStart();
            double my = aal.getYStart();
            double lx = aal.getXEnd();
            double ly = aal.getYEnd();
            this.attributes.clear();
            this.addAttribute("d", "M " + df.format(mx) + " " + df.format(my) + " " + "L " + df.format(lx) + " " + df.format(ly));
            this.startElement("path", this.attributes);
            this.endElement("path");
        }
    }

    protected void generateSVGTextElements() throws SAXException {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
        DecimalFormat df = new DecimalFormat("##0.0##", dfs);
        Iterator i = this.asciiArtPad.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof AsciiArtPad.AsciiArtString)) continue;
            AsciiArtPad.AsciiArtString aas = (AsciiArtPad.AsciiArtString)o;
            double x = aas.getX();
            double y = aas.getY();
            this.attributes.clear();
            this.addAttribute("x", df.format(x));
            this.addAttribute("y", df.format(y));
            this.startElement("text", this.attributes);
            this.characters(aas.getS());
            this.endElement("text");
        }
    }

    protected void startElement(String nodeName, Attributes attributes) throws SAXException {
        if (this.PREFIX.length() > 0) {
            this.contentHandler.startElement(this.URI, nodeName, this.PREFIX + ":" + nodeName, attributes);
        } else {
            this.contentHandler.startElement(this.URI, nodeName, nodeName, attributes);
        }
    }

    protected void characters(String s) throws SAXException {
        if (s != null) {
            char[] stringCharacters = s.toCharArray();
            this.contentHandler.characters(stringCharacters, 0, stringCharacters.length);
        }
    }

    protected void endElement(String nodeName) throws SAXException {
        if (this.PREFIX.length() > 0) {
            this.contentHandler.endElement(this.URI, nodeName, this.PREFIX + ":" + nodeName);
        } else {
            this.contentHandler.endElement(this.URI, nodeName, nodeName);
        }
    }

    protected void addAttribute(String nodeName, String nodeValue) {
        this.attributes.addAttribute("", nodeName, nodeName, "CDATA", nodeValue);
    }
}

