/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.events.UIEvent;

public class FocusManager {
    protected EventTarget lastFocusEventTarget;
    protected Document document;
    protected EventListener mouseclickListener;
    protected EventListener domFocusInListener;
    protected EventListener domFocusOutListener;
    protected EventListener mouseoverListener;
    protected EventListener mouseoutListener;

    public FocusManager(Document doc) {
        this.document = doc;
        EventTarget target = (EventTarget)((Object)doc);
        this.mouseclickListener = new MouseClickTacker();
        target.addEventListener("click", this.mouseclickListener, true);
        this.mouseoverListener = new MouseOverTacker();
        target.addEventListener("mouseover", this.mouseoverListener, true);
        this.mouseoutListener = new MouseOutTacker();
        target.addEventListener("mouseout", this.mouseoutListener, true);
        this.domFocusInListener = new DOMFocusInTracker();
        target.addEventListener("DOMFocusIn", this.domFocusInListener, true);
        this.domFocusOutListener = new DOMFocusOutTracker();
        target.addEventListener("DOMFocusOut", this.domFocusOutListener, true);
    }

    public EventTarget getCurrentEventTarget() {
        return this.lastFocusEventTarget;
    }

    public void dispose() {
        EventTarget target = (EventTarget)((Object)this.document);
        target.removeEventListener("click", this.mouseclickListener, true);
        target.removeEventListener("mouseover", this.mouseoverListener, true);
        target.removeEventListener("mouseout", this.mouseoutListener, true);
        target.removeEventListener("DOMFocusIn", this.domFocusInListener, true);
        target.removeEventListener("DOMFocusOut", this.domFocusOutListener, true);
        this.lastFocusEventTarget = null;
        this.document = null;
    }

    protected void fireDOMFocusInEvent(EventTarget target) {
        DocumentEvent docEvt = (DocumentEvent)((Object)((Element)((Object)target)).getOwnerDocument());
        UIEvent uiEvt = (UIEvent)docEvt.createEvent("UIEvents");
        uiEvt.initUIEvent("DOMFocusIn", true, false, null, 0);
        target.dispatchEvent(uiEvt);
    }

    protected void fireDOMFocusOutEvent(EventTarget target) {
        DocumentEvent docEvt = (DocumentEvent)((Object)((Element)((Object)target)).getOwnerDocument());
        UIEvent uiEvt = (UIEvent)docEvt.createEvent("UIEvents");
        uiEvt.initUIEvent("DOMFocusOut", true, false, null, 0);
        target.dispatchEvent(uiEvt);
    }

    protected void fireDOMActivateEvent(EventTarget target, int detailArg) {
        DocumentEvent docEvt = (DocumentEvent)((Object)((Element)((Object)target)).getOwnerDocument());
        UIEvent uiEvt = (UIEvent)docEvt.createEvent("UIEvents");
        uiEvt.initUIEvent("DOMActivate", true, true, null, detailArg);
        target.dispatchEvent(uiEvt);
    }

    protected class MouseOutTacker
    implements EventListener {
        protected MouseOutTacker() {
        }

        public void handleEvent(Event evt) {
            EventTarget target = evt.getTarget();
            FocusManager.this.fireDOMFocusOutEvent(target);
        }
    }

    protected class MouseOverTacker
    implements EventListener {
        protected MouseOverTacker() {
        }

        public void handleEvent(Event evt) {
            EventTarget target = evt.getTarget();
            FocusManager.this.fireDOMFocusInEvent(target);
        }
    }

    protected class DOMFocusOutTracker
    implements EventListener {
        protected DOMFocusOutTracker() {
        }

        public void handleEvent(Event evt) {
            FocusManager.this.lastFocusEventTarget = null;
        }
    }

    protected class DOMFocusInTracker
    implements EventListener {
        protected DOMFocusInTracker() {
        }

        public void handleEvent(Event evt) {
            if (FocusManager.this.lastFocusEventTarget != null && FocusManager.this.lastFocusEventTarget != evt.getTarget()) {
                FocusManager.this.fireDOMFocusOutEvent(FocusManager.this.lastFocusEventTarget);
            }
            FocusManager.this.lastFocusEventTarget = evt.getTarget();
        }
    }

    protected class MouseClickTacker
    implements EventListener {
        protected MouseClickTacker() {
        }

        public void handleEvent(Event evt) {
            MouseEvent mevt = (MouseEvent)evt;
            FocusManager.this.fireDOMActivateEvent(evt.getTarget(), mevt.getDetail());
        }
    }
}

