/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.store.impl;

import EDU.oswego.cs.dl.util.concurrent.FIFOReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.store.Store;

public abstract class AbstractReadWriteStore
extends AbstractLogEnabled
implements Store,
ThreadSafe {
    protected ReadWriteLock lock = new FIFOReadWriteLock();

    public Object get(Object key) {
        Object value = null;
        Sync sync = this.lock.writeLock();
        try {
            sync.acquire();
            try {
                this.doGet(key);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                sync.release();
                throw throwable;
            }
            sync.release();
            {
            }
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        return value;
    }

    public void store(Object key, Object value) throws IOException {
        Sync sync = this.lock.writeLock();
        try {
            sync.acquire();
            try {
                this.doStore(key, value);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                sync.release();
                throw throwable;
            }
            sync.release();
            {
            }
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
    }

    public void free() {
        Sync sync = this.lock.writeLock();
        try {
            sync.acquire();
            try {
                this.doFree();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                sync.release();
                throw throwable;
            }
            sync.release();
            {
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void clear() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("clear(): Clearing the database ");
        }
        Sync sync = this.lock.writeLock();
        try {
            sync.acquire();
            try {
                this.doClear();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                sync.release();
                throw throwable;
            }
            sync.release();
            {
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void remove(Object key) {
        Sync sync = this.lock.writeLock();
        try {
            sync.acquire();
            try {
                this.doRemove(key);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                sync.release();
                throw throwable;
            }
            sync.release();
            {
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean containsKey(Object key) {
        Sync sync = this.lock.readLock();
        try {
            boolean bl;
            sync.acquire();
            try {
                bl = this.doContainsKey(key);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                sync.release();
                throw throwable;
            }
            sync.release();
            return bl;
        }
        catch (InterruptedException ignore) {
            return false;
        }
    }

    public Enumeration keys() {
        Sync sync = this.lock.readLock();
        try {
            Enumeration enumeration;
            sync.acquire();
            try {
                enumeration = this.doGetKeys();
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                sync.release();
                throw throwable;
            }
            sync.release();
            return enumeration;
        }
        catch (InterruptedException ignore) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
    }

    public int size() {
        Sync sync = this.lock.readLock();
        try {
            int n;
            sync.acquire();
            try {
                n = this.doGetSize();
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                sync.release();
                throw throwable;
            }
            sync.release();
            return n;
        }
        catch (InterruptedException ignore) {
            return 0;
        }
    }

    protected abstract Object doGet(Object var1);

    protected abstract void doStore(Object var1, Object var2) throws IOException;

    protected abstract void doFree();

    protected abstract void doRemove(Object var1);

    protected abstract void doClear();

    protected abstract boolean doContainsKey(Object var1);

    protected abstract Enumeration doGetKeys();

    protected abstract int doGetSize();
}

