/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ModifiableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class AvalonToCocoonSource
implements ModifiableSource {
    protected Source source;
    protected SourceResolver resolver;
    protected Environment environment;
    protected ComponentManager manager;

    public AvalonToCocoonSource(Source source, SourceResolver resolver, Environment environment, ComponentManager manager) {
        this.source = source;
        this.resolver = resolver;
        this.environment = environment;
        this.manager = manager;
    }

    public long getLastModified() {
        return this.source.getLastModified();
    }

    public long getContentLength() {
        return this.source.getContentLength();
    }

    public InputStream getInputStream() throws ProcessingException, IOException {
        try {
            return this.source.getInputStream();
        }
        catch (SourceException e) {
            throw SourceUtil.handle((SourceException)e);
        }
    }

    public InputSource getInputSource() throws ProcessingException, IOException {
        try {
            InputSource newObject = new InputSource(this.source.getInputStream());
            newObject.setSystemId(this.getSystemId());
            return newObject;
        }
        catch (SourceException se) {
            throw SourceUtil.handle((SourceException)se);
        }
    }

    public String getSystemId() {
        return this.source.getURI();
    }

    public void recycle() {
        this.resolver.release(this.source);
        this.source = null;
        this.environment = null;
    }

    public void refresh() {
        this.source.refresh();
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        try {
            SourceUtil.parse((ComponentManager)this.manager, (Source)this.source, (ContentHandler)handler);
        }
        catch (ProcessingException pe) {
            throw new SAXException("ProcessingException during streaming.", (Exception)((Object)pe));
        }
        catch (IOException ioe) {
            throw new SAXException("IOException during streaming.", ioe);
        }
    }
}

