/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.url;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.url.URLFactory;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.util.ClassUtils;

public class URLFactoryImpl
extends AbstractLogEnabled
implements ThreadSafe,
Configurable,
Disposable,
Composable,
Contextualizable,
URLFactory {
    protected org.apache.avalon.framework.context.Context context;
    protected Map factories;
    private ComponentManager manager;

    public URL getURL(String location) throws MalformedURLException {
        Iterator iter = this.factories.keySet().iterator();
        String protocol = null;
        while (iter.hasNext()) {
            protocol = (String)iter.next();
            if (!location.startsWith(protocol + "://")) continue;
            return ((URLFactory)this.factories.get(protocol)).getURL(location.substring(protocol.length() + 3));
        }
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Making URL from " + location);
            }
            return new URL(location);
        }
        catch (MalformedURLException mue) {
            URL url;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Making URL - MalformedURLException in getURL:", (Throwable)mue);
            }
            Context envContext = null;
            try {
                envContext = (Context)this.context.get((Object)"environment-context");
            }
            catch (ContextException e) {
                this.getLogger().error("Making URL - ContextException in getURL", (Throwable)e);
            }
            String path = envContext.getRealPath(location);
            if (path != null) {
                return new File(path).toURL();
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Making URL a Resource:" + location);
            }
            if ((url = envContext.getResource(location)) != null) {
                return url;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Making URL a File (assuming that it is full path):" + location);
            }
            return new File(location).toURL();
        }
    }

    public URL getURL(URL base, String location) throws MalformedURLException {
        if (base != null) {
            if (base.getProtocol().equals("file")) {
                File temp = new File(base.toExternalForm().substring("file:".length()), location);
                String path = temp.getAbsolutePath();
                if (path.charAt(0) != File.separator.charAt(0)) {
                    return this.getURL("file:/" + path);
                }
                return this.getURL("file:" + path);
            }
            return this.getURL(new URL(base, location).toExternalForm());
        }
        return this.getURL(location);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        if (this.context == null) {
            this.context = context;
        }
    }

    public void configure(Configuration conf) throws ConfigurationException {
        try {
            this.getLogger().debug("Getting the URLFactories");
            this.factories = new HashMap();
            Configuration[] configs = conf.getChildren("protocol");
            URLFactory urlFactory = null;
            String protocol = null;
            int i = 0;
            while (i < configs.length) {
                protocol = configs[i].getAttribute("name");
                if (this.factories.containsKey(protocol)) {
                    throw new ConfigurationException("URLFactory defined twice for protocol: " + protocol);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\tfor protocol: " + protocol + " " + configs[i].getAttribute("class"));
                }
                urlFactory = (URLFactory)ClassUtils.newInstance((String)configs[i].getAttribute("class"));
                this.init(urlFactory, configs[i]);
                this.factories.put(protocol, urlFactory);
                ++i;
            }
        }
        catch (Exception e) {
            this.getLogger().error("Could not get URLFactories", (Throwable)e);
            throw new ConfigurationException("Could not get parameters because: " + e.getMessage());
        }
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void dispose() {
        Iterator iter = this.factories.values().iterator();
        while (iter.hasNext()) {
            URLFactory current = (URLFactory)iter.next();
            this.deinit(current);
        }
        this.factories = null;
    }

    private void init(URLFactory factory, Configuration config) throws ContextException, ComponentException, ConfigurationException, ParameterException {
        if (factory instanceof LogEnabled) {
            ((LogEnabled)factory).enableLogging(this.getLogger());
        }
        if (factory instanceof Contextualizable) {
            ((Contextualizable)factory).contextualize(this.context);
        }
        if (factory instanceof Composable) {
            ((Composable)factory).compose(this.manager);
        }
        if (config != null && factory instanceof Configurable) {
            ((Configurable)factory).configure(config);
        }
        if (config != null && factory instanceof Parameterizable) {
            ((Parameterizable)factory).parameterize(Parameters.fromConfiguration((Configuration)config));
        }
    }

    private void deinit(URLFactory factory) {
        if (factory instanceof Disposable) {
            ((Disposable)factory).dispose();
        }
    }
}

