/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.adapter.ast;

import java.util.Enumeration;
import java.util.Vector;

public class Node {
    private String symbol = null;
    private String location = null;
    private Vector childs = new Vector();

    public Node(String symbol) {
        this.symbol = symbol;
    }

    public void addNode(int index, Node node) {
        if (node != null) {
            this.childs.add(index, node);
        }
    }

    public void addNode(Node node) {
        if (node != null) {
            this.childs.addElement(node);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Node) {
            Node node = (Node)o;
            if (!node.getSymbol().equals(this.getSymbol())) {
                return false;
            }
            if (node.getChildCount() != this.getChildCount()) {
                return false;
            }
            int i = 0;
            while (i < this.getChildCount()) {
                if (!this.getChildAt(i).equals(node.getChildAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public Node getChildAt(int index) {
        return (Node)this.childs.elementAt(index);
    }

    public int getChildCount() {
        return this.childs.size();
    }

    public int getIndex(Node node) {
        return this.childs.indexOf(node);
    }

    public String getLocation() {
        return this.location;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean isLeaf() {
        return this.childs.size() == 0;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setNode(int index, Node node) {
        if (node != null) {
            this.childs.setElementAt(node, index);
        }
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append(this.symbol);
        buffer.append(":");
        Enumeration e = this.childs.elements();
        while (e.hasMoreElements()) {
            buffer.append(e.nextElement());
        }
        buffer.append("}");
        return buffer.toString();
    }
}

