/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.adapter.ast;

import java.util.Stack;
import net.sourceforge.chaperon.adapter.ast.Leaf;
import net.sourceforge.chaperon.adapter.ast.Node;
import net.sourceforge.chaperon.process.Locator;
import net.sourceforge.chaperon.process.ParserHandler;

public class ParserAdapter
implements ParserHandler {
    private Locator locator = null;
    private Stack stack = null;
    private Node root = null;

    public Node getRootNode() {
        return this.root;
    }

    public void handleEndDocument() throws Exception {
        this.root = (Node)this.stack.pop();
    }

    public void handleLocator(Locator locator) {
        this.locator = locator;
    }

    public void handleRecovery() throws Exception {
        this.stack.pop();
    }

    public void handleReduceProduction(String symbol, int length) throws Exception {
        Node node = new Node(symbol);
        Node child = null;
        int i = 0;
        while (i < length) {
            child = (Node)this.stack.pop();
            node.addNode(0, child);
            ++i;
        }
        if (node != null) {
            node.setLocation(child.getLocation());
        }
        this.stack.push(node);
    }

    public void handleShiftLexeme(String symbol, String text) throws Exception {
        Leaf leaf = new Leaf(symbol, text);
        if (this.locator != null) {
            leaf.setLocation(String.valueOf(this.locator.getURI()) + ":" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber());
        }
        this.stack.push(leaf);
    }

    public void handleStartDocument() {
        this.stack = new Stack();
        this.root = null;
    }
}

