/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.adapter.sax;

import net.sourceforge.chaperon.common.Decoder;
import net.sourceforge.chaperon.process.LexicalHandler;
import net.sourceforge.chaperon.process.Locator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class LexicalHandlerAdapter
implements LexicalHandler {
    public static final String NS = "http://chaperon.sourceforge.net/schema/lexemes/1.0";
    private String ns = "http://chaperon.sourceforge.net/schema/lexemes/1.0";
    private ContentHandler handler;
    private boolean embedded = false;
    private Locator locator = null;
    private LocatorImpl saxlocator = null;

    public LexicalHandlerAdapter() {
    }

    public LexicalHandlerAdapter(boolean embedded) {
        this.embedded = embedded;
    }

    public void handleEndDocument() throws Exception {
        if (this.locator != null) {
            this.saxlocator.setLineNumber(this.locator.getLineNumber());
            this.saxlocator.setColumnNumber(this.locator.getColumnNumber());
        }
        this.handler.endElement(this.ns, "lexemes", "lexemes");
        this.handler.endPrefixMapping("");
        if (!this.embedded) {
            this.handler.endDocument();
        }
    }

    public void handleError(String symbol, String text, String message) throws Exception {
        StringBuffer exception = new StringBuffer();
        exception.append(message);
        if (symbol != null || text != null) {
            exception.append(" [");
        }
        if (symbol != null) {
            exception.append("symbol=\"" + symbol + "\" ");
        }
        if (text != null) {
            exception.append("text=\"" + Decoder.decode(text) + "\"");
        }
        if (symbol != null || text != null) {
            exception.append("]");
        }
        if (this.locator != null) {
            this.saxlocator.setLineNumber(this.locator.getLineNumber());
            this.saxlocator.setColumnNumber(this.locator.getColumnNumber());
            throw new SAXParseException(exception.toString(), this.saxlocator);
        }
        throw new SAXException(exception.toString());
    }

    public void handleLexeme(String symbol, String text) throws Exception {
        if (this.locator != null) {
            this.saxlocator.setLineNumber(this.locator.getLineNumber());
            this.saxlocator.setColumnNumber(this.locator.getColumnNumber());
        }
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "symbol", "symbol", "CDATA", symbol);
        atts.addAttribute("", "text", "text", "CDATA", text);
        this.handler.startElement(this.ns, "lexeme", "lexeme", atts);
        this.handler.endElement(this.ns, "lexeme", "lexeme");
    }

    public void handleLocator(Locator locator) {
        this.locator = locator;
        if (locator != null) {
            this.saxlocator = new LocatorImpl();
            this.saxlocator.setSystemId(locator.getURI());
            this.saxlocator.setLineNumber(locator.getLineNumber());
            this.saxlocator.setColumnNumber(locator.getColumnNumber());
        } else {
            this.saxlocator = null;
        }
    }

    public void handleStartDocument() throws Exception {
        if (this.locator != null) {
            this.handler.setDocumentLocator(this.saxlocator);
        }
        if (!this.embedded) {
            this.handler.startDocument();
        }
        this.handler.startPrefixMapping("", this.ns);
        AttributesImpl atts = new AttributesImpl();
        this.handler.startElement(this.ns, "lexemes", "lexemes", atts);
    }

    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public void setNamespace(String namespace) {
        this.ns = namespace;
    }
}

