/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.adapter.sax;

import net.sourceforge.chaperon.adapter.sax.LocatorAdapter;
import net.sourceforge.chaperon.process.Locator;
import net.sourceforge.chaperon.process.ParserProcessor;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ParserProcessorAdapter
implements ContentHandler,
LexicalHandler {
    private static final String NS = "http://chaperon.sourceforge.net/schema/lexemes/1.0";
    private static final String LEXEMES = "lexemes";
    private static final String LEXEME = "lexeme";
    private ParserProcessor processor = null;
    private ContentHandler contenthandler = null;
    private LexicalHandler lexicalhandler = null;
    private org.xml.sax.Locator saxlocator = null;
    private Locator locator = null;
    private static final int STATE_OUTER = 0;
    private static final int STATE_LEXEMES = 1;
    private static final int STATE_LEXEME = 2;
    private int state = 0;

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.state == 0) {
            this.contenthandler.characters(ch, start, length);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.state == 0) {
            this.lexicalhandler.comment(ch, start, length);
        }
    }

    public void endCDATA() throws SAXException {
        if (this.state == 0) {
            this.lexicalhandler.endCDATA();
        }
    }

    public void endDTD() throws SAXException {
        if (this.state == 0) {
            this.lexicalhandler.endDTD();
        }
    }

    public void endDocument() throws SAXException {
        if (this.state == 0) {
            this.contenthandler.endDocument();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.state == 0) {
            this.contenthandler.endElement(namespaceURI, localName, qName);
            return;
        }
        if (this.state == 1) {
            if (namespaceURI == null || !namespaceURI.equals(NS) || !localName.equals(LEXEMES)) throw new SAXException("Unexpected end element.");
            try {
                this.processor.handleEndDocument();
            }
            catch (Exception e) {
                if (!(e instanceof SAXException)) throw new SAXException(e);
                throw (SAXException)e;
            }
            if (this.saxlocator != null) {
                this.contenthandler.setDocumentLocator(this.saxlocator);
            }
            this.state = 0;
            return;
        }
        if (this.state != 2) return;
        this.state = 1;
    }

    public void endEntity(String name) throws SAXException {
        if (this.state == 0) {
            this.lexicalhandler.endEntity(name);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.contenthandler.endPrefixMapping(prefix);
    }

    public ParserProcessor getParserProcessor() {
        return this.processor;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.state == 0) {
            this.contenthandler.ignorableWhitespace(ch, start, length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.state == 0) {
            this.contenthandler.processingInstruction(target, data);
        }
    }

    public void setContentHandler(ContentHandler contenthandler) {
        this.contenthandler = contenthandler;
    }

    public void setDocumentLocator(org.xml.sax.Locator locator) {
        this.saxlocator = locator;
        if (locator != null) {
            this.locator = new LocatorAdapter(locator);
            this.contenthandler.setDocumentLocator(locator);
        } else {
            this.locator = null;
        }
    }

    public void setLexicalHandler(LexicalHandler lexicalhandler) {
        this.lexicalhandler = lexicalhandler;
    }

    public void setParserProcessor(ParserProcessor processor) {
        this.processor = processor;
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.state == 0) {
            this.contenthandler.skippedEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        if (this.state == 0) {
            this.lexicalhandler.startCDATA();
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.state == 0) {
            this.lexicalhandler.startDTD(name, publicId, systemId);
        }
    }

    public void startDocument() throws SAXException {
        this.contenthandler.startDocument();
        this.state = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (this.state == 0) {
            if (namespaceURI != null && namespaceURI.equals(NS) && localName.equals(LEXEMES)) {
                if (this.locator != null) {
                    this.processor.handleLocator(this.locator);
                }
                try {
                    this.processor.handleStartDocument();
                }
                catch (Exception e) {
                    if (!(e instanceof SAXException)) throw new SAXException(e);
                    throw (SAXException)e;
                }
                this.state = 1;
                return;
            }
            this.contenthandler.startElement(namespaceURI, localName, qName, atts);
            return;
        }
        if (this.state == 1) {
            if (namespaceURI == null || !namespaceURI.equals(NS) || !localName.equals(LEXEME)) throw new SAXException("Unexpected start element.");
            try {
                this.processor.handleLexeme(atts.getValue("symbol"), atts.getValue("text"));
            }
            catch (Exception e) {
                if (!(e instanceof SAXException)) throw new SAXException(e);
                throw (SAXException)e;
            }
            this.state = 2;
            return;
        }
        if (this.state != 2) return;
        throw new SAXException("Unexpected start element.");
    }

    public void startEntity(String name) throws SAXException {
        if (this.state == 0) {
            this.lexicalhandler.startEntity(name);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.contenthandler.startPrefixMapping(prefix, uri);
    }
}

