/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.build;

import net.sourceforge.chaperon.build.PatternAutomatonBuilder;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.lexicon.Lexeme;
import net.sourceforge.chaperon.model.lexicon.Lexicon;
import net.sourceforge.chaperon.process.LexicalAutomaton;
import net.sourceforge.chaperon.process.PatternAutomaton;
import org.apache.avalon.framework.logger.Logger;

public class LexicalAutomatonBuilder {
    private Lexicon lexicon = null;
    private LexicalAutomaton automaton = null;
    private Logger logger = null;

    public LexicalAutomatonBuilder(Lexicon lexicon) {
        this(lexicon, null);
    }

    public LexicalAutomatonBuilder(Lexicon lexicon, Logger logger) {
        this.logger = logger;
        try {
            this.lexicon = (Lexicon)lexicon.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException("Lexicon is nor cloneable");
        }
        Violations violations = lexicon.validate();
        if (violations != null && violations.getViolationCount() > 0) {
            throw new IllegalArgumentException("Lexicon is not valid: " + violations.getViolation(0));
        }
        LexicalAutomaton automaton = new LexicalAutomaton(lexicon.getLexemeCount());
        PatternAutomaton definition = null;
        int i = 0;
        while (i < lexicon.getLexemeCount()) {
            Lexeme lexeme = lexicon.getLexeme(i);
            automaton.setLexemeSymbol(i, lexeme.getSymbol() != null ? lexeme.getSymbol().getName() : null);
            definition = new PatternAutomatonBuilder(lexeme.getDefinition()).getPatternAutomaton();
            if (definition == null) {
                throw new IllegalArgumentException("Couldn't create PatternAutomaton for " + lexeme.getSymbol() + " of \"" + lexeme.getDefinition() + "\"");
            }
            automaton.setLexemeDefinition(i, definition);
            ++i;
        }
        this.automaton = automaton;
    }

    public LexicalAutomaton getLexicalAutomaton() {
        return this.automaton;
    }
}

