/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.build;

import net.sourceforge.chaperon.build.EndOfFile;
import net.sourceforge.chaperon.build.FirstSetCollection;
import net.sourceforge.chaperon.build.ItemSet;
import net.sourceforge.chaperon.build.ItemSetCollection;
import net.sourceforge.chaperon.build.conflict.ConflictList;
import net.sourceforge.chaperon.build.conflict.ReduceReduceConflict;
import net.sourceforge.chaperon.build.conflict.ShiftReduceConflict;
import net.sourceforge.chaperon.common.IntegerSet;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.grammar.Associativity;
import net.sourceforge.chaperon.model.grammar.Grammar;
import net.sourceforge.chaperon.model.symbol.SymbolSet;
import net.sourceforge.chaperon.model.symbol.Terminal;
import net.sourceforge.chaperon.process.ParserAutomaton;
import org.apache.avalon.framework.logger.Logger;

public class ParserAutomatonBuilder {
    private static final EndOfFile EOF = new EndOfFile();
    private Grammar grammar;
    private SymbolSet tsymbols;
    private SymbolSet ntsymbols;
    private FirstSetCollection firstsets;
    private ItemSetCollection itemsets;
    private ParserAutomaton automaton;
    private ConflictList conflicts = new ConflictList();
    private Logger logger;

    public ParserAutomatonBuilder(Grammar grammar) {
        this(grammar, null);
    }

    public ParserAutomatonBuilder(Grammar grammar, Logger logger) {
        try {
            this.grammar = (Grammar)grammar.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException("Grammar is nor cloneable");
        }
        this.logger = logger;
        Violations violations = grammar.validate();
        if (violations != null && violations.getViolationCount() > 0) {
            throw new IllegalArgumentException("Grammar is not valid: " + violations.getViolation(0));
        }
        SymbolSet symbols = grammar.getSymbols();
        this.tsymbols = symbols.getTerminals();
        this.ntsymbols = symbols.getNonterminals();
        long time = System.currentTimeMillis();
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug("Generating first sets");
        }
        this.firstsets = new FirstSetCollection(grammar, logger);
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(this.firstsets.toString());
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug("Building states and transitions");
        }
        this.itemsets = new ItemSetCollection(grammar, this.firstsets, logger);
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(this.itemsets.toString());
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug("Building parser automaton");
        }
        this.automaton = new ParserAutomaton(this.tsymbols.getSymbolCount(), this.ntsymbols.getSymbolCount(), grammar.getProductionCount(), 0, this.itemsets.getItemSetCount());
        int i = 0;
        while (i < this.tsymbols.getSymbolCount()) {
            this.automaton.setTerminal(i, this.tsymbols.getSymbol(i).getName());
            ++i;
        }
        i = 0;
        while (i < this.ntsymbols.getSymbolCount()) {
            this.automaton.setNonterminal(i, this.ntsymbols.getSymbol(i).getName());
            ++i;
        }
        i = 0;
        while (i < grammar.getProductionCount()) {
            this.automaton.setProductionSymbol(i, this.ntsymbols.indexOf(grammar.getProduction(i).getSymbol()));
            this.automaton.setProductionLength(i, grammar.getProduction(i).getLength());
            ++i;
        }
        int state = 0;
        while (state < this.itemsets.getItemSetCount()) {
            int k;
            int highestproduction;
            int productionpriority;
            IntegerSet reduceproductions;
            ItemSet I = this.itemsets.getItemSet(state);
            SymbolSet shiftsymbols = I.getShiftSymbols();
            SymbolSet reducesymbols = I.getReduceSymbols();
            int symbol = 0;
            while (symbol < this.tsymbols.getSymbolCount()) {
                reduceproductions = I.getReduceProductions(this.tsymbols.getSymbol(symbol));
                productionpriority = -1;
                highestproduction = -1;
                k = 0;
                while (k < reduceproductions.getCount()) {
                    ReduceReduceConflict reduceconflict = null;
                    if (k > 0) {
                        reduceconflict = new ReduceReduceConflict(grammar, this.itemsets, state, (Terminal)this.tsymbols.getSymbol(symbol), reduceproductions.get(k - 1), reduceproductions.get(k));
                        this.conflicts.addConflict(reduceconflict);
                    }
                    if (grammar.getPriority(grammar.getProduction(reduceproductions.get(k))) > productionpriority) {
                        highestproduction = reduceproductions.get(k);
                        productionpriority = grammar.getPriority(grammar.getProduction(highestproduction));
                        if (logger != null && reduceconflict != null) {
                            logger.info(reduceconflict.toString());
                        }
                    } else if (grammar.getPriority(grammar.getProduction(reduceproductions.get(k))) == productionpriority && logger != null) {
                        logger.warn(reduceconflict.toString());
                    }
                    ++k;
                }
                if (reduceproductions.getCount() > 1 && logger != null && logger.isInfoEnabled()) {
                    logger.info("The parser will reduce the production " + grammar.getProduction(highestproduction));
                }
                if (shiftsymbols.contains(this.tsymbols.getSymbol(symbol))) {
                    if (reducesymbols.contains(this.tsymbols.getSymbol(symbol))) {
                        int tokenpriority = grammar.getPriority((Terminal)this.tsymbols.getSymbol(symbol));
                        ShiftReduceConflict shiftconflict = new ShiftReduceConflict(grammar, this.itemsets, state, (Terminal)this.tsymbols.getSymbol(symbol), highestproduction);
                        if (tokenpriority > productionpriority) {
                            this.automaton.setShiftAction(state, symbol, I.getTransition(this.tsymbols.getSymbol(symbol)));
                            if (logger != null) {
                                logger.info(shiftconflict.toString());
                                logger.info("The parser will shift");
                            }
                        } else if (tokenpriority < productionpriority) {
                            this.automaton.setReduceAction(state, symbol, highestproduction);
                            if (logger != null) {
                                logger.info(shiftconflict.toString());
                                logger.info("The parser will reduce");
                            }
                        } else {
                            Associativity associativity;
                            if (logger != null) {
                                logger.warn(shiftconflict.toString());
                            }
                            if ((associativity = grammar.getAssociativity((Terminal)this.tsymbols.getSymbol(symbol))).equals(Associativity.RIGHT)) {
                                this.automaton.setShiftAction(state, symbol, I.getTransition(this.tsymbols.getSymbol(symbol)));
                                if (logger != null) {
                                    logger.warn("The parser will shift");
                                }
                            } else if (associativity.equals(Associativity.LEFT)) {
                                this.automaton.setReduceAction(state, symbol, highestproduction);
                                if (logger != null) {
                                    logger.warn("The parser will reduce");
                                }
                            } else {
                                this.automaton.setReduceAction(state, symbol, highestproduction);
                                if (logger != null) {
                                    logger.warn("The parser will reduce");
                                }
                                this.conflicts.addConflict(shiftconflict);
                            }
                        }
                    } else {
                        this.automaton.setShiftAction(state, symbol, I.getTransition(this.tsymbols.getSymbol(symbol)));
                    }
                } else if (reducesymbols.contains(this.tsymbols.getSymbol(symbol))) {
                    this.automaton.setReduceAction(state, symbol, highestproduction);
                }
                ++symbol;
            }
            if (reducesymbols.contains(EOF)) {
                reduceproductions = I.getReduceProductions(EOF);
                productionpriority = -1;
                highestproduction = -1;
                k = 0;
                while (k < reduceproductions.getCount()) {
                    if (grammar.getPriority(grammar.getProduction(reduceproductions.get(k))) > productionpriority) {
                        highestproduction = reduceproductions.get(k);
                        productionpriority = grammar.getPriority(grammar.getProduction(highestproduction));
                    }
                    ++k;
                }
                if (grammar.getProduction(highestproduction).getSymbol().equals(grammar.getStartSymbol())) {
                    this.automaton.setAcceptAction(state, highestproduction);
                } else {
                    this.automaton.setReduceAction(state, highestproduction);
                }
            }
            int symbol2 = 0;
            while (symbol2 < this.ntsymbols.getSymbolCount()) {
                if (shiftsymbols.contains(this.ntsymbols.getSymbol(symbol2))) {
                    this.automaton.setTransition(state, symbol2, I.getTransition(this.ntsymbols.getSymbol(symbol2)));
                }
                ++symbol2;
            }
            ++state;
        }
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug("Parser automaton:\n" + this.automaton.toString());
        }
    }

    public ParserAutomaton getParserAutomaton() {
        return this.automaton;
    }
}

