/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.pattern;

import java.util.Vector;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.pattern.CharacterClassElement;
import net.sourceforge.chaperon.model.pattern.Pattern;

public class CharacterClass
extends Pattern {
    private Vector childs = new Vector();
    private boolean exclusive = false;

    public void addCharacterClassElement(CharacterClassElement element) {
        if (element != null) {
            this.childs.addElement(element);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        CharacterClass clone = new CharacterClass();
        clone.setMinOccurs(this.getMinOccurs());
        clone.setMaxOccurs(this.getMaxOccurs());
        int i = 0;
        while (i < this.getCharacterClassElementCount()) {
            clone.addCharacterClassElement(this.getCharacterClassElement(i));
            ++i;
        }
        return clone;
    }

    public CharacterClassElement getCharacterClassElement(int index) {
        return (CharacterClassElement)this.childs.elementAt(index);
    }

    public int getCharacterClassElementCount() {
        return this.childs.size();
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (this.exclusive) {
            buffer.append("^");
        }
        int i = 0;
        while (i < this.getCharacterClassElementCount()) {
            buffer.append(this.getCharacterClassElement(i).toString());
            ++i;
        }
        buffer.append("]");
        if (this.getMinOccurs() != 1 || this.getMaxOccurs() != 1) {
            if (this.getMinOccurs() == 0 && this.getMaxOccurs() == 1) {
                buffer.append("?");
            } else if (this.getMinOccurs() == 0 && this.getMaxOccurs() == Integer.MAX_VALUE) {
                buffer.append("*");
            } else if (this.getMinOccurs() == 1 && this.getMaxOccurs() == Integer.MAX_VALUE) {
                buffer.append("+");
            } else {
                buffer.append("{");
                buffer.append(String.valueOf(this.getMinOccurs()));
                buffer.append(",");
                buffer.append(String.valueOf(this.getMaxOccurs()));
                buffer.append("}");
            }
        }
        return buffer.toString();
    }

    public Violations validate() {
        Violations violations = new Violations();
        if (this.getCharacterClassElementCount() < 1) {
            violations.addViolation("Character class doesn't contain 1 or more elements", this.getLocation());
        }
        return violations;
    }
}

