/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.process;

import java.io.Serializable;
import net.sourceforge.chaperon.common.Decoder;

public class PatternAutomaton
implements Serializable {
    public static final int TYPE_NOMATCH = 0;
    public static final int TYPE_MATCH = 1;
    public static final int TYPE_EXMATCH = 2;
    public static final int TYPE_MATCHANY = 3;
    public static final int TYPE_BOL = 4;
    public static final int TYPE_EOL = 5;
    public static final int TYPE_GROUPSTART = 6;
    public static final int TYPE_GROUPEND = 7;
    private int[] types = new int[0];
    private char[] intervalbegin = new char[0];
    private char[] intervalend = new char[0];
    private int[] groupindices = new int[0];
    private int[][] transitions = new int[0][0];
    private int statecount = 0;
    private int firststate = -1;
    private int finalstate = -1;
    private int groupcount = 0;
    private static final long serialVersionUID = 1246342009422283917L;
    private static final String spaces = "                                                                                              ";

    public PatternAutomaton(int statecount) {
        if (statecount <= 0) {
            throw new IllegalArgumentException("Count of states is invalid");
        }
        this.statecount = statecount;
        this.types = new int[statecount];
        this.intervalbegin = new char[statecount];
        this.intervalend = new char[statecount];
        this.groupindices = new int[statecount];
        this.transitions = new int[statecount][0];
        int state = 0;
        while (state < statecount) {
            this.types[state] = 0;
            this.intervalbegin[state] = '\u0000';
            this.intervalend[state] = '\u0000';
            this.groupindices[state] = 0;
            ++state;
        }
    }

    public void addTransition(int state, int nextstate) {
        int i = 0;
        while (i < this.transitions[state].length) {
            if (this.transitions[state][i] == nextstate) {
                return;
            }
            ++i;
        }
        int[] newtransitions = new int[this.transitions[state].length + 1];
        System.arraycopy(this.transitions[state], 0, newtransitions, 0, this.transitions[state].length);
        newtransitions[this.transitions[state].length] = nextstate;
        this.transitions[state] = newtransitions;
    }

    private String distance(int n) {
        String string = new String();
        int i = 0;
        while (i < n) {
            string = String.valueOf(string) + " ";
            ++i;
        }
        return string;
    }

    public int getFinalState() {
        return this.finalstate;
    }

    public int getFirstState() {
        return this.firststate;
    }

    public int getGroupCount() {
        return this.groupcount;
    }

    public int getGroupIndex(int state) {
        return this.groupindices[state];
    }

    public char getIntervalBegin(int state) {
        return this.intervalbegin[state];
    }

    public char getIntervalEnd(int state) {
        return this.intervalend[state];
    }

    public int getStateCount() {
        return this.statecount;
    }

    public int[] getTransitions(int state) {
        return this.transitions[state];
    }

    public int getType(int state) {
        return this.types[state];
    }

    public boolean isFinalState(int state) {
        return this.finalstate == state;
    }

    public void setFinalState(int finalstate) {
        if (finalstate < 0 || finalstate > this.statecount) {
            throw new IllegalArgumentException();
        }
        this.finalstate = finalstate;
    }

    public void setFirstState(int firststate) {
        if (firststate < 0 || firststate > this.statecount) {
            throw new IllegalArgumentException();
        }
        this.firststate = firststate;
    }

    public void setGroupCount(int groupcount) {
        this.groupcount = groupcount;
    }

    public void setGroupIndex(int state, int groupindex) {
        this.groupindices[state] = groupindex;
    }

    public void setInterval(int state, char begin, char end) {
        this.intervalbegin[state] = begin;
        this.intervalend[state] = end;
    }

    public void setTransitions(int state, int[] transitions) {
        this.transitions[state] = transitions;
    }

    public void setType(int state, int type) {
        if (type < 0 || type > 7) {
            throw new IndexOutOfBoundsException();
        }
        this.types[state] = type;
    }

    public String toString() {
        String dummy;
        String[] chars = new String[this.statecount];
        int i = 0;
        while (i < this.statecount) {
            switch (this.types[i]) {
                case 0: {
                    chars[i] = " ";
                    break;
                }
                case 1: {
                    if (this.intervalbegin[i] != this.intervalend[i]) {
                        chars[i] = "[" + Decoder.decode(String.valueOf(this.intervalbegin[i]) + "-" + this.intervalend[i]) + "]";
                        break;
                    }
                    chars[i] = "[" + Decoder.decode(String.valueOf(this.intervalbegin[i])) + "]";
                    break;
                }
                case 2: {
                    if (this.intervalbegin[i] != this.intervalend[i]) {
                        chars[i] = "[^" + Decoder.decode(String.valueOf(this.intervalbegin[i]) + "-" + this.intervalend[i]) + "]";
                        break;
                    }
                    chars[i] = "[^" + Decoder.decode(String.valueOf(this.intervalbegin[i])) + "]";
                    break;
                }
                case 3: {
                    chars[i] = ".";
                    break;
                }
                case 4: {
                    chars[i] = "^";
                    break;
                }
                case 5: {
                    chars[i] = "$";
                    break;
                }
                case 6: {
                    chars[i] = "([" + this.groupindices[i] + "]";
                    break;
                }
                case 7: {
                    chars[i] = ")[" + this.groupindices[i] + "]";
                    break;
                }
            }
            ++i;
        }
        StringBuffer buffer = new StringBuffer();
        i = 0;
        while (i < this.statecount) {
            dummy = String.valueOf(i);
            buffer.append(" ");
            buffer.append(dummy);
            buffer.append(spaces.substring(0, Math.max(0, chars[i].length() - dummy.length() + 1)));
            ++i;
        }
        buffer.append("\n");
        i = 0;
        while (i < this.statecount) {
            buffer.append(" ");
            buffer.append(String.valueOf(chars[i]));
            buffer.append(" ");
            ++i;
        }
        buffer.append("\n");
        int maxtransitions = 0;
        i = 0;
        while (i < this.statecount) {
            maxtransitions = Math.max(maxtransitions, this.transitions[i].length);
            ++i;
        }
        int j = 0;
        while (j < maxtransitions) {
            i = 0;
            while (i < this.statecount) {
                if (j < this.transitions[i].length) {
                    dummy = String.valueOf(this.transitions[i][j]);
                    buffer.append(" ");
                    buffer.append(dummy);
                    buffer.append(spaces.substring(0, Math.max(0, chars[i].length() - dummy.length() + 1)));
                } else {
                    buffer.append(" ");
                    buffer.append(spaces.substring(0, Math.max(0, chars[i].length() + 1)));
                }
                ++i;
            }
            buffer.append("\n");
            ++j;
        }
        buffer.append("First state = ");
        buffer.append(String.valueOf(this.firststate));
        buffer.append("\n");
        buffer.append("Final state = ");
        buffer.append(String.valueOf(this.finalstate));
        buffer.append("\n");
        buffer.append("State count = ");
        buffer.append(String.valueOf(this.statecount));
        buffer.append("\n");
        buffer.append("Group count = ");
        buffer.append(String.valueOf(this.groupcount));
        return buffer.toString();
    }
}

