/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.AbstractSource;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;

public class URLSource
extends AbstractSource
implements Source {
    protected URL m_url;
    protected URLConnection m_connection;
    protected SourceParameters m_parameters;
    protected boolean m_isPost = false;
    protected boolean m_exists = false;
    protected SourceValidity m_cachedValidity;
    protected long m_cachedLastModificationDate;
    protected String m_mimeType;

    public void init(URL url, Map parameters) throws IOException {
        String systemId = url.toExternalForm();
        this.setSystemId(systemId);
        this.setScheme(SourceUtil.getScheme(systemId));
        this.m_url = url;
        this.m_isPost = false;
        if (null != parameters) {
            this.m_parameters = (SourceParameters)parameters.get("org.apache.excalibur.source.Source.uri.parameters");
            String method = (String)parameters.get("org.apache.avalon.excalibur.source.Source.uri.method");
            if ("POST".equalsIgnoreCase(method)) {
                this.m_isPost = true;
            }
        }
        if (null != this.m_parameters && this.m_parameters.hasParameters() && !this.m_isPost) {
            boolean first;
            StringBuffer urlBuffer = new StringBuffer(systemId);
            Iterator i = this.m_parameters.getParameterNames();
            boolean bl = first = systemId.indexOf(63) == -1;
            if (first) {
                urlBuffer.append('?');
            }
            while (i.hasNext()) {
                String key = (String)i.next();
                Iterator values = this.m_parameters.getParameterValues(key);
                while (values.hasNext()) {
                    String value = SourceUtil.encode((String)values.next());
                    if (!first) {
                        urlBuffer.append('&');
                    }
                    first = false;
                    urlBuffer.append(key);
                    urlBuffer.append('=');
                    urlBuffer.append(value);
                }
            }
            this.m_url = new URL(urlBuffer.toString());
            this.m_parameters = null;
        }
    }

    protected void getInfos() {
        this.m_exists = false;
        if (!this.m_isPost) {
            try {
                if (null == this.m_connection) {
                    this.m_connection = this.m_url.openConnection();
                    String userInfo = this.m_url.getUserInfo();
                    if (this.m_url.getProtocol().startsWith("http") && userInfo != null) {
                        this.m_connection.setRequestProperty("Authorization", "Basic " + SourceUtil.encodeBASE64(userInfo));
                    }
                }
                this.setLastModified(this.m_connection.getLastModified());
                this.setContentLength(this.m_connection.getContentLength());
                this.m_mimeType = this.m_connection.getContentType();
                this.m_exists = true;
            }
            catch (IOException ignore) {
                super.getInfos();
            }
        } else {
            super.getInfos();
        }
    }

    public boolean exists() {
        this.checkInfos();
        return this.m_exists;
    }

    public InputStream getInputStream() throws IOException, SourceException {
        this.checkInfos();
        InputStream input = null;
        if (this.m_connection == null) {
            this.m_connection = this.m_url.openConnection();
            String userInfo = this.m_url.getUserInfo();
            if (this.m_url.getProtocol().startsWith("http") && userInfo != null) {
                this.m_connection.setRequestProperty("Authorization", "Basic " + SourceUtil.encodeBASE64(userInfo));
            }
            if (this.m_connection instanceof HttpURLConnection && this.m_isPost) {
                StringBuffer buffer = new StringBuffer(2000);
                Iterator i = this.m_parameters.getParameterNames();
                boolean first = true;
                while (i.hasNext()) {
                    String key = (String)i.next();
                    Iterator values = this.m_parameters.getParameterValues(key);
                    while (values.hasNext()) {
                        String value = SourceUtil.encode((String)values.next());
                        if (!first) {
                            buffer.append('&');
                        }
                        first = false;
                        buffer.append(key.toString());
                        buffer.append('=');
                        buffer.append(value);
                    }
                }
                HttpURLConnection httpCon = (HttpURLConnection)this.m_connection;
                httpCon.setDoInput(true);
                if (buffer.length() > 1) {
                    String postString = buffer.toString();
                    httpCon.setRequestMethod("POST");
                    httpCon.setDoOutput(true);
                    httpCon.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                    httpCon.setRequestProperty("Content-length", Integer.toString(postString.length()));
                    BufferedOutputStream out = new BufferedOutputStream(httpCon.getOutputStream());
                    ((OutputStream)out).write(postString.getBytes());
                    ((OutputStream)out).close();
                }
                input = httpCon.getInputStream();
                this.m_connection = null;
                return input;
            }
        }
        input = this.m_connection.getInputStream();
        this.m_connection = null;
        return input;
    }

    public SourceValidity getValidity() {
        long lm = this.getLastModified();
        if (lm > 0L) {
            if (lm == this.m_cachedLastModificationDate) {
                return this.m_cachedValidity;
            }
            this.m_cachedLastModificationDate = lm;
            this.m_cachedValidity = new TimeStampValidity(lm);
            return this.m_cachedValidity;
        }
        return null;
    }

    public void refresh() {
        this.m_connection = null;
        super.refresh();
    }

    public String getMimeType() {
        return this.m_mimeType;
    }
}

