/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl.validity;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.AbstractAggregatedValidity;
import org.apache.excalibur.source.impl.validity.DeferredValidity;

public final class DeferredAggregatedValidity
extends AbstractAggregatedValidity
implements SourceValidity {
    public void add(DeferredValidity validity) {
        this.m_list.add(validity);
    }

    public int isValid() {
        ListIterator<SourceValidity> i = this.m_list.listIterator();
        while (i.hasNext()) {
            SourceValidity validity;
            Object o = i.next();
            if (o instanceof SourceValidity) {
                validity = (SourceValidity)o;
            } else {
                validity = ((DeferredValidity)o).getValidity();
                i.set(validity);
            }
            int v = validity.isValid();
            if (v >= 1) continue;
            return v;
        }
        return 1;
    }

    public int isValid(SourceValidity validity) {
        AbstractAggregatedValidity aggregatedValidity = null;
        if (validity instanceof AbstractAggregatedValidity) {
            aggregatedValidity = (AbstractAggregatedValidity)validity;
        }
        if (null != aggregatedValidity) {
            ArrayList otherList = aggregatedValidity.m_list;
            if (this.m_list.size() != otherList.size()) {
                return -1;
            }
            int i = 0;
            while (i < this.m_list.size()) {
                SourceValidity srcB;
                SourceValidity srcA = this.getValidity(i);
                int result = srcA.isValid();
                if (result == -1) {
                    return -1;
                }
                if (result == 0 && (result = srcA.isValid(srcB = aggregatedValidity.getValidity(i))) < 1) {
                    return result;
                }
                ++i;
            }
            return 1;
        }
        return -1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SourceValidity ");
        Iterator i = this.m_list.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(':');
        }
        return sb.toString();
    }

    SourceValidity getValidity(int index) {
        SourceValidity validity;
        Object o = this.m_list.get(index);
        if (o instanceof SourceValidity) {
            validity = (SourceValidity)o;
        } else {
            validity = ((DeferredValidity)o).getValidity();
            this.m_list.set(index, validity);
        }
        return validity;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int i = 0;
        while (i < this.m_list.size()) {
            this.getValidity(i);
            ++i;
        }
        out.defaultWriteObject();
    }
}

