/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.profiler;

import org.apache.cocoon.components.profiler.EnvironmentInfo;
import org.apache.cocoon.components.profiler.ProfilerData;

public class ProfilerResult {
    private String uri;
    private String[] roles;
    private String[] sources;
    private int count = 0;
    private EnvironmentInfo[] latestEnvironmentInfo;
    private long[] totalTime;
    private long[][] latestSetupTimes;
    private long[][] latestProcessingTimes;
    private Object[][] latestFragments;

    public ProfilerResult(String uri, int latestResultsCount) {
        this.uri = uri;
        this.latestEnvironmentInfo = new EnvironmentInfo[latestResultsCount > 0 ? latestResultsCount : 5];
        this.latestSetupTimes = new long[latestResultsCount > 0 ? latestResultsCount : 5][];
        this.latestProcessingTimes = new long[latestResultsCount > 0 ? latestResultsCount : 5][];
        this.totalTime = new long[latestResultsCount > 0 ? latestResultsCount : 5];
        this.latestFragments = new Object[latestResultsCount > 0 ? latestResultsCount : 5][];
        this.count = 0;
    }

    public void addData(ProfilerData data) {
        ProfilerData.Entry[] entries = data.getEntries();
        ProfilerResult profilerResult = this;
        synchronized (profilerResult) {
            int i;
            if (this.roles == null || this.roles.length != entries.length) {
                this.roles = new String[entries.length];
                this.sources = new String[entries.length];
                i = 0;
                while (i < entries.length) {
                    this.roles[i] = entries[i].role;
                    this.sources[i] = entries[i].source;
                    ++i;
                }
                this.count = 0;
            }
            if (this.latestProcessingTimes != null) {
                i = this.latestProcessingTimes.length - 1;
                while (i > 0) {
                    this.latestEnvironmentInfo[i] = this.latestEnvironmentInfo[i - 1];
                    this.totalTime[i] = this.totalTime[i - 1];
                    this.latestSetupTimes[i] = this.latestSetupTimes[i - 1];
                    this.latestProcessingTimes[i] = this.latestProcessingTimes[i - 1];
                    this.latestFragments[i] = this.latestFragments[i - 1];
                    --i;
                }
                this.latestEnvironmentInfo[0] = data.getEnvironmentInfo();
                this.totalTime[0] = data.getTotalTime();
                this.latestSetupTimes[0] = new long[entries.length];
                int i2 = 0;
                while (i2 < entries.length) {
                    this.latestSetupTimes[0][i2] = entries[i2].setup;
                    ++i2;
                }
                this.latestProcessingTimes[0] = new long[entries.length];
                int i3 = 0;
                while (i3 < entries.length) {
                    this.latestProcessingTimes[0][i3] = entries[i3].time;
                    ++i3;
                }
                this.latestFragments[0] = new Object[entries.length];
                int i4 = 0;
                while (i4 < entries.length) {
                    this.latestFragments[0][i4] = entries[i4].fragment;
                    ++i4;
                }
                if (this.count < this.latestProcessingTimes.length) {
                    ++this.count;
                }
            }
        }
    }

    public String getURI() {
        return this.uri;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public String[] getSources() {
        return this.sources;
    }

    public int getCount() {
        return this.count;
    }

    public EnvironmentInfo[] getLatestEnvironmentInfos() {
        return this.latestEnvironmentInfo;
    }

    public long[] getTotalTime() {
        return this.totalTime;
    }

    public long[][] getSetupTimes() {
        return this.latestSetupTimes;
    }

    public long[][] getProcessingTimes() {
        return this.latestProcessingTimes;
    }

    public Object[][] getSAXFragments() {
        return this.latestFragments;
    }
}

