/*
 * Decompiled with CFR 0.152.
 */
package org.ccil.cowan.tagsoup;

import org.ccil.cowan.tagsoup.AttributesImpl;
import org.ccil.cowan.tagsoup.Schema;

public class ElementType {
    private String theName;
    private String theNamespace;
    private String theLocalName;
    private int theModel;
    private int theMemberOf;
    private int theFlags;
    private AttributesImpl theAtts;
    private ElementType theParent;
    private Schema theSchema;

    public ElementType(String string, int n, int n2, int n3, Schema schema) {
        this.theName = string;
        this.theModel = n;
        if (n2 == -1) {
            n2 &= Integer.MAX_VALUE;
        }
        this.theMemberOf = n2;
        this.theFlags = n3;
        this.theAtts = new AttributesImpl();
        this.theSchema = schema;
        this.theNamespace = this.namespace(string, false);
        this.theLocalName = this.localName(string);
    }

    public String namespace(String string, boolean bl) {
        int n = string.indexOf(58);
        if (n == -1) {
            if (bl) {
                return "";
            }
            return this.theSchema.getURI();
        }
        String string2 = string.substring(0, n);
        if (string2.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return ("urn:x-prefix:" + string2).intern();
    }

    public String localName(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1).intern();
    }

    public String name() {
        return this.theName;
    }

    public String namespace() {
        return this.theNamespace;
    }

    public String localName() {
        return this.theLocalName;
    }

    public int model() {
        return this.theModel;
    }

    public int memberOf() {
        return this.theMemberOf;
    }

    public int flags() {
        return this.theFlags;
    }

    public AttributesImpl atts() {
        return this.theAtts;
    }

    public ElementType parent() {
        return this.theParent;
    }

    public Schema schema() {
        return this.theSchema;
    }

    public boolean canContain(ElementType elementType) {
        return (this.theModel & elementType.theMemberOf) != 0;
    }

    public void setAttribute(AttributesImpl attributesImpl, String string, String string2, String string3) {
        if (string.equals("xmlns") || string.startsWith("xmlns:")) {
            return;
        }
        String string4 = this.namespace(string, true);
        String string5 = this.localName(string);
        int n = attributesImpl.getIndex(string);
        if (n == -1) {
            string = string.intern();
            if (string2 == null) {
                string2 = "CDATA";
            }
            if (!string2.equals("CDATA")) {
                string3 = ElementType.normalize(string3);
            }
            attributesImpl.addAttribute(string4, string5, string, string2, string3);
        } else {
            if (string2 == null) {
                string2 = attributesImpl.getType(n);
            }
            if (!string2.equals("CDATA")) {
                string3 = ElementType.normalize(string3);
            }
            attributesImpl.setAttribute(n, string4, string5, string, string2, string3);
        }
    }

    public static String normalize(String string) {
        if (string == null) {
            return string;
        }
        if ((string = string.trim()).indexOf("  ") == -1) {
            return string;
        }
        boolean bl = false;
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (!bl) {
                    stringBuffer.append(c);
                }
                bl = true;
                continue;
            }
            stringBuffer.append(c);
            bl = false;
        }
        return stringBuffer.toString();
    }

    public void setAttribute(String string, String string2, String string3) {
        this.setAttribute(this.theAtts, string, string2, string3);
    }

    public void setModel(int n) {
        this.theModel = n;
    }

    public void setMemberOf(int n) {
        this.theMemberOf = n;
    }

    public void setFlags(int n) {
        this.theFlags = n;
    }

    public void setParent(ElementType elementType) {
        this.theParent = elementType;
    }
}

