/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MQAddress;
import com.sun.messaging.jms.JMSException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Iterator;
import java.util.Map;

public class PortMapperClient {
    protected ConnectionImpl connection = null;
    protected PortMapperTable portMapperTable = null;
    protected boolean useMQAddress = false;
    protected MQAddress addr = null;
    private static final Version version = ConnectionImpl.version;
    private boolean debug = Debug.debug;

    public PortMapperClient(ConnectionImpl connectionImpl) throws javax.jms.JMSException {
        this.connection = connectionImpl;
        this.init();
    }

    public PortMapperClient(MQAddress mQAddress, ConnectionImpl connectionImpl) throws javax.jms.JMSException {
        this.addr = mQAddress;
        this.useMQAddress = true;
        this.connection = connectionImpl;
        this.init();
    }

    public int getPortForProtocol(String string) {
        String string2 = this.connection.getConnectionType();
        return this.getPort(string, string2, null);
    }

    public int getPortForService(String string, String string2) throws javax.jms.JMSException {
        String string3 = this.connection.getConnectionType();
        int n = this.getPort(string, string3, string2);
        if (n == -1) {
            String string4 = AdministeredObject.cr.getKString("C4098", string2);
            JMSException jMSException = new JMSException(string4, "C4098");
            ExceptionHandler.throwJMSException(jMSException);
        }
        return n;
    }

    private int getPort(String string, String string2, String string3) {
        int n = -1;
        Map map = this.portMapperTable.getServices();
        PortMapperEntry portMapperEntry = null;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            portMapperEntry = (PortMapperEntry)iterator.next();
            if (!portMapperEntry.getProtocol().equals(string) || !portMapperEntry.getType().equals(string2)) continue;
            if (string3 == null) {
                n = portMapperEntry.getPort();
                break;
            }
            if (!portMapperEntry.getName().equals(string3)) continue;
            n = portMapperEntry.getPort();
            break;
        }
        return n;
    }

    protected void init() throws javax.jms.JMSException {
        try {
            this.readBrokerPorts();
            this.checkBrokerVersion();
        }
        catch (javax.jms.JMSException jMSException) {
            String string = this.getHostName() + ":" + this.getHostPort();
            this.connection.setLastContactedBrokerAddress(string);
            ExceptionHandler.throwJMSException(jMSException);
        }
    }

    protected void checkBrokerVersion() throws javax.jms.JMSException {
        String string = this.portMapperTable.getBrokerVersion();
        String string2 = version.getImplementationVersion();
        if (Version.compareVersions(string, "3.0") < 0) {
            String string3 = AdministeredObject.cr.getKString("C4065", string2, string);
            JMSException jMSException = new JMSException(string3, "C4065");
            ExceptionHandler.throwJMSException(jMSException);
        }
        if (Version.compareVersions(string, "3.0.1", false) < 0) {
            ReadOnlyPacket.setDefaultVersion((short)200);
        }
    }

    private String getHostName() {
        if (this.useMQAddress) {
            return this.addr.getHostName();
        }
        return this.connection.getProperty("imqBrokerHostName");
    }

    public int getHostPort() {
        if (this.useMQAddress) {
            return this.addr.getPort();
        }
        String string = this.connection.getProperty("imqBrokerHostPort");
        return Integer.parseInt(string);
    }

    protected void readBrokerPorts() throws javax.jms.JMSException {
        String string = this.getHostName();
        int n = this.getHostPort();
        if (this.debug) {
            Debug.println("PortMapper connecting to host: " + string + "  port: " + n);
        }
        try {
            String string2 = String.valueOf(101) + "\n";
            Socket socket = new Socket(string, n);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            try {
                outputStream.write(string2.getBytes());
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.portMapperTable = new PortMapperTable();
            this.portMapperTable.read(inputStream);
            inputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            this.connection.getExceptionHandler();
            ExceptionHandler.handleConnectException(exception, string, n);
        }
    }

    public static void main(String[] stringArray) {
        try {
            PortMapperClient portMapperClient = new PortMapperClient(null);
            String string = "tcp";
            String string2 = System.getProperty("protocol");
            if (string2 != null) {
                string = string2;
            }
            int n = portMapperClient.getPortForProtocol(string);
            if (Debug.debug) {
                Debug.println("port = " + n);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
        }
    }
}

