/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.codegen;

import com.sun.corba.ee.impl.codegen.ASMUtil;
import com.sun.corba.ee.impl.codegen.Attribute;
import com.sun.corba.ee.impl.codegen.ClassGenerator;
import com.sun.corba.ee.impl.codegen.ClassInfo;
import com.sun.corba.ee.impl.codegen.EmitterFactory;
import com.sun.corba.ee.impl.codegen.Field;
import com.sun.corba.ee.impl.codegen.MethodGenerator;
import com.sun.corba.ee.impl.codegen.MethodInfo;
import com.sun.corba.ee.impl.codegen.MyLabel;
import com.sun.corba.ee.impl.codegen.Node;
import com.sun.corba.ee.impl.codegen.Variable;
import com.sun.corba.ee.org.objectweb.asm.ClassWriter;
import com.sun.corba.ee.org.objectweb.asm.Label;
import com.sun.corba.ee.org.objectweb.asm.MethodVisitor;
import com.sun.corba.ee.org.objectweb.asm.util.TraceMethodVisitor;
import com.sun.corba.ee.spi.codegen.Signature;
import com.sun.corba.ee.spi.codegen.Type;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByteCodeUtility {
    private ClassWriter cw;
    private MethodVisitor mv;
    private boolean debug;
    private String methodName;
    private String methodSignature;

    public ByteCodeUtility(ClassWriter cw, ClassGenerator cg, boolean debug) {
        this.cw = cw;
        this.mv = null;
        this.debug = debug;
        String[] interfaces = new String[cg.impls().size()];
        int ctr = 0;
        for (Type impl : cg.impls()) {
            interfaces[ctr++] = ASMUtil.bcName(impl);
        }
        int modifiers = cg.modifiers();
        if (cg.isInterface()) {
            modifiers += 512;
        }
        String superType = cg.superType() == null ? ASMUtil.bcName(Type._Object()) : ASMUtil.bcName(cg.superType());
        cw.visit(49, cg.modifiers(), ASMUtil.bcName(cg.thisType()), null, superType, interfaces);
        cw.visitSource(cg.name() + ".java", null);
    }

    public void addField(Field arg) {
        String descriptor = ASMUtil.bcSignature(arg.type());
        this.cw.visitField(arg.modifiers(), arg.ident(), descriptor, null, null);
    }

    public ByteCodeUtility(ClassWriter cw, ClassGenerator cg) {
        this(cw, cg, false);
    }

    private void dump() {
        if (this.debug) {
            List data = ((TraceMethodVisitor)TraceMethodVisitor.class.cast(this.mv)).getText();
            System.out.printf("MethodVisitor calls for method %s%s\n", this.methodName, this.methodSignature);
            for (String str : data) {
                System.out.print(str);
            }
        }
    }

    public void emitMethodStart(MethodGenerator mg) {
        ArrayList<Type> types = new ArrayList<Type>();
        for (Variable var : mg.arguments()) {
            types.add(var.type());
        }
        this.methodName = mg.name();
        this.methodSignature = ASMUtil.bcSignature(Signature.make(mg.returnType(), types));
        String[] strs = new String[mg.exceptions().size()];
        int ctr = 0;
        for (Type exception : mg.exceptions()) {
            strs[ctr++] = ASMUtil.bcName(exception);
        }
        this.mv = this.cw.visitMethod(mg.modifiers(), this.methodName, this.methodSignature, null, strs);
        if (this.debug) {
            this.mv = new TraceMethodVisitor(this.mv);
        }
        this.mv.visitCode();
    }

    public void emitMethodEnd(MethodGenerator mg, Label returnLabel, Variable returnVariable, boolean dump) {
        if ((mg.modifiers() & 0x400) == 0) {
            this.mv.visitLabel(returnLabel);
            if (returnVariable != null) {
                EmitterFactory.Emitter emitter = ASMUtil.getEmitter.get(returnVariable);
                assert (emitter != null);
                emitter.evaluate(this.mv);
            }
            this.emitReturn(returnVariable == null ? Type._void() : returnVariable.type());
        }
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
        if (dump) {
            this.dump();
        }
        this.mv = null;
    }

    private void emitReturn(Type returnType) {
        if (returnType.equals(Type._void())) {
            this.mv.visitInsn(177);
        } else if (returnType.isPrimitive()) {
            if (returnType.equals(Type._long())) {
                this.mv.visitInsn(173);
            } else if (returnType.equals(Type._float())) {
                this.mv.visitInsn(174);
            } else if (returnType.equals(Type._double())) {
                this.mv.visitInsn(175);
            } else {
                this.mv.visitInsn(172);
            }
        } else {
            this.mv.visitInsn(176);
        }
    }

    public void emitRet(Variable var) {
        assert (var.type().equals(Type._Object()));
        Integer slot = ASMUtil.stackFrameSlot.get(var);
        assert (slot != null);
        this.mv.visitVarInsn(169, slot);
    }

    public void emitConstantExpression(Type type, Object value) {
        if (type.equals(Type._null())) {
            this.mv.visitInsn(1);
        } else if (type.equals(Type._Class())) {
            Type vtype = (Type)Type.class.cast(value);
            com.sun.corba.ee.org.objectweb.asm.Type atype = com.sun.corba.ee.org.objectweb.asm.Type.getType(ASMUtil.bcSignature(vtype));
            this.mv.visitLdcInsn(atype);
        } else if (type.equals(Type._String())) {
            this.mv.visitLdcInsn(value);
        } else if (type.equals(Type._float())) {
            float val = ((Float)Float.class.cast(value)).floatValue();
            if ((double)val == 0.0) {
                this.mv.visitInsn(11);
            } else if ((double)val == 1.0) {
                this.mv.visitInsn(12);
            } else if ((double)val == 2.0) {
                this.mv.visitInsn(13);
            } else {
                this.mv.visitLdcInsn(value);
            }
        } else if (type.equals(Type._double())) {
            double val = (Double)Double.class.cast(value);
            if (val == 0.0) {
                this.mv.visitInsn(14);
            } else if (val == 1.0) {
                this.mv.visitInsn(15);
            } else {
                this.mv.visitLdcInsn(value);
            }
        } else if (type.equals(Type._long())) {
            long val = (Long)Long.class.cast(value);
            if (val == 0L) {
                this.mv.visitInsn(9);
            } else if (val == 1L) {
                this.mv.visitInsn(10);
            } else {
                this.mv.visitLdcInsn(value);
            }
        } else if (type.equals(Type._boolean())) {
            this.mv.visitInsn((Boolean)Boolean.class.cast(value) != false ? 4 : 3);
        } else {
            int val = (Integer)Integer.class.cast(value);
            if (val == -1) {
                this.mv.visitInsn(2);
            } else if (val == 0) {
                this.mv.visitInsn(3);
            } else if (val == 1) {
                this.mv.visitInsn(4);
            } else if (val == 2) {
                this.mv.visitInsn(5);
            } else if (val == 3) {
                this.mv.visitInsn(6);
            } else if (val == 4) {
                this.mv.visitInsn(7);
            } else if (val == 5) {
                this.mv.visitInsn(8);
            } else if (val > 5 && val < 256) {
                this.mv.visitIntInsn(16, val);
            } else if (val >= 256 && val < 65536) {
                this.mv.visitIntInsn(17, val);
            } else {
                this.mv.visitLdcInsn(value);
            }
        }
    }

    public void emitThisExpression() {
        this.mv.visitIntInsn(25, 0);
    }

    public void emitConditionalBranch(MyLabel falseBranch) {
        this.mv.visitJumpInsn(153, falseBranch);
    }

    public void emitBranch(MyLabel target) {
        this.mv.visitJumpInsn(167, target);
    }

    public void emitLabel(Attribute<MyLabel> attr, Node node) {
        if (attr.isSet(node)) {
            MyLabel label = attr.get(node);
            if (label.emitted()) {
                if (this.debug) {
                    ((TraceMethodVisitor)TraceMethodVisitor.class.cast(this.mv)).getText().add("    Already emitted label " + label);
                }
            } else {
                label.emitted(true);
                this.mv.visitLabel(label);
            }
        }
    }

    public void emitNewCall(Type type) {
        String typeName = ASMUtil.bcName(type);
        this.mv.visitTypeInsn(187, typeName);
        this.mv.visitInsn(89);
    }

    public void emitDup() {
        this.mv.visitInsn(89);
    }

    public void emitArrayStore() {
        this.mv.visitInsn(83);
    }

    public int typeCode(Type type) {
        if (type.equals(Type._boolean())) {
            return 4;
        }
        if (type.equals(Type._byte())) {
            return 8;
        }
        if (type.equals(Type._char())) {
            return 5;
        }
        if (type.equals(Type._short())) {
            return 9;
        }
        if (type.equals(Type._int())) {
            return 10;
        }
        if (type.equals(Type._long())) {
            return 11;
        }
        if (type.equals(Type._float())) {
            return 6;
        }
        if (type.equals(Type._double())) {
            return 7;
        }
        throw new IllegalArgumentException("Can only get a NEWARRAY typecode for a primitive type");
    }

    public void emitNewArrayCall(Type type) {
        String typeName = ASMUtil.bcName(type);
        if (type.isPrimitive()) {
            this.mv.visitIntInsn(188, this.typeCode(type));
        } else {
            this.mv.visitTypeInsn(189, typeName);
        }
    }

    public void emitStaticInvoke(Type type, String name, Signature sig) {
        String typeName = ASMUtil.bcName(type);
        this.mv.visitMethodInsn(184, typeName, name, ASMUtil.bcSignature(sig));
    }

    public void emitInvoke(Type type, String name, Signature sig) {
        ClassInfo targetInfo;
        String sigString = ASMUtil.bcSignature(sig);
        try {
            targetInfo = type.classInfo();
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        MethodInfo minfo = targetInfo.findMethodInfo(name, sig);
        if (minfo == null) {
            throw new IllegalArgumentException("Could not find a method " + name + " with signature " + sig + " in class " + targetInfo.name());
        }
        ClassInfo mcinfo = minfo.myClassInfo();
        boolean privateMethod = Modifier.isPrivate(minfo.modifiers());
        int opcode = mcinfo.isInterface() ? 185 : (privateMethod ? 183 : 182);
        String typeName = ASMUtil.bcName(mcinfo.thisType());
        this.mv.visitMethodInsn(opcode, typeName, name, sigString);
    }

    public void emitNewInvoke(Type type, Signature sig) {
        String typeName = ASMUtil.bcName(type);
        this.mv.visitMethodInsn(183, typeName, "<init>", ASMUtil.bcSignature(sig));
    }

    public void emitSpecialInvoke(Type type, String name, Signature sig) {
        String typeName = ASMUtil.bcName(type);
        this.mv.visitMethodInsn(183, typeName, name, ASMUtil.bcSignature(sig));
    }

    public void emitThrow() {
        this.mv.visitInsn(191);
    }

    public void emitExceptionTableEntry(Label start, Label end, Label handler, Type exceptionType) {
        String exceptionTypeName = exceptionType == null ? null : ASMUtil.bcName(exceptionType);
        this.mv.visitTryCatchBlock(start, end, handler, exceptionTypeName);
    }

    public void emitJsr(Label label) {
        this.mv.visitJumpInsn(168, label);
    }

    public void callEmitter(EmitterFactory.Emitter emitter) {
        emitter.evaluate(this.mv);
    }

    public void emitPop() {
        this.mv.visitInsn(87);
    }
}

