/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil;

import com.sun.corba.ee.impl.io.ObjectStreamClass;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;

public final class ObjectStreamClassUtil_1_3 {
    private static Comparator compareClassByName = new CompareClassByName();
    private static Comparator compareMemberByName = new CompareMemberByName();
    private static Method hasStaticInitializerMethod = null;

    public static long computeSerialVersionUID(Class cl) {
        long csuid = ObjectStreamClass.getSerialVersionUID(cl);
        if (csuid == 0L) {
            return csuid;
        }
        csuid = ObjectStreamClassUtil_1_3.getSerialVersion(csuid, cl);
        return csuid;
    }

    private static Long getSerialVersion(final long csuid, final Class cl) {
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                long suid;
                try {
                    Field f = cl.getDeclaredField("serialVersionUID");
                    int mods = f.getModifiers();
                    suid = Modifier.isStatic(mods) && Modifier.isFinal(mods) && Modifier.isPrivate(mods) ? csuid : ObjectStreamClassUtil_1_3._computeSerialVersionUID(cl);
                }
                catch (NoSuchFieldException ex) {
                    suid = ObjectStreamClassUtil_1_3._computeSerialVersionUID(cl);
                }
                return new Long(suid);
            }
        });
    }

    public static long computeStructuralUID(boolean hasWriteObject, Class cl) {
        ByteArrayOutputStream devnull = new ByteArrayOutputStream(512);
        long h = 0L;
        try {
            int minimum;
            if (!Serializable.class.isAssignableFrom(cl) || cl.isInterface()) {
                return 0L;
            }
            if (Externalizable.class.isAssignableFrom(cl)) {
                return 1L;
            }
            MessageDigest md = MessageDigest.getInstance("SHA");
            DigestOutputStream mdo = new DigestOutputStream(devnull, md);
            DataOutputStream data = new DataOutputStream(mdo);
            Class parent = cl.getSuperclass();
            if (parent != null && parent != Object.class) {
                boolean hasWriteObjectFlag = false;
                Method hasWriteObjectMethod = ObjectStreamClassUtil_1_3.getDeclaredMethod(parent, "writeObject", 2, 8, ObjectOutputStream.class);
                if (hasWriteObjectMethod != null) {
                    hasWriteObjectFlag = true;
                }
                data.writeLong(ObjectStreamClassUtil_1_3.computeStructuralUID(hasWriteObjectFlag, parent));
            }
            if (hasWriteObject) {
                data.writeInt(2);
            } else {
                data.writeInt(1);
            }
            Field[] field = ObjectStreamClassUtil_1_3.getDeclaredFields(cl);
            Arrays.sort(field, compareMemberByName);
            for (int i = 0; i < field.length; ++i) {
                Field f = field[i];
                int m = f.getModifiers();
                if (Modifier.isTransient(m) || Modifier.isStatic(m)) continue;
                data.writeUTF(f.getName());
                data.writeUTF(ObjectStreamClassUtil_1_3.getSignature(f.getType()));
            }
            data.flush();
            byte[] hasharray = md.digest();
            for (int i = minimum = Math.min(8, hasharray.length); i > 0; --i) {
                h += (long)(hasharray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException ignore) {
            h = -1L;
        }
        catch (NoSuchAlgorithmException complain) {
            throw new SecurityException(complain.getMessage());
        }
        return h;
    }

    private static long _computeSerialVersionUID(Class cl) {
        ByteArrayOutputStream devnull = new ByteArrayOutputStream(512);
        long h = 0L;
        try {
            String desc;
            int i;
            MessageDigest md = MessageDigest.getInstance("SHA");
            DigestOutputStream mdo = new DigestOutputStream(devnull, md);
            DataOutputStream data = new DataOutputStream(mdo);
            data.writeUTF(cl.getName());
            int classaccess = cl.getModifiers();
            Member[] method = cl.getDeclaredMethods();
            if (((classaccess &= 0x611) & 0x200) != 0) {
                classaccess &= 0xFFFFFBFF;
                if (method.length > 0) {
                    classaccess |= 0x400;
                }
            }
            data.writeInt(classaccess);
            if (!cl.isArray()) {
                Class<?>[] interfaces = cl.getInterfaces();
                Arrays.sort(interfaces, compareClassByName);
                for (i = 0; i < interfaces.length; ++i) {
                    data.writeUTF(interfaces[i].getName());
                }
            }
            Field[] field = cl.getDeclaredFields();
            Arrays.sort(field, compareMemberByName);
            for (i = 0; i < field.length; ++i) {
                Field f = field[i];
                int m = f.getModifiers();
                if (Modifier.isPrivate(m) && (Modifier.isTransient(m) || Modifier.isStatic(m))) continue;
                data.writeUTF(f.getName());
                data.writeInt(m);
                data.writeUTF(ObjectStreamClassUtil_1_3.getSignature(f.getType()));
            }
            if (ObjectStreamClassUtil_1_3.hasStaticInitializer(cl)) {
                data.writeUTF("<clinit>");
                data.writeInt(8);
                data.writeUTF("()V");
            }
            MethodSignature[] constructors = MethodSignature.removePrivateAndSort(cl.getDeclaredConstructors());
            for (int i2 = 0; i2 < constructors.length; ++i2) {
                MethodSignature c = constructors[i2];
                String mname = "<init>";
                desc = c.signature;
                desc = desc.replace('/', '.');
                data.writeUTF(mname);
                data.writeInt(c.member.getModifiers());
                data.writeUTF(desc);
            }
            MethodSignature[] methods = MethodSignature.removePrivateAndSort(method);
            for (int i3 = 0; i3 < methods.length; ++i3) {
                MethodSignature m = methods[i3];
                desc = m.signature;
                desc = desc.replace('/', '.');
                data.writeUTF(m.member.getName());
                data.writeInt(m.member.getModifiers());
                data.writeUTF(desc);
            }
            data.flush();
            byte[] hasharray = md.digest();
            for (int i4 = 0; i4 < Math.min(8, hasharray.length); ++i4) {
                h += (long)(hasharray[i4] & 0xFF) << i4 * 8;
            }
        }
        catch (IOException ignore) {
            h = -1L;
        }
        catch (NoSuchAlgorithmException complain) {
            throw new SecurityException(complain.getMessage());
        }
        return h;
    }

    private static String getSignature(Class clazz) {
        String type = null;
        if (clazz.isArray()) {
            Class<?> cl = clazz;
            int dimensions = 0;
            while (cl.isArray()) {
                ++dimensions;
                cl = cl.getComponentType();
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < dimensions; ++i) {
                sb.append("[");
            }
            sb.append(ObjectStreamClassUtil_1_3.getSignature(cl));
            type = sb.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                type = "I";
            } else if (clazz == Byte.TYPE) {
                type = "B";
            } else if (clazz == Long.TYPE) {
                type = "J";
            } else if (clazz == Float.TYPE) {
                type = "F";
            } else if (clazz == Double.TYPE) {
                type = "D";
            } else if (clazz == Short.TYPE) {
                type = "S";
            } else if (clazz == Character.TYPE) {
                type = "C";
            } else if (clazz == Boolean.TYPE) {
                type = "Z";
            } else if (clazz == Void.TYPE) {
                type = "V";
            }
        } else {
            type = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return type;
    }

    private static String getSignature(Method meth) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Class<?>[] params = meth.getParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            sb.append(ObjectStreamClassUtil_1_3.getSignature(params[j]));
        }
        sb.append(")");
        sb.append(ObjectStreamClassUtil_1_3.getSignature(meth.getReturnType()));
        return sb.toString();
    }

    private static String getSignature(Constructor cons) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Class<?>[] params = cons.getParameterTypes();
        for (int j = 0; j < params.length; ++j) {
            sb.append(ObjectStreamClassUtil_1_3.getSignature(params[j]));
        }
        sb.append(")V");
        return sb.toString();
    }

    private static Field[] getDeclaredFields(final Class clz) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clz.getDeclaredFields();
            }
        });
    }

    private static boolean hasStaticInitializer(Class cl) {
        if (hasStaticInitializerMethod == null) {
            Class<Object> classWithThisMethod = null;
            try {
                try {
                    classWithThisMethod = Class.forName("sun.misc.ClassReflector");
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
                if (classWithThisMethod == null) {
                    classWithThisMethod = java.io.ObjectStreamClass.class;
                }
                hasStaticInitializerMethod = classWithThisMethod.getDeclaredMethod("hasStaticInitializer", Class.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (hasStaticInitializerMethod == null) {
                throw new InternalError("Can't find hasStaticInitializer method on " + classWithThisMethod.getName());
            }
            hasStaticInitializerMethod.setAccessible(true);
        }
        try {
            Boolean retval = (Boolean)hasStaticInitializerMethod.invoke(null, cl);
            return retval;
        }
        catch (Exception ex) {
            throw new InternalError("Error invoking hasStaticInitializer: " + ex);
        }
    }

    private static Method getDeclaredMethod(final Class cl, final String methodName, final int requiredModifierMask, final int disallowedModifierMask, final Class ... args) {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method = null;
                try {
                    method = cl.getDeclaredMethod(methodName, args);
                    int mods = method.getModifiers();
                    if ((mods & disallowedModifierMask) != 0 || (mods & requiredModifierMask) != requiredModifierMask) {
                        method = null;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return method;
            }
        });
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        static MethodSignature[] removePrivateAndSort(Member[] m) {
            int numNonPrivate = 0;
            for (int i = 0; i < m.length; ++i) {
                if (Modifier.isPrivate(m[i].getModifiers())) continue;
                ++numNonPrivate;
            }
            MethodSignature[] cm = new MethodSignature[numNonPrivate];
            int cmi = 0;
            for (int i = 0; i < m.length; ++i) {
                if (Modifier.isPrivate(m[i].getModifiers())) continue;
                cm[cmi] = new MethodSignature(m[i]);
                ++cmi;
            }
            if (cmi > 0) {
                Arrays.sort(cm, cm[0]);
            }
            return cm;
        }

        public int compare(Object o1, Object o2) {
            int result;
            if (o1 == o2) {
                return 0;
            }
            MethodSignature c1 = (MethodSignature)o1;
            MethodSignature c2 = (MethodSignature)o2;
            if (this.isConstructor()) {
                result = c1.signature.compareTo(c2.signature);
            } else {
                result = c1.member.getName().compareTo(c2.member.getName());
                if (result == 0) {
                    result = c1.signature.compareTo(c2.signature);
                }
            }
            return result;
        }

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member m) {
            this.member = m;
            this.signature = this.isConstructor() ? ObjectStreamClassUtil_1_3.getSignature((Constructor)m) : ObjectStreamClassUtil_1_3.getSignature((Method)m);
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = ((Member)o1).getName();
            String s2 = ((Member)o2).getName();
            if (o1 instanceof Method) {
                s1 = s1 + ObjectStreamClassUtil_1_3.getSignature((Method)o1);
                s2 = s2 + ObjectStreamClassUtil_1_3.getSignature((Method)o2);
            } else if (o1 instanceof Constructor) {
                s1 = s1 + ObjectStreamClassUtil_1_3.getSignature((Constructor)o1);
                s2 = s2 + ObjectStreamClassUtil_1_3.getSignature((Constructor)o2);
            }
            return s1.compareTo(s2);
        }
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        public int compare(Object o1, Object o2) {
            Class c1 = (Class)o1;
            Class c2 = (Class)o2;
            return c1.getName().compareTo(c2.getName());
        }
    }
}

