/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.corba.ee.impl.codegen.ClassGenerator;
import com.sun.corba.ee.spi.codegen.Expression;
import com.sun.corba.ee.spi.codegen.Type;
import com.sun.corba.ee.spi.codegen.Wrapper;
import com.sun.ejb.EJBUtils;
import com.sun.ejb.codegen.ClassGeneratorFactory;
import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.codegen.InvalidBean;
import com.sun.ejb.codegen.WrapperGenerator;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.ejb.EJBObject;
import sun.rmi.rmic.IndentingWriter;

public class Remote30WrapperGenerator
extends Generator
implements ClassGeneratorFactory {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(WrapperGenerator.class);
    private static Logger _logger = null;
    private String remoteInterfaceName;
    private Class businessInterface;
    private String remoteClientClassName;
    private String remoteClientPackageName;
    private String remoteClientSimpleName;
    private Method[] bizMethods;
    private ClassLoader loader;

    public String getGeneratedClass() {
        return this.remoteClientClassName;
    }

    public String className() {
        return this.getGeneratedClass();
    }

    public Remote30WrapperGenerator(ClassLoader cl, String businessIntfName, String remoteIntfName) throws GeneratorException {
        this.remoteInterfaceName = remoteIntfName;
        this.loader = cl;
        try {
            this.businessInterface = cl.loadClass(businessIntfName);
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidBean(localStrings.getLocalString("generator.remote_interface_not_found", "Business interface " + this.businessInterface + " not found "));
        }
        if (EJBObject.class.isAssignableFrom(this.businessInterface)) {
            throw new GeneratorException("Invalid Remote Business Interface " + this.businessInterface + ". A Remote Business interface MUST " + "not extend javax.ejb.EJBObject.");
        }
        this.remoteClientClassName = EJBUtils.getGeneratedRemoteWrapperName(this.businessInterface.getName());
        this.remoteClientPackageName = this.getPackageName(this.remoteClientClassName);
        this.remoteClientSimpleName = this.getBaseName(this.remoteClientClassName);
        this.bizMethods = this.removeDups(this.businessInterface.getMethods());
    }

    public ClassGenerator evaluate() {
        Wrapper._clear();
        if (this.remoteClientPackageName != null) {
            Wrapper._package(this.remoteClientPackageName);
        } else {
            Wrapper._package();
        }
        Wrapper._class(1, this.remoteClientSimpleName, Wrapper._t("com.sun.ejb.containers.RemoteBusinessWrapperBase"), Wrapper._t(this.businessInterface.getName()));
        Wrapper._data(2, Wrapper._t(this.remoteInterfaceName), "delegate_");
        Wrapper._constructor(1, new Type[0]);
        Wrapper._arg(Wrapper._t(this.remoteInterfaceName), "stub");
        Wrapper._arg(Wrapper._String(), "busIntf");
        Wrapper._body();
        Wrapper._expr(Wrapper._super(Wrapper._s(Wrapper._void(), Wrapper._t("java.rmi.Remote"), Wrapper._String()), Wrapper._v("stub"), Wrapper._v("busIntf")));
        Wrapper._assign(Wrapper._v("delegate_"), Wrapper._v("stub"));
        Wrapper._end();
        for (int i = 0; i < this.bizMethods.length; ++i) {
            this.printMethodImpl(this.bizMethods[i]);
        }
        Wrapper._end();
        return Wrapper._classGenerator();
    }

    public void generate(OutputStream out) throws GeneratorException, IOException {
        IndentingWriter p = new IndentingWriter(new OutputStreamWriter(out));
        if (this.remoteClientPackageName != null) {
            p.pln("package " + this.remoteClientPackageName + ";");
        }
        p.plnI("public final class " + this.remoteClientSimpleName + " extends com.sun.ejb.containers.RemoteBusinessWrapperBase" + " implements " + this.businessInterface.getName() + " {");
        p.pln("");
        p.pln("private " + this.remoteInterfaceName + " delegate_;");
        p.pln("");
        p.plnI("public " + this.remoteClientSimpleName + "(" + this.remoteInterfaceName + " stub" + " , " + "java.lang.String busIntf" + ")" + " {");
        p.pln("super(stub, busIntf);");
        p.pln("");
        p.pln("delegate_ = stub;");
        p.pOln("}");
        p.pln("");
        for (int i = 0; i < this.bizMethods.length; ++i) {
            this.printMethodImpl(p, this.bizMethods[i]);
        }
        p.pOln("}");
        p.close();
    }

    private void printMethodImpl(Method m) {
        boolean doExceptionTranslation;
        LinkedList<Type> exceptionList = new LinkedList<Type>();
        for (Class<?> exception : m.getExceptionTypes()) {
            exceptionList.add(Type.type(exception));
        }
        Wrapper._method(1, Type.type(m.getReturnType()), m.getName(), exceptionList);
        int i = 0;
        LinkedList<Type> expressionListTypes = new LinkedList<Type>();
        LinkedList<Expression> expressionList = new LinkedList<Expression>();
        for (Class<?> param : m.getParameterTypes()) {
            String paramName = "param" + i;
            Wrapper._arg(Type.type(param), paramName);
            ++i;
            expressionListTypes.add(Type.type(param));
            expressionList.add(Wrapper._v(paramName));
        }
        Wrapper._body();
        Wrapper._try();
        Class<?> returnType = m.getReturnType();
        if (returnType == Void.TYPE) {
            Wrapper._expr(Wrapper._call(Wrapper._v("delegate_"), m.getName(), Wrapper._s(Type.type(returnType), expressionListTypes), expressionList));
        } else {
            Wrapper._return(Wrapper._call(Wrapper._v("delegate_"), m.getName(), Wrapper._s(Type.type(returnType), expressionListTypes), expressionList));
        }
        boolean bl = doExceptionTranslation = !Remote.class.isAssignableFrom(this.businessInterface);
        if (doExceptionTranslation) {
            Wrapper._catch(Wrapper._t("javax.transaction.TransactionRolledbackException"), "trex");
            Wrapper._define(Wrapper._t("java.lang.RuntimeException"), "r", Wrapper._new(Wrapper._t("javax.ejb.EJBTransactionRolledbackException"), Wrapper._s(Wrapper._void(), new Type[0]), new Expression[0]));
            Wrapper._expr(Wrapper._call(Wrapper._v("r"), "initCause", Wrapper._s(Wrapper._t("java.lang.Throwable"), Wrapper._t("java.lang.Throwable")), Wrapper._v("trex")));
            Wrapper._throw(Wrapper._v("r"));
            Wrapper._catch(Wrapper._t("javax.transaction.TransactionRequiredException"), "treqex");
            Wrapper._define(Wrapper._t("java.lang.RuntimeException"), "r", Wrapper._new(Wrapper._t("javax.ejb.EJBTransactionRequiredException"), Wrapper._s(Wrapper._void(), new Type[0]), new Expression[0]));
            Wrapper._expr(Wrapper._call(Wrapper._v("r"), "initCause", Wrapper._s(Wrapper._t("java.lang.Throwable"), Wrapper._t("java.lang.Throwable")), Wrapper._v("treqex")));
            Wrapper._throw(Wrapper._v("r"));
            Wrapper._catch(Wrapper._t("java.rmi.NoSuchObjectException"), "nsoe");
            Wrapper._define(Wrapper._t("java.lang.RuntimeException"), "r", Wrapper._new(Wrapper._t("javax.ejb.NoSuchEJBException"), Wrapper._s(Wrapper._void(), new Type[0]), new Expression[0]));
            Wrapper._expr(Wrapper._call(Wrapper._v("r"), "initCause", Wrapper._s(Wrapper._t("java.lang.Throwable"), Wrapper._t("java.lang.Throwable")), Wrapper._v("nsoe")));
            Wrapper._throw(Wrapper._v("r"));
            Wrapper._catch(Wrapper._t("com.sun.ejb.containers.InternalEJBContainerException"), "iejbcEx");
            Wrapper._define(Wrapper._t("com.sun.ejb.containers.ParallelAccessException"), "paEx", Wrapper._cast(Wrapper._t("com.sun.ejb.containers.ParallelAccessException"), Wrapper._v("iejbcEx")));
            Wrapper._define(Wrapper._t("javax.ejb.ConcurrentAccessException"), "r", Wrapper._new(Wrapper._t("javax.ejb.ConcurrentAccessException"), Wrapper._s(Wrapper._void(), new Type[0]), new Expression[0]));
            Wrapper._expr(Wrapper._call(Wrapper._v("r"), "initCause", Wrapper._s(Wrapper._t("java.lang.Throwable"), Wrapper._t("java.lang.Throwable")), Wrapper._v("paEx")));
            Wrapper._throw(Wrapper._v("r"));
            Wrapper._catch(Wrapper._t("java.rmi.RemoteException"), "re");
            Wrapper._throw(Wrapper._new(Wrapper._t("javax.ejb.EJBException"), Wrapper._s(Wrapper._void(), Wrapper._t("java.lang.Exception")), Wrapper._v("re")));
            Wrapper._end();
        } else {
            Wrapper._catch(Wrapper._t("com.sun.ejb.containers.InternalEJBContainerException"), "iejbcEx");
            Wrapper._throw(Wrapper._new(Wrapper._t("com.sun.ejb.containers.InternalRemoteException"), Wrapper._s(Wrapper._void(), Wrapper._t("com.sun.ejb.containers.InternalEJBContainerException")), Wrapper._v("iejbcEx")));
            Wrapper._end();
        }
        Wrapper._end();
    }

    private void printMethodImpl(IndentingWriter p, Method m) throws IOException {
        int i;
        p.p("public " + this.printType(m.getReturnType()) + " " + m.getName() + "(");
        Class<?>[] params = m.getParameterTypes();
        for (int i2 = 0; i2 < params.length; ++i2) {
            if (i2 != 0) {
                p.p(", ");
            }
            p.p(this.printType(params[i2]) + " param" + i2);
        }
        p.p(") ");
        Class<?>[] exceptions = m.getExceptionTypes();
        for (i = 0; i < exceptions.length; ++i) {
            if (i == 0) {
                p.p("throws ");
            } else {
                p.p(", ");
            }
            p.p(exceptions[i].getName());
        }
        p.plnI("{");
        if (!Remote.class.isAssignableFrom(this.businessInterface)) {
            p.pln("try {");
        }
        if (m.getReturnType() != Void.TYPE) {
            p.p("    return ");
        }
        p.p("    delegate_." + m.getName() + "(");
        for (i = 0; i < params.length; ++i) {
            if (i != 0) {
                p.p(" , ");
            }
            p.p("param" + i);
        }
        p.pln(");");
        if (!Remote.class.isAssignableFrom(this.businessInterface)) {
            p.pln("} catch(javax.transaction.TransactionRolledbackException trex) {");
            p.pln("\tjava.lang.RuntimeException r =  new javax.ejb.EJBTransactionRolledbackException();");
            p.pln("\tr.initCause(trex);");
            p.pln("\tthrow r;");
            p.pln("} catch(java.rmi.NoSuchObjectException nsoe) {");
            p.pln("\tjava.lang.RuntimeException r =  new javax.ejb.NoSuchEJBException();");
            p.pln("\tr.initCause(nsoe);");
            p.pln("\tthrow r;");
            p.pln("} catch(javax.transaction.TransactionRequiredException txre) {");
            p.pln("\tjava.lang.RuntimeException r =  new javax.ejb.EJBTransactionRequiredException();");
            p.pln("\tr.initCause(txre);");
            p.pln("\tthrow r;");
            p.pln("} catch(java.rmi.RemoteException re) {");
            p.pln("\tthrow new javax.ejb.EJBException(re);");
            p.pln("} ");
        }
        p.pln("");
        p.pOln("} ");
        p.pln("");
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    }
}

