/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.channel;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;
import com.sun.enterprise.admin.server.core.channel.RemoteAdminChannel;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RMIClient
implements Runnable {
    private File stubFile;
    private File seedFile;
    private long stubFileTs = 0L;
    private byte[] key;
    private RemoteAdminChannel stub;
    private boolean autoRefresh;
    private long autoRefreshInterval;
    private Thread autoRefreshThread;
    private static StringManager localStrings = StringManager.getManager(RMIClient.class);
    private static final String CLIENT_NULLARGS_ERRCODE = "channel.client_nullargs";
    private static final String CLIENT_NULLARGS_ERRMSG = localStrings.getString("admin.server.core.channel.attempt_initializing_channel_client_with_null_arguments");
    private static final String CLIENT_INIT_ERROR = "channel.client_init_error";
    private static final String EVENT_NOTIFY_ERROR = "channel.event_notify_error";
    private static final String EVENT_RENOTIFY_ERROR = "channel.event_renotify_error";
    private static final String AUTO_REFRESH_INTR = "channel.auto_refresh_intr";
    private static final String CHANNEL_COMM_ERROR = "channel.comm_error";
    private static final String INVALID_AUTO_REFRESH_INTERVAL = localStrings.getString("admin.server.core.channel.invalid_auto_refresh_interval");
    static final String FILE_READ_ERROR = "channel.file_read_error";
    static final String SEED_FILE_OLDER = "channel.seed_file_older";
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    RMIClient(String stubFile, String seedFile) {
        if (stubFile == null || seedFile == null) {
            RMIClient.warn(CLIENT_NULLARGS_ERRCODE);
            throw new IllegalArgumentException(CLIENT_NULLARGS_ERRMSG);
        }
        this.stubFile = new File(stubFile);
        this.seedFile = new File(seedFile);
        if (this.stubFile.exists()) {
            this.stub = this.readStub();
        }
        if (AdminChannel.getClientAutoRefreshEnabled()) {
            this.startAutoRefreshThread(AdminChannel.getClientAutoRefreshInterval());
        }
    }

    public RMIClient(boolean isDebug, String stubFile, String seedFile) {
        if (!isDebug) {
            logger.setLevel(Level.SEVERE);
        }
        if (stubFile == null || seedFile == null) {
            throw new IllegalArgumentException(CLIENT_NULLARGS_ERRMSG);
        }
        this.stubFile = new File(stubFile);
        this.seedFile = new File(seedFile);
        if (this.stubFile.exists()) {
            this.stub = this.readStub();
        }
    }

    void startAutoRefreshThread(long interval) {
        if (interval <= 0L) {
            throw new IllegalArgumentException(INVALID_AUTO_REFRESH_INTERVAL);
        }
        this.autoRefresh = true;
        this.autoRefreshInterval = interval;
        if (this.autoRefreshThread != null && this.autoRefreshThread.isAlive()) {
            return;
        }
        this.autoRefreshThread = new Thread(this);
        this.autoRefreshThread.start();
    }

    void stopAutoRefreshThread() {
        this.autoRefresh = false;
    }

    public void run() {
        while (this.autoRefresh) {
            try {
                Thread.sleep(this.autoRefreshInterval);
            }
            catch (InterruptedException ie) {
                RMIClient.warn(AUTO_REFRESH_INTR);
                this.autoRefresh = false;
            }
            if (!this.autoRefresh) continue;
            this.checkServerStatus();
        }
    }

    public AdminEventResult sendNotification(AdminEvent event) {
        boolean doRetry = true;
        AdminEventResult result = null;
        if (this.stub != null) {
            try {
                result = this.stub.sendNotification(this.key, event);
                doRetry = false;
            }
            catch (ServerException re) {
                if (re.detail != null && (re.detail instanceof IllegalArgumentException || re.detail instanceof SecurityException)) {
                    doRetry = false;
                    RMIClient.warn(EVENT_NOTIFY_ERROR);
                    RMIClient.debug(re.detail);
                } else {
                    if (re.detail != null) {
                        RMIClient.debug(re.detail);
                    }
                    RMIClient.debug(re);
                }
            }
            catch (RemoteException re) {
                if (re.detail != null) {
                    RMIClient.debug(re.detail);
                }
                RMIClient.debug(re);
            }
        }
        if (doRetry) {
            boolean gotNew = this.checkServerStatus();
            if (this.stub != null && gotNew) {
                try {
                    result = this.stub.sendNotification(this.key, event);
                }
                catch (RemoteException re) {
                    RMIClient.warn(EVENT_RENOTIFY_ERROR);
                    if (re.detail != null) {
                        RMIClient.debug(re.detail);
                    }
                    RMIClient.debug(re);
                }
            }
        }
        if (result == null) {
            result = new AdminEventResult(event.getSequenceNumber());
            result.setResultCode("transmission_error");
            if (this.stub == null) {
                result.addMessage(event.getEffectiveDestination(), "Remote Stub is null");
            }
        }
        return result;
    }

    public boolean isAlive() {
        return this.isAlive(false);
    }

    public boolean isAlive(boolean refreshStub) {
        if (refreshStub) {
            boolean gotNew = this.checkServerStatus();
        }
        boolean isAlive = true;
        if (this.stub != null) {
            try {
                this.stub.pingServer(this.key);
            }
            catch (RemoteException re) {
                RMIClient.debug(re);
                isAlive = false;
            }
        } else {
            isAlive = false;
        }
        return isAlive;
    }

    public int getInstanceStatusCode() {
        boolean gotNew = this.checkServerStatus();
        int statusCode = 3;
        if (this.stub != null) {
            try {
                statusCode = this.stub.getServerStatusCode(this.key);
            }
            catch (RemoteException re) {
                RMIClient.debug(CHANNEL_COMM_ERROR, this.stubFile.getName());
                if (re.detail != null) {
                    RMIClient.trace(re.detail);
                }
                RMIClient.trace(re);
            }
            catch (IllegalArgumentException iae) {
                RMIClient.debug(CHANNEL_COMM_ERROR, this.stubFile.getName());
                RMIClient.trace(iae);
                byte[] newKey = null;
                try {
                    newKey = this.readSeed();
                }
                catch (IOException ioe) {
                    RMIClient.debug(FILE_READ_ERROR, this.seedFile.getName());
                    RMIClient.trace(ioe);
                }
                if (newKey != null) {
                    this.key = newKey;
                }
                throw iae;
            }
        }
        return statusCode;
    }

    public int getConflictedPort() {
        int conflictedPort = 0;
        boolean gotNew = this.checkServerStatus();
        if (this.stub != null) {
            try {
                conflictedPort = this.stub.getConflictedPort(this.key);
            }
            catch (RemoteException re) {
                RMIClient.debug(CHANNEL_COMM_ERROR, this.stubFile.getName());
                if (re.detail != null) {
                    RMIClient.trace(re.detail);
                }
                RMIClient.trace(re);
            }
        }
        return conflictedPort;
    }

    public void triggerServerExit() {
        boolean gotNew = this.checkServerStatus();
        if (this.stub != null) {
            try {
                this.stub.triggerServerExit(this.key);
            }
            catch (RemoteException re) {
                RMIClient.debug(CHANNEL_COMM_ERROR, this.stubFile.getName());
                if (re.detail != null) {
                    RMIClient.trace(re.detail);
                }
                RMIClient.trace(re);
            }
        }
    }

    public boolean isRestartNeeded() {
        boolean restartNeeded = false;
        boolean gotNew = this.checkServerStatus();
        if (this.stub != null) {
            try {
                restartNeeded = this.stub.isRestartNeeded(this.key);
            }
            catch (RemoteException re) {
                RMIClient.debug(CHANNEL_COMM_ERROR, this.stubFile.getName());
                if (re.detail != null) {
                    RMIClient.trace(re.detail);
                }
                RMIClient.trace(re);
            }
        }
        return restartNeeded;
    }

    public void setRestartNeeded(boolean restartNeeded) {
        boolean gotNew = this.checkServerStatus();
        if (this.stub != null) {
            try {
                this.stub.setRestartNeeded(this.key, restartNeeded);
            }
            catch (RemoteException re) {
                RMIClient.debug(CHANNEL_COMM_ERROR, this.stubFile.getName());
                if (re.detail != null) {
                    RMIClient.trace(re.detail);
                }
                RMIClient.trace(re);
            }
        }
    }

    private boolean checkServerStatus() {
        boolean gotNew = false;
        if (this.stubFile.exists()) {
            long ts = this.stubFile.lastModified();
            if (ts > this.stubFileTs) {
                if (this.stubFile.canRead()) {
                    RemoteAdminChannel obj = this.readStub();
                    if (obj != null) {
                        gotNew = true;
                        this.stub = obj;
                    }
                } else {
                    RMIClient.warn(FILE_READ_ERROR, this.stubFile.getName());
                }
            }
        } else if (this.stub != null) {
            this.stub = null;
        }
        return gotNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private RemoteAdminChannel readStub() {
        block17: {
            obj = null;
            fis = null;
            try {
                this.stubFileTs = this.stubFile.lastModified();
                fis = new FileInputStream(this.stubFile);
                ois = new ObjectInputStream(fis);
                obj = (RemoteAdminChannel)ois.readObject();
                var5_7 = null;
                ** if (fis == null) goto lbl-1000
            }
            catch (Throwable var4_15) {
                var5_10 = null;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                throw var4_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
lbl-1000:
            // 2 sources

            {
                break block17;
                catch (IOException ioe) {
                    RMIClient.warn("channel.client_init_error");
                    RMIClient.debug(ioe);
                    var5_8 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ioe) {}
                    }
                    break block17;
                }
                catch (ClassNotFoundException cnfe) {
                    RMIClient.warn("channel.client_init_error");
                    RMIClient.debug(cnfe);
                    var5_9 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
        }
        try {
            this.key = this.readSeed();
        }
        catch (IOException ioe) {
            RMIClient.warn("channel.client_init_error");
            RMIClient.debug(ioe);
            obj = null;
        }
        if (obj == null) {
            this.stubFileTs = 0L;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private byte[] readSeed() throws IOException {
        block15: {
            seed = null;
            if (this.seedFile.exists() && this.seedFile.canRead()) {
                seedFileTs = this.seedFile.lastModified();
                if (seedFileTs >= this.stubFileTs) {
                    fis = null;
                    try {
                        fis = new FileInputStream(this.seedFile);
                        seed = new byte[16];
                        fis.read(seed);
                        var7_5 = null;
                        ** if (fis == null) goto lbl-1000
                    }
                    catch (Throwable var6_12) {
                        var7_7 = null;
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                        }
                        throw var6_12;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            fis.close();
                        }
                        catch (IOException ioe) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block15;
                        catch (IOException ioe) {
                            RMIClient.warn("channel.key_read_error");
                            RMIClient.debug(ioe);
                            seed = null;
                            var7_6 = null;
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException ioe) {}
                            }
                            break block15;
                        }
                    }
                }
                RMIClient.debug("channel.seed_file_older", new Long[]{new Long(seedFileTs), new Long(this.stubFileTs)});
            } else {
                RMIClient.warn("channel.key_read_error");
                RMIClient.debug("channel.file_read_error", this.seedFile.getName());
            }
        }
        if (seed == null) {
            msg = RMIClient.localStrings.getString("admin.server.core.channel.unable_initializing_key", this.seedFile);
            throw new IOException(msg);
        }
        return seed;
    }

    public boolean hasRestartedSince(long ts) {
        return this.hasRestartedSince(ts, false);
    }

    public boolean hasRestartedSince(long ts, boolean refreshStub) {
        if (refreshStub) {
            boolean gotNew = this.checkServerStatus();
        }
        boolean restarted = false;
        if (this.stubFile != null && this.stubFileTs > ts) {
            restarted = true;
        }
        return restarted;
    }

    static void trace(Throwable t) {
        logger.log(Level.FINEST, t.getMessage(), t);
    }

    static void warn(String s) {
        logger.warning(s);
    }

    static void warn(String msgkey, String obj1) {
        logger.log(Level.WARNING, msgkey, obj1);
    }

    static void debug(String s) {
        logger.fine(s);
    }

    static void debug(String msgkey, String obj1) {
        logger.log(Level.FINE, msgkey, obj1);
    }

    static void debug(String msgkey, Object[] objarr) {
        logger.log(Level.FINE, msgkey, objarr);
    }

    static void debug(Throwable t) {
        logger.log(Level.FINE, t.getMessage(), t);
    }
}

