/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier;

import com.sun.enterprise.admin.common.exception.AFRuntimeException;
import com.sun.enterprise.admin.verifier.Result;
import com.sun.enterprise.admin.verifier.ServerCheck;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigContextEventListener;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.TestInformation;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerMgr
implements ConfigContextEventListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    public String testFileName = "ServerTestList.xml";
    public static HashMap testCases = new HashMap();
    public static String fileUrl = null;
    public String description = "Tests for server.xml";
    public boolean debug;
    public Result result = null;
    public Vector vresult = null;
    public LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public ServerMgr() {
        this.debug = false;
    }

    public ServerMgr(boolean verbose) {
        this.debug = true;
    }

    public static void setFile(String file) {
        fileUrl = file;
    }

    public boolean loadTestInfo() {
        boolean allIsWell = true;
        if (testCases.isEmpty()) {
            if (this.debug) {
                _logger.log(Level.INFO, "serverxmlverifier.getting_testnamefrom_propertyfile");
            }
            File inputFile = this.getTestFile(this.testFileName);
            try {
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = db.parse(inputFile);
                NodeList list = doc.getElementsByTagName("description");
                if (list.getLength() > 0) {
                    Element e = (Element)list.item(0);
                    this.description = e.getFirstChild().getNodeValue().trim();
                }
                list = doc.getElementsByTagName("test");
                for (int i = 0; i < list.getLength(); ++i) {
                    Element e = (Element)list.item(i);
                    NodeList nl = e.getChildNodes();
                    TestInformation ti = new TestInformation();
                    String testName = "";
                    for (int j = 0; j < nl.getLength(); ++j) {
                        Node el;
                        String nodeName = nl.item(j).getNodeName();
                        if ("test-name".equals(nodeName.trim())) {
                            el = nl.item(j);
                            testName = el.getFirstChild().getNodeValue().trim();
                        }
                        if ("test-class".equals(nodeName.trim())) {
                            el = nl.item(j);
                            ti.setClassName(el.getFirstChild().getNodeValue().trim());
                        }
                        if ("minimum-version".equals(nodeName.trim())) {
                            el = nl.item(j);
                            ti.setMinimumVersion(el.getFirstChild().getNodeValue().trim());
                        }
                        if (!"maximum-version".equals(nodeName.trim())) continue;
                        el = nl.item(j);
                        ti.setMaximumVersion(el.getFirstChild().getNodeValue().trim());
                    }
                    testCases.put(testName, ti);
                }
            }
            catch (ParserConfigurationException e) {
                _logger.log(Level.WARNING, "serverxmlverifier.parser_error", e);
                allIsWell = false;
            }
            catch (SAXException e) {
                _logger.log(Level.WARNING, "serverxmlverifier.sax_error", e);
                allIsWell = false;
            }
            catch (IOException e) {
                _logger.log(Level.WARNING, "serverxmlverifier.error_loading_xmlfile");
                allIsWell = false;
            }
        }
        return allIsWell;
    }

    public HashMap getTests() {
        return testCases;
    }

    private File getTestFile(String name) {
        String iasHome = System.getProperty("s1as.home");
        if (iasHome != null) {
            File temp = new File(iasHome, "lib");
            if ((temp = new File(temp, name)).exists()) {
                return temp;
            }
            return null;
        }
        return this.getFileFromCP(name);
    }

    private File getFileFromCP(String name) {
        File cand = null;
        String classPath = System.getProperty("java.class.path");
        String classPathSep = File.pathSeparator;
        StringTokenizer tokens = new StringTokenizer(classPath, classPathSep);
        while (tokens.hasMoreTokens()) {
            String fileName = tokens.nextToken();
            if (!fileName.endsWith("appserv-rt.jar")) continue;
            int slashPos = fileName.lastIndexOf(47);
            if (slashPos == -1) {
                slashPos = fileName.lastIndexOf(File.separator);
            }
            if (slashPos == -1) break;
            String libPath = fileName.substring(0, slashPos);
            cand = new File(libPath, name);
            break;
        }
        return cand;
    }

    public boolean check(ConfigContextEvent ccce) {
        String testClass;
        TestInformation ti;
        String name = ccce.getName();
        Object value = ccce.getObject();
        ConfigContext context = ccce.getConfigContext();
        String choice = ccce.getChoice();
        String beanName = ccce.getBeanName();
        if (name == null && beanName == null) {
            return true;
        }
        boolean retValue = false;
        if (testCases.isEmpty()) {
            this.loadTestInfo();
        }
        if ((ti = (TestInformation)testCases.get(name)) == null && beanName != null) {
            ti = (TestInformation)testCases.get(beanName);
        }
        try {
            testClass = ti.getClassName();
        }
        catch (Exception e) {
            return true;
        }
        try {
            Class<?> test = Class.forName(testClass);
            ServerCheck tester = (ServerCheck)test.newInstance();
            this.result = tester.check(ccce);
            retValue = this.result.getStatus() == 0;
        }
        catch (Throwable tt) {
            _logger.log(Level.FINE, "serverxmlverifier.error_check", tt);
            retValue = true;
        }
        return retValue;
    }

    public void postAccessNotification(ConfigContextEvent ccce) {
    }

    public void postChangeNotification(ConfigContextEvent ccce) {
    }

    public void preAccessNotification(ConfigContextEvent ccce) {
    }

    public void preChangeNotification(ConfigContextEvent ccce) {
        if (!this.check(ccce)) {
            throw new AFRuntimeException(this.result.getErrorDetails().toString());
        }
    }
}

